/*
 * Decompiled with CFR 0.152.
 */
package com.lynxspring.control.datatypes;

import com.lynxspring.control.datatypes.BAbstractUnitEnum;
import javax.baja.sys.BDynamicEnum;
import javax.baja.sys.BEnumRange;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;

public final class BCombustible
extends BAbstractUnitEnum {
    private static final String[] unitsText = new String[]{BCombustible.makeTag("megaBtus per hour (MBH)"), BCombustible.makeTag("therms per hour (therms/hr)"), BCombustible.makeTag("Btus per hour (Btu/h)")};
    public static final double[] units = new double[]{0.01, 0.01, 1.0E-5};
    public static final BEnumRange unitRange = BEnumRange.make((String[])unitsText);
    public static final BCombustible DEFAULT = (BCombustible)BCombustible.make(70.0, unitsText[0]);
    public static final Type TYPE = Sys.loadType(BCombustible.class);
    private BDynamicEnum unitEnum = BDynamicEnum.make((int)0, (BEnumRange)unitRange);

    public static BAbstractUnitEnum make(double value, String unit) {
        return new BCombustible(value, unit);
    }

    @Override
    public BAbstractUnitEnum remake(double value, String unit) {
        return BCombustible.make(value, unit);
    }

    private BCombustible(double value, String unit) {
        this.value = value;
        int u = 0;
        try {
            u = unitRange.get(BCombustible.makeTag(unit)).getOrdinal();
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.unitEnum = BDynamicEnum.make((int)u, (BEnumRange)unitRange);
    }

    @Override
    String getDataTypeName() {
        return "combustible";
    }

    @Override
    public double[] getUnits() {
        return units;
    }

    @Override
    public BDynamicEnum getUnitsEnum() {
        return this.unitEnum;
    }

    @Override
    public BAbstractUnitEnum decode(String value, String unit) {
        double d;
        if (value.equals("+inf")) {
            d = Double.POSITIVE_INFINITY;
        }
        if (value.equals("-inf")) {
            d = Double.NEGATIVE_INFINITY;
        }
        if (value.equals("nan")) {
            d = Double.NaN;
        }
        double r = Double.parseDouble(value);
        return BCombustible.make(r, unit);
    }

    @Override
    public Type getType() {
        return TYPE;
    }
}

