/*
 * Decompiled with CFR 0.152.
 */
package com.lynxspring.control.datatypes;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.text.DecimalFormat;
import javax.baja.naming.SlotPath;
import javax.baja.nre.util.TextUtil;
import javax.baja.sys.BDynamicEnum;
import javax.baja.sys.BFacets;
import javax.baja.sys.BIComparable;
import javax.baja.sys.BINumeric;
import javax.baja.sys.BObject;
import javax.baja.sys.BSimple;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;

public abstract class BAbstractUnitEnum
extends BSimple
implements BIComparable,
BINumeric {
    public static final Type TYPE = Sys.loadType(BAbstractUnitEnum.class);
    double value;
    private static DecimalFormat fSN = new DecimalFormat("0.###############E0");
    private static final char seperator = ' ';
    private static final long MAX_LONG_PREC = 0x20000000000000L;

    public static BAbstractUnitEnum make(double value, String unit) {
        return null;
    }

    public BAbstractUnitEnum make(String s) {
        String[] split = TextUtil.split((String)s, (char)' ');
        String unit = "";
        if (split.length > 1) {
            for (int i = 1; i < split.length; ++i) {
                unit = unit + (i > 1 ? " " : "") + split[i];
            }
        }
        return this.decode(split[0], unit);
    }

    public abstract BAbstractUnitEnum remake(double var1, String var3);

    public int hashCode() {
        long hash = Double.doubleToLongBits(this.getNumeric());
        return (int)(hash ^ hash >>> 32);
    }

    public BObject decode(DataInput in) throws IOException {
        double value = in.readDouble();
        in.readByte();
        String unit = in.readLine();
        return this.remake(value, unit);
    }

    public BObject decodeFromString(String s) throws IOException {
        try {
            return this.make(s);
        }
        catch (RuntimeException e) {
            throw new IOException("Invalid " + this.getDataTypeName() + ": " + s);
        }
    }

    public void encode(DataOutput out) throws IOException {
        out.writeDouble(this.value);
        out.writeByte(32);
        out.writeBytes(SlotPath.unescape((String)this.getUnitsEnum().getTag()));
    }

    public String encodeToString() throws IOException {
        return BAbstractUnitEnum.encode(this.value, SlotPath.unescape((String)this.getUnitsEnum().getTag()));
    }

    public boolean equals(Object obj) {
        if (obj instanceof BAbstractUnitEnum) {
            return ((BAbstractUnitEnum)((Object)obj)).getNumeric() == this.getNumeric();
        }
        return false;
    }

    public static String encode(double value, String unit) {
        String r = "";
        r = value == Double.POSITIVE_INFINITY ? "+inf" : (value == Double.NEGATIVE_INFINITY ? "-inf" : (Double.isNaN(value) ? "+nan" : (Math.IEEEremainder(value, 1.0) == 0.0 ? ((long)Math.abs(value) >= 0x20000000000000L ? fSN.format(value) : String.valueOf((long)value)) : String.valueOf(value))));
        return r + ' ' + unit;
    }

    public abstract BAbstractUnitEnum decode(String var1, String var2);

    public int compareTo(Object obj) {
        double a = this.getNumeric();
        double b = Double.NaN;
        if (obj instanceof BAbstractUnitEnum) {
            b = ((BAbstractUnitEnum)((Object)obj)).getNumeric();
        }
        if (a == b) {
            return 0;
        }
        if (Double.isNaN(a) && Double.isNaN(b)) {
            return 0;
        }
        if (a < b) {
            return -1;
        }
        return 1;
    }

    public double getNumeric() {
        int unit = this.getUnitsEnum().getOrdinal();
        if (unit < 0 || unit > this.getUnits().length - 1) {
            unit = 0;
        }
        return this.value * this.getUnits()[unit];
    }

    public BFacets getNumericFacets() {
        return BFacets.NULL;
    }

    public double getValue() {
        return this.value;
    }

    public int getUnitOrdinal() {
        return this.getUnitsEnum().getOrdinal();
    }

    public double getUnitScale() {
        return this.getUnits()[this.getUnitOrdinal()];
    }

    public static String makeTag(String tag) {
        return SlotPath.escape((String)tag);
    }

    public abstract double[] getUnits();

    public abstract BDynamicEnum getUnitsEnum();

    abstract String getDataTypeName();

    public Type getType() {
        return TYPE;
    }
}

