/*
 * Decompiled with CFR 0.152.
 */
package com.lynxspring.control.conversion;

import com.lynxspring.control.BLicensedComponent;
import javax.baja.log.Log;
import javax.baja.naming.SlotPath;
import javax.baja.status.BStatusString;
import javax.baja.sys.BComplex;
import javax.baja.sys.BFacets;
import javax.baja.sys.BLink;
import javax.baja.sys.BObject;
import javax.baja.sys.BSimple;
import javax.baja.sys.BString;
import javax.baja.sys.BValue;
import javax.baja.sys.Context;
import javax.baja.sys.Property;
import javax.baja.sys.Slot;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;

public class BUniversalStringConverter
extends BLicensedComponent {
    public static final Property string = BUniversalStringConverter.newProperty((int)10, (String)"", null);
    public static final Property statusString = BUniversalStringConverter.newProperty((int)10, (BValue)new BStatusString(), null);
    public static final Property slotType = BUniversalStringConverter.newProperty((int)0, (String)"baja$3aString", (BFacets)BFacets.make((String)"fieldEditor", (String)"lynxKitControl:SimpleNamePickerFE"));
    public static final Type TYPE = Sys.loadType(BUniversalStringConverter.class);
    private Log log = Log.getLog((String)TYPE.getModule().getModuleName());
    private String curSelection = "";
    private static final String dynaSlotName = "Universal";

    public String getString() {
        return this.getString(string);
    }

    public void setString(String v) {
        this.setString(string, v, null);
    }

    public BStatusString getStatusString() {
        return (BStatusString)this.get(statusString);
    }

    public void setStatusString(BStatusString v) {
        this.set(statusString, (BValue)v, null);
    }

    public String getSlotType() {
        return this.getString(slotType);
    }

    public void setSlotType(String v) {
        this.setString(slotType, v, null);
    }

    @Override
    public Type getType() {
        return TYPE;
    }

    @Override
    public void started() {
        super.started();
        if (!this.isRunning() || !this.isLicensed()) {
            return;
        }
        this.curSelection = this.getSlotType();
        if (this.getSlot(dynaSlotName) == null) {
            this.add(dynaSlotName, (BValue)BString.DEFAULT, 8);
        }
        this.update(this.getSelection());
    }

    public void added(Property prop, Context cx) {
        if (!this.isRunning()) {
            return;
        }
        if (this.get(prop) instanceof BLink) {
            if (((BLink)this.get(prop)).getTargetSlot() == string) {
                this.removeLinks(this.getSlot(dynaSlotName));
                this.removeLinks((Slot)statusString);
            } else if (((BLink)this.get(prop)).getTargetSlot() == statusString) {
                this.removeLinks((Slot)string);
                this.removeLinks(this.getSlot(dynaSlotName));
            } else if (((BLink)this.get(prop)).getTargetSlot() == this.getSlot(dynaSlotName)) {
                this.removeLinks((Slot)string);
                this.removeLinks((Slot)statusString);
            }
            this.update(this.getSelection());
        }
    }

    public void changed(Property prop, Context cx) {
        if (!this.isRunning()) {
            return;
        }
        if (this.isStarted() && !this.checkLicense()) {
            return;
        }
        BSimple selection = this.getSelection();
        if (selection != null) {
            if (prop == slotType && !this.getSlotType().equals(this.curSelection)) {
                this.curSelection = this.getSlotType();
                this.removeLinks(this.getSlot(dynaSlotName));
                this.remove(dynaSlotName);
                this.add(dynaSlotName, (BValue)selection, 8);
                this.update(selection);
            } else {
                this.update((Slot)prop, selection);
            }
        }
    }

    private void update(BSimple selection) {
        if (!this.checkLicense()) {
            return;
        }
        if (this.getLinks((Slot)string).length > 0) {
            this.update((Slot)string, selection);
        } else if (this.getLinks((Slot)statusString).length > 0) {
            this.update((Slot)statusString, selection);
        } else if (this.getLinks(this.getSlot(dynaSlotName)).length > 0) {
            this.update(this.getSlot(dynaSlotName), selection);
        }
    }

    private void update(Slot slot, BSimple selection) {
        block8: {
            if (selection != null) {
                try {
                    if (slot == string && this.getLinks((Slot)string).length > 0) {
                        String newString = this.getString();
                        this.setStatusString(new BStatusString(newString));
                        this.set(dynaSlotName, (BValue)selection.decodeFromString(newString));
                    } else if (slot == statusString && this.getLinks((Slot)statusString).length > 0) {
                        String newString = this.getStatusString().getValue();
                        this.setString(newString);
                        this.set(dynaSlotName, (BValue)selection.decodeFromString(this.getString()));
                    } else if (slot == this.getSlot(dynaSlotName) && this.getLinks(this.getSlot(dynaSlotName)).length > 0) {
                        String newString = ((BSimple)this.get(dynaSlotName)).encodeToString();
                        this.setString(newString);
                        this.setStatusString(new BStatusString(newString));
                    }
                }
                catch (Exception e) {
                    if (!Sys.atSteadyState()) break block8;
                    this.log.error("Error converting value in Universal String Converter", (Throwable)e);
                }
            }
        }
    }

    private BSimple getSelection() {
        try {
            BObject selection = Sys.getType((String)SlotPath.unescape((String)this.getSlotType())).getInstance();
            if (selection instanceof BSimple) {
                return (BSimple)selection;
            }
            this.log.warning("Slot type not a BSimple in Universal String Converter");
            return null;
        }
        catch (Exception e) {
            this.log.warning("Slot type not found in Registry in Universal String Converter");
            return null;
        }
    }

    private void removeLinks(Slot slot) {
        if (slot == null) {
            return;
        }
        BLink[] links = this.getLinks(slot);
        for (int i = 0; i < links.length; ++i) {
            this.remove((BComplex)links[i]);
        }
    }
}

