/*
 * Decompiled with CFR 0.152.
 */
package com.lynxspring.control.conversion;

import com.lynxspring.control.BExecutableComponent;
import javax.baja.data.BIDataValue;
import javax.baja.status.BStatusNumeric;
import javax.baja.sys.BFacets;
import javax.baja.sys.BInteger;
import javax.baja.sys.BValue;
import javax.baja.sys.Property;
import javax.baja.sys.Slot;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.units.BUnit;

public class BTwo16BitTo32Bit
extends BExecutableComponent {
    public static final Property out = BTwo16BitTo32Bit.newProperty((int)11, (BValue)new BStatusNumeric(), (BFacets)BFacets.make((String)"precision", (BIDataValue)BInteger.make((int)0)));
    public static final Property inMs = BTwo16BitTo32Bit.newProperty((int)522, (BValue)new BStatusNumeric(), (BFacets)BFacets.make((String)"precision", (BIDataValue)BInteger.make((int)1)));
    public static final Property inLs = BTwo16BitTo32Bit.newProperty((int)522, (BValue)new BStatusNumeric(), (BFacets)BFacets.make((String)"precision", (BIDataValue)BInteger.make((int)1)));
    public static final Property outFacets = BTwo16BitTo32Bit.newProperty((int)0, (BValue)BFacets.NULL, null);
    public static final Property inFacets = BTwo16BitTo32Bit.newProperty((int)0, (BValue)BFacets.NULL, null);
    public static final Property outSigned = BTwo16BitTo32Bit.newProperty((int)512, (boolean)true, null);
    public static final Property inSigned = BTwo16BitTo32Bit.newProperty((int)512, (boolean)true, null);
    public static final Type TYPE = Sys.loadType(BTwo16BitTo32Bit.class);

    public BStatusNumeric getOut() {
        return (BStatusNumeric)this.get(out);
    }

    public void setOut(BStatusNumeric v) {
        this.set(out, (BValue)v, null);
    }

    public BStatusNumeric getInMs() {
        return (BStatusNumeric)this.get(inMs);
    }

    public void setInMs(BStatusNumeric v) {
        this.set(inMs, (BValue)v, null);
    }

    public BStatusNumeric getInLs() {
        return (BStatusNumeric)this.get(inLs);
    }

    public void setInLs(BStatusNumeric v) {
        this.set(inLs, (BValue)v, null);
    }

    public BFacets getOutFacets() {
        return (BFacets)this.get(outFacets);
    }

    public void setOutFacets(BFacets v) {
        this.set(outFacets, (BValue)v, null);
    }

    public BFacets getInFacets() {
        return (BFacets)this.get(inFacets);
    }

    public void setInFacets(BFacets v) {
        this.set(inFacets, (BValue)v, null);
    }

    public boolean getOutSigned() {
        return this.getBoolean(outSigned);
    }

    public void setOutSigned(boolean v) {
        this.setBoolean(outSigned, v, null);
    }

    public boolean getInSigned() {
        return this.getBoolean(inSigned);
    }

    public void setInSigned(boolean v) {
        this.setBoolean(inSigned, v, null);
    }

    @Override
    public Type getType() {
        return TYPE;
    }

    @Override
    public void doExecute() {
        int msb = (int)this.getInMs().getValue();
        int lsb = (int)this.getInLs().getValue();
        if (this.getInSigned()) {
            if (msb > Short.MAX_VALUE) {
                msb = Short.MAX_VALUE;
            }
            if (lsb > Short.MAX_VALUE) {
                lsb = Short.MAX_VALUE;
            }
            if (msb < Short.MIN_VALUE) {
                msb = Short.MIN_VALUE;
            }
            if (lsb < Short.MIN_VALUE) {
                lsb = Short.MIN_VALUE;
            }
        } else {
            if (msb > 65535) {
                msb = 65535;
            }
            if (lsb > 65535) {
                lsb = 65535;
            }
            if (msb < 0) {
                msb = 0;
            }
            if (lsb < 0) {
                lsb = 0;
            }
        }
        if (msb < 0) {
            msb = 65536 + msb;
        }
        if (lsb < 0) {
            lsb = 65536 + lsb;
        }
        String sMsb = Integer.toBinaryString(msb);
        while (sMsb.length() < 16) {
            sMsb = "0" + sMsb;
        }
        String sLsb = Integer.toBinaryString(lsb);
        while (sLsb.length() < 16) {
            sLsb = "0" + sLsb;
        }
        long result = Long.parseLong(sMsb + sLsb, 2);
        if (this.getOutSigned() && result > Integer.MAX_VALUE) {
            result -= 0x100000000L;
        }
        BUnit inUnit = (BUnit)this.getInFacets().get("units");
        BUnit outUnit = (BUnit)this.getOutFacets().get("units");
        if (inUnit != null && outUnit != null) {
            result = (long)inUnit.convertTo(outUnit, (double)result);
        }
        this.getOut().setValue((double)result);
    }

    public BFacets getSlotFacets(Slot slot) {
        if (slot == inMs || slot == inLs) {
            return this.getInFacets();
        }
        if (slot == out) {
            return this.getOutFacets();
        }
        return super.getSlotFacets(slot);
    }
}

