/*
 * Decompiled with CFR 0.152.
 */
package com.lynxspring.control.conversion;

import com.lynxspring.control.BLicensedComponent;
import javax.baja.data.BIDataValue;
import javax.baja.status.BStatus;
import javax.baja.status.BStatusNumeric;
import javax.baja.sys.BDynamicEnum;
import javax.baja.sys.BEnumRange;
import javax.baja.sys.BFacets;
import javax.baja.sys.BInteger;
import javax.baja.sys.BRelTime;
import javax.baja.sys.BValue;
import javax.baja.sys.Context;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;

public class BStatusNumericToRelTime
extends BLicensedComponent {
    private static String[] conversionTags = new String[]{"milliseconds", "seconds", "minutes", "hours"};
    public static final Property out = BStatusNumericToRelTime.newProperty((int)11, (BValue)BRelTime.DEFAULT, null);
    public static final Property in = BStatusNumericToRelTime.newProperty((int)10, (BValue)new BStatusNumeric(0.0, BStatus.nullStatus), null);
    public static final Property units = BStatusNumericToRelTime.newProperty((int)0, (BValue)BStatusNumericToRelTime.conversionUnit(), null);
    public static final Property multiplier = BStatusNumericToRelTime.newProperty((int)4, (int)1, (BFacets)BFacets.make((String)"min", (BIDataValue)BInteger.make((int)3)));
    public static final Type TYPE = Sys.loadType(BStatusNumericToRelTime.class);
    private static final int SECONDS = 1;
    private static final int MINUTES = 2;
    private static final int HOURS = 3;

    public BRelTime getOut() {
        return (BRelTime)this.get(out);
    }

    public void setOut(BRelTime v) {
        this.set(out, (BValue)v, null);
    }

    public BStatusNumeric getIn() {
        return (BStatusNumeric)this.get(in);
    }

    public void setIn(BStatusNumeric v) {
        this.set(in, (BValue)v, null);
    }

    public BDynamicEnum getUnits() {
        return (BDynamicEnum)this.get(units);
    }

    public void setUnits(BDynamicEnum v) {
        this.set(units, (BValue)v, null);
    }

    public int getMultiplier() {
        return this.getInt(multiplier);
    }

    public void setMultiplier(int v) {
        this.setInt(multiplier, v, null);
    }

    @Override
    public Type getType() {
        return TYPE;
    }

    public void changed(Property prop, Context cx) {
        if (!this.isRunning()) {
            return;
        }
        if (this.isStarted() && !this.checkLicense()) {
            return;
        }
        if (prop == in || prop == units || prop == multiplier) {
            if (this.getIn().getStatus().isNull()) {
                this.setOut(BRelTime.DEFAULT);
            } else {
                double outValue = this.getIn().getValue();
                switch (this.getUnits().getOrdinal()) {
                    case 3: {
                        outValue *= 60.0;
                    }
                    case 2: {
                        outValue *= 60.0;
                    }
                    case 1: {
                        outValue *= 1000.0;
                    }
                }
                this.setOut(BRelTime.make((long)((long)outValue * (long)this.getMultiplier())));
            }
        }
    }

    private static BDynamicEnum conversionUnit() {
        return BDynamicEnum.make((int)1, (BEnumRange)BEnumRange.make((String[])conversionTags));
    }
}

