/*
 * Decompiled with CFR 0.152.
 */
package com.lynxspring.control.conversion;

import com.lynxspring.control.BExecutableComponent;
import com.lynxspring.control.util.BBitSizeEnum;
import com.lynxspring.control.util.Util;
import javax.baja.data.BIDataValue;
import javax.baja.status.BStatusBoolean;
import javax.baja.status.BStatusNumeric;
import javax.baja.sys.BFacets;
import javax.baja.sys.BInteger;
import javax.baja.sys.BValue;
import javax.baja.sys.Context;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;

public class BStatusNumericToBitArray
extends BExecutableComponent {
    public static final Property in = BStatusNumericToBitArray.newProperty((int)522, (BValue)new BStatusNumeric(), (BFacets)BFacets.make((String)"precision", (BIDataValue)BInteger.make((int)0)));
    public static final Property size = BStatusNumericToBitArray.newProperty((int)512, (BValue)BBitSizeEnum.bits16, null);
    public static final Property bitOrder = BStatusNumericToBitArray.newProperty((int)512, (boolean)true, (BFacets)BFacets.makeBoolean((String)Util.lex.getText("bitOrder.true"), (String)Util.lex.getText("bitOrder.false")));
    public static final Type TYPE = Sys.loadType(BStatusNumericToBitArray.class);

    public BStatusNumeric getIn() {
        return (BStatusNumeric)this.get(in);
    }

    public void setIn(BStatusNumeric v) {
        this.set(in, (BValue)v, null);
    }

    public BBitSizeEnum getSize() {
        return (BBitSizeEnum)this.get(size);
    }

    public void setSize(BBitSizeEnum v) {
        this.set(size, (BValue)v, null);
    }

    public boolean getBitOrder() {
        return this.getBoolean(bitOrder);
    }

    public void setBitOrder(boolean v) {
        this.setBoolean(bitOrder, v, null);
    }

    @Override
    public Type getType() {
        return TYPE;
    }

    @Override
    public void started() {
        this.resetOutSlots();
        super.started();
    }

    @Override
    public void changed(Property p, Context cx) {
        if (!this.isRunning() || !this.isStarted()) {
            return;
        }
        if (p == size) {
            this.resetOutSlots();
        }
        super.changed(p, cx);
    }

    @Override
    public void doExecute() {
        int newValue = (int)this.getIn().getNumeric();
        String bits = Integer.toBinaryString(newValue);
        while (bits.length() < this.getSize().getOrdinal()) {
            bits = "0" + bits;
        }
        if (!this.getBitOrder()) {
            bits = new StringBuffer(bits).reverse().toString();
        }
        for (int i = 0; i < this.getSize().getOrdinal(); ++i) {
            if (bits.charAt(i) == '1') {
                this.set(this.outSlotName(i), (BValue)new BStatusBoolean(true, this.getIn().getStatus()));
                continue;
            }
            this.set(this.outSlotName(i), (BValue)new BStatusBoolean(false, this.getIn().getStatus()));
        }
    }

    void resetOutSlots() {
        int i;
        for (i = this.getSize().getOrdinal(); i < 32; ++i) {
            if (this.getSlot(this.outSlotName(i)) == null) continue;
            this.remove(this.outSlotName(i));
        }
        for (i = 0; i < this.getSize().getOrdinal(); ++i) {
            if (this.getSlot(this.outSlotName(i)) != null) continue;
            this.add(this.outSlotName(i), (BValue)new BStatusBoolean(false));
            this.setFlags(this.getSlot(this.outSlotName(i)), 264);
        }
    }

    String outSlotName(int i) {
        return "out" + (i + 1);
    }
}

