/*
 * Decompiled with CFR 0.152.
 */
package com.lynxspring.control.conversion;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import javax.baja.driver.point.BProxyConversion;
import javax.baja.driver.point.BProxyExt;
import javax.baja.status.BStatus;
import javax.baja.status.BStatusEnum;
import javax.baja.status.BStatusNumeric;
import javax.baja.status.BStatusValue;
import javax.baja.sys.BComplex;
import javax.baja.sys.BDouble;
import javax.baja.sys.BDynamicEnum;
import javax.baja.sys.BEnumRange;
import javax.baja.sys.BObject;
import javax.baja.sys.Context;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.units.BUnit;

public final class BLinearUnitConversion
extends BProxyConversion {
    public static final BLinearUnitConversion DEFAULT = new BLinearUnitConversion(1.0, 0.0);
    public static final Type TYPE = Sys.loadType(BLinearUnitConversion.class);
    private double scale;
    private double offset;
    private int hashCode = -1;

    public static BLinearUnitConversion make(double scale, double offset) {
        if (scale == 1.0 && offset == 0.0) {
            return DEFAULT;
        }
        return (BLinearUnitConversion)new BLinearUnitConversion(scale, offset).intern();
    }

    private BLinearUnitConversion(double scale, double offset) {
        this.scale = scale;
        this.offset = offset;
    }

    public double getScale() {
        return this.scale;
    }

    public double getOffset() {
        return this.offset;
    }

    public void convertDeviceToProxy(BProxyExt ext, BStatusValue deviceValue, BStatusValue proxyValue) throws Exception {
        if (deviceValue instanceof BStatusNumeric) {
            this.convert(ext, (BStatusNumeric)deviceValue, (BStatusNumeric)proxyValue, true);
        } else if (deviceValue instanceof BStatusEnum) {
            this.convert(ext, (BStatusEnum)deviceValue, (BStatusEnum)proxyValue, true);
        } else {
            proxyValue.copyFrom((BComplex)deviceValue);
        }
    }

    public void convertProxyToDevice(BProxyExt ext, BStatusValue proxyValue, BStatusValue deviceValue) throws Exception {
        if (proxyValue instanceof BStatusNumeric) {
            this.convert(ext, (BStatusNumeric)proxyValue, (BStatusNumeric)deviceValue, false);
        } else if (deviceValue instanceof BStatusEnum) {
            this.convert(ext, (BStatusEnum)proxyValue, (BStatusEnum)deviceValue, false);
        } else {
            deviceValue.copyFrom((BComplex)proxyValue);
        }
    }

    private void convert(BProxyExt ext, BStatusNumeric from, BStatusNumeric to, boolean deviceToProxy) {
        this.convert(ext, from.getValue(), from.getStatus(), (BStatusValue)to, deviceToProxy);
    }

    private void convert(BProxyExt ext, BStatusEnum from, BStatusEnum to, boolean deviceToProxy) {
        this.convert(ext, from.getValue().getOrdinal(), from.getStatus(), (BStatusValue)to, deviceToProxy);
    }

    private void convert(BProxyExt ext, double fromValue, BStatus fromStatus, BStatusValue to, boolean deviceToProxy) {
        double toValue = deviceToProxy ? fromValue * this.scale + this.offset : (fromValue - this.offset) / this.scale;
        BUnit proxyUnit = (BUnit)ext.getPointFacets().get("units", (BObject)BUnit.NULL);
        BUnit deviceUnit = (BUnit)ext.getDeviceFacets().get("units", (BObject)BUnit.NULL);
        if (!proxyUnit.isNull() && !deviceUnit.isNull() && proxyUnit != deviceUnit) {
            toValue = deviceToProxy ? deviceUnit.convertTo(proxyUnit, toValue) : proxyUnit.convertTo(deviceUnit, toValue);
        }
        to.setStatus(fromStatus);
        if (to instanceof BStatusNumeric) {
            ((BStatusNumeric)to).setValue(toValue);
        } else if (to instanceof BStatusEnum) {
            ((BStatusEnum)to).setValue(BDynamicEnum.make((int)((int)toValue), (BEnumRange)((BStatusEnum)to).getValue().getRange()));
        }
    }

    public int hashCode() {
        if (this.hashCode == -1) {
            long hash = 23L + Double.doubleToRawLongBits(this.offset);
            hash = hash * 37L + Double.doubleToRawLongBits(this.scale);
            this.hashCode = (int)(hash >>> 32) ^ (int)hash;
        }
        return this.hashCode;
    }

    public boolean equals(Object obj) {
        return this == obj;
    }

    public String toString(Context context) {
        StringBuffer s = new StringBuffer();
        s.append(TYPE.getDisplayName(context));
        if (this.scale != 1.0) {
            s.append(" *").append(BDouble.toString((double)this.scale, (Context)context));
        }
        if (this.offset < 0.0) {
            s.append(' ').append(BDouble.toString((double)this.offset, (Context)context));
        } else if (this.offset > 0.0) {
            s.append(" +").append(BDouble.toString((double)this.offset, (Context)context));
        }
        return s.toString();
    }

    public void encode(DataOutput out) throws IOException {
        out.writeDouble(this.scale);
        out.writeDouble(this.offset);
    }

    public BObject decode(DataInput in) throws IOException {
        return BLinearUnitConversion.make(in.readDouble(), in.readDouble());
    }

    public String encodeToString() {
        return BDouble.encode((double)this.scale) + ";" + BDouble.encode((double)this.offset);
    }

    public BObject decodeFromString(String s) throws IOException {
        int semi = s.indexOf(59);
        return BLinearUnitConversion.make(BDouble.decode((String)s.substring(0, semi)), BDouble.decode((String)s.substring(semi + 1)));
    }

    public Type getType() {
        return TYPE;
    }
}

