/*
 * Decompiled with CFR 0.152.
 */
package com.lynxspring.control.constants;

import com.lynxspring.control.util.Util;
import javax.baja.control.BBooleanPoint;
import javax.baja.control.BControlPoint;
import javax.baja.control.BEnumPoint;
import javax.baja.control.BNumericPoint;
import javax.baja.control.ext.BAbstractProxyExt;
import javax.baja.status.BStatus;
import javax.baja.status.BStatusBoolean;
import javax.baja.status.BStatusEnum;
import javax.baja.status.BStatusNumeric;
import javax.baja.status.BStatusString;
import javax.baja.status.BStatusValue;
import javax.baja.sys.BComponent;
import javax.baja.sys.BDynamicEnum;
import javax.baja.sys.BEnum;
import javax.baja.sys.BValue;
import javax.baja.sys.Context;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;

public class BConstantProxyExt
extends BAbstractProxyExt {
    public static final Type TYPE = Sys.loadType(BConstantProxyExt.class);
    private boolean licensed = false;
    private boolean started = false;
    private static final String inSlot = "In";

    public Type getType() {
        return TYPE;
    }

    public void started() {
        this.licensed = Util.checkLicense();
        this.started = true;
    }

    public boolean isParentLegal(BComponent parent) {
        boolean legal = super.isParentLegal(parent);
        if (legal) {
            this.checkInSlot();
        }
        return legal;
    }

    public void changed(Property p, Context cx) {
        if (p.getName().equals(inSlot)) {
            this.executePoint();
        }
    }

    public void onExecute(BStatusValue out, Context cx) {
        if (this.started && !this.licensed) {
            Util.notLicensed();
            return;
        }
        BValue in = this.checkInSlot();
        if (in != null && in instanceof BStatusValue) {
            BStatusValue value = (BStatusValue)in;
            if (!value.getType().is(out.getType())) {
                value = this.fixInSlot(this.getParentPoint());
            }
            if (value.getValueValue() != out.getValueValue()) {
                out.setValueValue(value.getValueValue());
            }
            if (!value.getStatus().equals((Object)out.getStatus())) {
                out.setStatus(value.getStatus());
            }
        }
    }

    public void setValue(boolean value) {
        this.checkInSlot();
        ((BStatusBoolean)this.get(inSlot)).setValue(value);
        this.setStatus((BStatusValue)this.get(inSlot));
    }

    public void setValue(double value) {
        this.checkInSlot();
        ((BStatusNumeric)this.get(inSlot)).setValue(value);
        this.setStatus((BStatusValue)this.get(inSlot));
    }

    public void setValue(BDynamicEnum value) {
        this.checkInSlot();
        ((BStatusEnum)this.get(inSlot)).setValue(value);
        this.setStatus((BStatusValue)this.get(inSlot));
    }

    public void setValue(String value) {
        this.checkInSlot();
        ((BStatusString)this.get(inSlot)).setValue(value);
        this.setStatus((BStatusValue)this.get(inSlot));
    }

    private void setStatus(BStatusValue value) {
        value.setStatus(BStatus.ok);
    }

    private BValue checkInSlot() {
        BValue in = this.get(inSlot);
        if (in == null) {
            in = this.fixInSlot(this.getParentPoint());
        }
        return in;
    }

    private BStatusValue fixInSlot(BControlPoint parent) {
        Object value = parent instanceof BBooleanPoint ? new BStatusBoolean(false, BStatus.nullStatus) : (parent instanceof BNumericPoint ? new BStatusNumeric(Double.NaN, BStatus.nullStatus) : (parent instanceof BEnumPoint ? new BStatusEnum((BEnum)BDynamicEnum.DEFAULT, BStatus.nullStatus) : new BStatusString("", BStatus.nullStatus)));
        if (this.get(inSlot) != null) {
            this.set(inSlot, (BValue)value);
        } else {
            this.add(inSlot, (BValue)value);
        }
        return value;
    }
}

