/*
 * Decompiled with CFR 0.152.
 */
package com.lynxspring.control;

import com.lynxspring.control.BAbstractRecorder;
import com.lynxspring.control.util.Util;
import javax.baja.sys.BAbsTime;
import javax.baja.sys.BComplex;
import javax.baja.sys.BIcon;
import javax.baja.sys.BLink;
import javax.baja.sys.BRelTime;
import javax.baja.sys.BValue;
import javax.baja.sys.Context;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;

public class BTimeRecorder
extends BAbstractRecorder {
    public static final Property in = BTimeRecorder.newProperty((int)10, (BValue)BRelTime.DEFAULT, null);
    public static final Property today = BTimeRecorder.newProperty((int)11, (BValue)BRelTime.DEFAULT, null);
    public static final Property yesterday = BTimeRecorder.newProperty((int)11, (BValue)BRelTime.DEFAULT, null);
    public static final Property weekToDate = BTimeRecorder.newProperty((int)11, (BValue)BRelTime.DEFAULT, null);
    public static final Property lastWeekTotal = BTimeRecorder.newProperty((int)11, (BValue)BRelTime.DEFAULT, null);
    public static final Property monthToDate = BTimeRecorder.newProperty((int)11, (BValue)BRelTime.DEFAULT, null);
    public static final Property lastMonthTotal = BTimeRecorder.newProperty((int)11, (BValue)BRelTime.DEFAULT, null);
    public static final Property yearToDate = BTimeRecorder.newProperty((int)11, (BValue)BRelTime.DEFAULT, null);
    public static final Property lastYearTotal = BTimeRecorder.newProperty((int)11, (BValue)BRelTime.DEFAULT, null);
    public static final Property todaysStartValue = BTimeRecorder.newProperty((int)5, (int)0, null);
    public static final Property yesterdaysStartValue = BTimeRecorder.newProperty((int)5, (int)0, null);
    public static final Property weekToDateStartValue = BTimeRecorder.newProperty((int)5, (int)0, null);
    public static final Property lastWeekStartValue = BTimeRecorder.newProperty((int)5, (int)0, null);
    public static final Property monthToDateStartValue = BTimeRecorder.newProperty((int)5, (int)0, null);
    public static final Property lastMonthStartValue = BTimeRecorder.newProperty((int)5, (int)0, null);
    public static final Property yearToDateStartValue = BTimeRecorder.newProperty((int)5, (int)0, null);
    public static final Property lastYearStartValue = BTimeRecorder.newProperty((int)5, (int)0, null);
    public static final Type TYPE = Sys.loadType(BTimeRecorder.class);
    private static final BIcon icon = BIcon.make((String)Util.lex.getText("time.icon"));
    private static final BIcon iconHist = BIcon.make((String)Util.lex.getText("timeHist.icon"));

    @Override
    public BValue getIn() {
        return this.get(in);
    }

    public void setIn(BValue v) {
        this.set(in, v, null);
    }

    public BRelTime getToday() {
        return (BRelTime)this.get(today);
    }

    public void setToday(BRelTime v) {
        this.set(today, (BValue)v, null);
    }

    public BRelTime getYesterday() {
        return (BRelTime)this.get(yesterday);
    }

    public void setYesterday(BRelTime v) {
        this.set(yesterday, (BValue)v, null);
    }

    public BRelTime getWeekToDate() {
        return (BRelTime)this.get(weekToDate);
    }

    public void setWeekToDate(BRelTime v) {
        this.set(weekToDate, (BValue)v, null);
    }

    public BRelTime getLastWeekTotal() {
        return (BRelTime)this.get(lastWeekTotal);
    }

    public void setLastWeekTotal(BRelTime v) {
        this.set(lastWeekTotal, (BValue)v, null);
    }

    public BRelTime getMonthToDate() {
        return (BRelTime)this.get(monthToDate);
    }

    public void setMonthToDate(BRelTime v) {
        this.set(monthToDate, (BValue)v, null);
    }

    public BRelTime getLastMonthTotal() {
        return (BRelTime)this.get(lastMonthTotal);
    }

    public void setLastMonthTotal(BRelTime v) {
        this.set(lastMonthTotal, (BValue)v, null);
    }

    public BRelTime getYearToDate() {
        return (BRelTime)this.get(yearToDate);
    }

    public void setYearToDate(BRelTime v) {
        this.set(yearToDate, (BValue)v, null);
    }

    public BRelTime getLastYearTotal() {
        return (BRelTime)this.get(lastYearTotal);
    }

    public void setLastYearTotal(BRelTime v) {
        this.set(lastYearTotal, (BValue)v, null);
    }

    public long getTodaysStartValue() {
        return this.getLong(todaysStartValue);
    }

    public void setTodaysStartValue(long v) {
        this.setLong(todaysStartValue, v, null);
    }

    public long getYesterdaysStartValue() {
        return this.getLong(yesterdaysStartValue);
    }

    public void setYesterdaysStartValue(long v) {
        this.setLong(yesterdaysStartValue, v, null);
    }

    public long getWeekToDateStartValue() {
        return this.getLong(weekToDateStartValue);
    }

    public void setWeekToDateStartValue(long v) {
        this.setLong(weekToDateStartValue, v, null);
    }

    public long getLastWeekStartValue() {
        return this.getLong(lastWeekStartValue);
    }

    public void setLastWeekStartValue(long v) {
        this.setLong(lastWeekStartValue, v, null);
    }

    public long getMonthToDateStartValue() {
        return this.getLong(monthToDateStartValue);
    }

    public void setMonthToDateStartValue(long v) {
        this.setLong(monthToDateStartValue, v, null);
    }

    public long getLastMonthStartValue() {
        return this.getLong(lastMonthStartValue);
    }

    public void setLastMonthStartValue(long v) {
        this.setLong(lastMonthStartValue, v, null);
    }

    public long getYearToDateStartValue() {
        return this.getLong(yearToDateStartValue);
    }

    public void setYearToDateStartValue(long v) {
        this.setLong(yearToDateStartValue, v, null);
    }

    public long getLastYearStartValue() {
        return this.getLong(lastYearStartValue);
    }

    public void setLastYearStartValue(long v) {
        this.setLong(lastYearStartValue, v, null);
    }

    @Override
    public Type getType() {
        return TYPE;
    }

    @Override
    public void added(Property prop, Context cx) {
        if (!this.isRunning()) {
            return;
        }
        if (this.get(prop) instanceof BLink && ((BLink)this.get(prop)).getTargetSlot() == in) {
            BLink link = (BLink)this.get(prop);
            long value = 0L;
            try {
                value = ((BRelTime)link.getSourceComponent().get(link.getSourceSlotName())).getMillis();
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.setTodaysStartValue(value);
            this.setYesterdaysStartValue(value);
            this.setWeekToDateStartValue(value);
            this.setLastWeekStartValue(value);
            this.setMonthToDateStartValue(value);
            this.setLastMonthStartValue(value);
            this.setYearToDateStartValue(value);
            this.setLastYearStartValue(value);
        }
    }

    @Override
    public void doCalculate() {
        if (!this.isRunning()) {
            return;
        }
        if (this.isStarted() && !this.checkLicense()) {
            return;
        }
        BAbsTime now = BAbsTime.now();
        if (this.getLastDailyCalculation().dateEquals(now)) {
            return;
        }
        long curValue = this.getInTime().getMillis();
        this.setYesterdaysStartValue(this.getTodaysStartValue());
        this.setTodaysStartValue(curValue);
        this.setYesterday(BRelTime.make((long)(this.getTodaysStartValue() - this.getYesterdaysStartValue())));
        this.setToday(BRelTime.DEFAULT);
        this.setLastDailyCalculation(now);
        if (this.getLastWeeklyCalculation().isBefore(now.prev(now.getWeekday())) || now.getWeekday().equals((Object)this.getWeeklyRollover())) {
            this.setLastWeekStartValue(this.getWeekToDateStartValue());
            this.setWeekToDateStartValue(curValue);
            this.setLastWeekTotal(BRelTime.make((long)(this.getWeekToDateStartValue() - this.getLastWeekStartValue())));
            this.setWeekToDate(BRelTime.DEFAULT);
            this.setLastWeeklyCalculation(now);
        }
        if (this.getLastMonthlyCalculation().isBefore(now.prevMonth()) || now.getDay() == this.getMonthlyRollover()) {
            this.setLastMonthStartValue(this.getMonthToDateStartValue());
            this.setMonthToDateStartValue(curValue);
            this.setLastMonthTotal(BRelTime.make((long)(this.getMonthToDateStartValue() - this.getLastMonthStartValue())));
            this.setMonthToDate(BRelTime.DEFAULT);
            this.setLastMonthlyCalculation(now);
        }
        if (this.getLastYearlyCalculation().isBefore(now.prevYear()) || now.getDay() == this.getYearlyRollover().getDay() && now.getMonth().equals((Object)this.getYearlyRollover().getMonth())) {
            this.setLastYearStartValue(this.getYearToDateStartValue());
            this.setYearToDateStartValue(curValue);
            this.setLastYearTotal(BRelTime.make((long)(this.getYearToDateStartValue() - this.getLastYearStartValue())));
            this.setYearToDate(BRelTime.DEFAULT);
            this.setLastYearlyCalculation(now);
        }
    }

    @Override
    public void doSetMonthToDate(BValue v) {
        this.setMonthToDate(BRelTime.make((long)(((BRelTime)v).getMillis() - this.getMonthToDateStartValue())));
    }

    @Override
    public void doSetToday(BValue v) {
        this.setToday(BRelTime.make((long)(((BRelTime)v).getMillis() - this.getTodaysStartValue())));
    }

    @Override
    public void doSetWeekToDate(BValue v) {
        this.setWeekToDate(BRelTime.make((long)(((BRelTime)v).getMillis() - this.getWeekToDateStartValue())));
    }

    @Override
    public void doSetYearToDate(BValue v) {
        this.setYearToDate(BRelTime.make((long)(((BRelTime)v).getMillis() - this.getYearToDateStartValue())));
    }

    private BRelTime getInTime() {
        return (BRelTime)this.getIn();
    }

    @Override
    public Property getInProp() {
        return in;
    }

    @Override
    public Property getTodayProp() {
        return today;
    }

    @Override
    public Property getYesterdayProp() {
        return yesterday;
    }

    @Override
    public Property getWeekToDateProp() {
        return weekToDate;
    }

    @Override
    public Property getLastWeekProp() {
        return lastWeekTotal;
    }

    @Override
    public Property getMonthToDateProp() {
        return monthToDate;
    }

    @Override
    public Property getLastMonthProp() {
        return lastMonthTotal;
    }

    @Override
    public Property getYearToDateProp() {
        return yearToDate;
    }

    @Override
    public Property getLastYearProp() {
        return lastYearTotal;
    }

    @Override
    public BIcon getIcon() {
        if (this.isRunning() && this.getHistories().length > 0) {
            return iconHist;
        }
        BIcon i = Util.getIcon((BComplex)this);
        if (i == BIcon.DEFAULT) {
            return icon;
        }
        return i;
    }
}

