/*
 * Decompiled with CFR 0.152.
 */
package com.lynxspring.control;

import javax.baja.data.BIDataValue;
import javax.baja.log.Log;
import javax.baja.sys.Action;
import javax.baja.sys.BComponent;
import javax.baja.sys.BDynamicEnum;
import javax.baja.sys.BEnum;
import javax.baja.sys.BEnumRange;
import javax.baja.sys.BFacets;
import javax.baja.sys.BRelTime;
import javax.baja.sys.BValue;
import javax.baja.sys.Clock;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;

public class BSteadyStateTrigger
extends BComponent {
    static BEnumRange range = BEnumRange.make((int[])new int[]{0, 1, 2}, (String[])new String[]{"Started", "Station$20Started", "Steady$20State", "Timer$20Started", "Timer$20Expired"});
    public static final int STARTED = 0;
    public static final int STATION_STARTED = 1;
    public static final int STEADY_STATE = 2;
    public static final int TIMER_STARTED = 3;
    public static final int TIMER_EXPIRED = 3;
    public static final Property atSteadyState = BSteadyStateTrigger.newProperty((int)9, (boolean)false, null);
    public static final Property timeDelay = BSteadyStateTrigger.newProperty((int)8, (BValue)BRelTime.DEFAULT, null);
    public static final Property stationProgress = BSteadyStateTrigger.newProperty((int)9, (BValue)BDynamicEnum.make((int)0, (BEnumRange)BSteadyStateTrigger.getRange()), (BFacets)BFacets.make((String)"range", (BIDataValue)BSteadyStateTrigger.getRange()));
    public static final Action restartTimeDelay = BSteadyStateTrigger.newAction((int)0, null);
    public static final Action timeExpired = BSteadyStateTrigger.newAction((int)0, null);
    public static final Type TYPE = Sys.loadType(BSteadyStateTrigger.class);

    public static BEnumRange getRange() {
        return range;
    }

    public boolean getAtSteadyState() {
        return this.getBoolean(atSteadyState);
    }

    public void setAtSteadyState(boolean v) {
        this.setBoolean(atSteadyState, v, null);
    }

    public BRelTime getTimeDelay() {
        return (BRelTime)this.get(timeDelay);
    }

    public void setTimeDelay(BRelTime v) {
        this.set(timeDelay, (BValue)v, null);
    }

    public BEnum getStationProgress() {
        return (BEnum)this.get(stationProgress);
    }

    public void setStationProgress(BEnum v) {
        this.set(stationProgress, (BValue)v, null);
    }

    public void restartTimeDelay() {
        this.invoke(restartTimeDelay, null, null);
    }

    public void timeExpired() {
        this.invoke(timeExpired, null, null);
    }

    public Type getType() {
        return TYPE;
    }

    public void started() {
        this.startDelay();
    }

    public void doRestartTimeDelay() {
        this.startDelay();
    }

    public void stationStarted() throws Exception {
        super.stationStarted();
    }

    public void doTimeExpired() {
        this.setStationProgress((BEnum)BDynamicEnum.make((int)3, (BEnumRange)range));
        this.setAtSteadyState(true);
        Log.getLog((String)"sys").message("Time delay of " + this.getTimeDelay() + " after steady state has expired");
    }

    private void startDelay() {
        this.setAtSteadyState(false);
        new Thread(){

            @Override
            public void run() {
                while (!Sys.atSteadyState()) {
                    try {
                        1.sleep(500L);
                    }
                    catch (InterruptedException interruptedException) {}
                }
                BSteadyStateTrigger.this.setStationProgress((BEnum)BDynamicEnum.make((int)2, (BEnumRange)range));
                Log.getLog((String)"sys").message("At steady state changed, time delay:" + BSteadyStateTrigger.this.getTimeDelay());
                Clock.schedule((BComponent)BSteadyStateTrigger.this, (BRelTime)BSteadyStateTrigger.this.getTimeDelay(), (Action)timeExpired, null);
            }
        }.start();
    }
}

