/*
 * Decompiled with CFR 0.152.
 */
package com.lynxspring.control;

import com.lynxspring.control.BExecutableComponent;
import javax.baja.status.BStatusNumeric;
import javax.baja.sys.BLink;
import javax.baja.sys.BValue;
import javax.baja.sys.Context;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;

public class BRolloverCounter
extends BExecutableComponent {
    public static final Property out = BRolloverCounter.newProperty((int)8, (BValue)new BStatusNumeric(), null);
    public static final Property in = BRolloverCounter.newProperty((int)522, (BValue)new BStatusNumeric(), null);
    public static final Property rolloverValue = BRolloverCounter.newProperty((int)0, (BValue)new BStatusNumeric(), null);
    public static final Type TYPE = Sys.loadType(BRolloverCounter.class);
    private BStatusNumeric lastValue = null;

    public BStatusNumeric getOut() {
        return (BStatusNumeric)this.get(out);
    }

    public void setOut(BStatusNumeric v) {
        this.set(out, (BValue)v, null);
    }

    public BStatusNumeric getIn() {
        return (BStatusNumeric)this.get(in);
    }

    public void setIn(BStatusNumeric v) {
        this.set(in, (BValue)v, null);
    }

    public BStatusNumeric getRolloverValue() {
        return (BStatusNumeric)this.get(rolloverValue);
    }

    public void setRolloverValue(BStatusNumeric v) {
        this.set(rolloverValue, (BValue)v, null);
    }

    @Override
    public Type getType() {
        return TYPE;
    }

    @Override
    public void doExecute() {
        if (this.lastValue != null) {
            double inValue = this.getIn().getValue();
            double lastInValue = this.lastValue.getValue();
            double outValue = this.getOut().getValue();
            if (lastInValue > inValue) {
                if (lastInValue < this.getRolloverValue().getValue()) {
                    this.setOut(new BStatusNumeric(outValue + inValue + (this.getRolloverValue().getValue() - lastInValue)));
                } else {
                    this.setOut(new BStatusNumeric(outValue + inValue));
                }
            } else {
                this.setOut(new BStatusNumeric(outValue + (inValue - lastInValue)));
            }
        }
        this.lastValue = (BStatusNumeric)this.getIn().newCopy();
    }

    public void added(Property prop, Context cx) {
        if (!this.isRunning()) {
            return;
        }
        if (this.get(prop) instanceof BLink && ((BLink)this.get(prop)).getTargetSlot() == in) {
            BLink link = (BLink)this.get(prop);
            double value = 0.0;
            try {
                value = ((BStatusNumeric)link.getSourceComponent().get(link.getSourceSlotName())).getNumeric();
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.lastValue = new BStatusNumeric(value);
            this.setOut(this.lastValue);
        }
    }
}

