/*
 * Decompiled with CFR 0.152.
 */
package com.lynxspring.control;

import com.lynxspring.control.BAbstractRecorder;
import com.lynxspring.control.util.Util;
import javax.baja.status.BStatusNumeric;
import javax.baja.sys.BAbsTime;
import javax.baja.sys.BComplex;
import javax.baja.sys.BIcon;
import javax.baja.sys.BLink;
import javax.baja.sys.BValue;
import javax.baja.sys.Context;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;

public class BPulseRecorder
extends BAbstractRecorder {
    public static final Property in = BPulseRecorder.newProperty((int)10, (BValue)new BStatusNumeric(), null);
    public static final Property today = BPulseRecorder.newProperty((int)11, (BValue)new BStatusNumeric(), null);
    public static final Property yesterday = BPulseRecorder.newProperty((int)11, (BValue)new BStatusNumeric(), null);
    public static final Property weekToDate = BPulseRecorder.newProperty((int)11, (BValue)new BStatusNumeric(), null);
    public static final Property lastWeekTotal = BPulseRecorder.newProperty((int)11, (BValue)new BStatusNumeric(), null);
    public static final Property monthToDate = BPulseRecorder.newProperty((int)11, (BValue)new BStatusNumeric(), null);
    public static final Property lastMonthTotal = BPulseRecorder.newProperty((int)11, (BValue)new BStatusNumeric(), null);
    public static final Property yearToDate = BPulseRecorder.newProperty((int)11, (BValue)new BStatusNumeric(), null);
    public static final Property lastYearTotal = BPulseRecorder.newProperty((int)11, (BValue)new BStatusNumeric(), null);
    public static final Property todaysStartValue = BPulseRecorder.newProperty((int)5, (int)0, null);
    public static final Property yesterdaysStartValue = BPulseRecorder.newProperty((int)5, (int)0, null);
    public static final Property weekToDateStartValue = BPulseRecorder.newProperty((int)5, (int)0, null);
    public static final Property lastWeekStartValue = BPulseRecorder.newProperty((int)5, (int)0, null);
    public static final Property monthToDateStartValue = BPulseRecorder.newProperty((int)5, (int)0, null);
    public static final Property lastMonthStartValue = BPulseRecorder.newProperty((int)5, (int)0, null);
    public static final Property yearToDateStartValue = BPulseRecorder.newProperty((int)5, (int)0, null);
    public static final Property lastYearStartValue = BPulseRecorder.newProperty((int)5, (int)0, null);
    public static final Type TYPE = Sys.loadType(BPulseRecorder.class);
    private static final BIcon icon = BIcon.make((String)Util.lex.getText("pulse.icon"));
    private static final BIcon iconHist = BIcon.make((String)Util.lex.getText("pulseHist.icon"));

    @Override
    public BValue getIn() {
        return this.get(in);
    }

    public void setIn(BValue v) {
        this.set(in, v, null);
    }

    public BStatusNumeric getToday() {
        return (BStatusNumeric)this.get(today);
    }

    public void setToday(BStatusNumeric v) {
        this.set(today, (BValue)v, null);
    }

    public BStatusNumeric getYesterday() {
        return (BStatusNumeric)this.get(yesterday);
    }

    public void setYesterday(BStatusNumeric v) {
        this.set(yesterday, (BValue)v, null);
    }

    public BStatusNumeric getWeekToDate() {
        return (BStatusNumeric)this.get(weekToDate);
    }

    public void setWeekToDate(BStatusNumeric v) {
        this.set(weekToDate, (BValue)v, null);
    }

    public BStatusNumeric getLastWeekTotal() {
        return (BStatusNumeric)this.get(lastWeekTotal);
    }

    public void setLastWeekTotal(BStatusNumeric v) {
        this.set(lastWeekTotal, (BValue)v, null);
    }

    public BStatusNumeric getMonthToDate() {
        return (BStatusNumeric)this.get(monthToDate);
    }

    public void setMonthToDate(BStatusNumeric v) {
        this.set(monthToDate, (BValue)v, null);
    }

    public BStatusNumeric getLastMonthTotal() {
        return (BStatusNumeric)this.get(lastMonthTotal);
    }

    public void setLastMonthTotal(BStatusNumeric v) {
        this.set(lastMonthTotal, (BValue)v, null);
    }

    public BStatusNumeric getYearToDate() {
        return (BStatusNumeric)this.get(yearToDate);
    }

    public void setYearToDate(BStatusNumeric v) {
        this.set(yearToDate, (BValue)v, null);
    }

    public BStatusNumeric getLastYearTotal() {
        return (BStatusNumeric)this.get(lastYearTotal);
    }

    public void setLastYearTotal(BStatusNumeric v) {
        this.set(lastYearTotal, (BValue)v, null);
    }

    public double getTodaysStartValue() {
        return this.getDouble(todaysStartValue);
    }

    public void setTodaysStartValue(double v) {
        this.setDouble(todaysStartValue, v, null);
    }

    public double getYesterdaysStartValue() {
        return this.getDouble(yesterdaysStartValue);
    }

    public void setYesterdaysStartValue(double v) {
        this.setDouble(yesterdaysStartValue, v, null);
    }

    public double getWeekToDateStartValue() {
        return this.getDouble(weekToDateStartValue);
    }

    public void setWeekToDateStartValue(double v) {
        this.setDouble(weekToDateStartValue, v, null);
    }

    public double getLastWeekStartValue() {
        return this.getDouble(lastWeekStartValue);
    }

    public void setLastWeekStartValue(double v) {
        this.setDouble(lastWeekStartValue, v, null);
    }

    public double getMonthToDateStartValue() {
        return this.getDouble(monthToDateStartValue);
    }

    public void setMonthToDateStartValue(double v) {
        this.setDouble(monthToDateStartValue, v, null);
    }

    public double getLastMonthStartValue() {
        return this.getDouble(lastMonthStartValue);
    }

    public void setLastMonthStartValue(double v) {
        this.setDouble(lastMonthStartValue, v, null);
    }

    public double getYearToDateStartValue() {
        return this.getDouble(yearToDateStartValue);
    }

    public void setYearToDateStartValue(double v) {
        this.setDouble(yearToDateStartValue, v, null);
    }

    public double getLastYearStartValue() {
        return this.getDouble(lastYearStartValue);
    }

    public void setLastYearStartValue(double v) {
        this.setDouble(lastYearStartValue, v, null);
    }

    @Override
    public Type getType() {
        return TYPE;
    }

    @Override
    public void added(Property prop, Context cx) {
        if (!this.isRunning()) {
            return;
        }
        if (this.get(prop) instanceof BLink && ((BLink)this.get(prop)).getTargetSlot() == in) {
            BLink link = (BLink)this.get(prop);
            double value = 0.0;
            try {
                value = ((BStatusNumeric)link.getSourceComponent().get(link.getSourceSlotName())).getNumeric();
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.setTodaysStartValue(value);
            this.setYesterdaysStartValue(value);
            this.setWeekToDateStartValue(value);
            this.setLastWeekStartValue(value);
            this.setMonthToDateStartValue(value);
            this.setLastMonthStartValue(value);
            this.setYearToDateStartValue(value);
            this.setLastYearStartValue(value);
        }
    }

    @Override
    public void doCalculate() {
        if (!this.isRunning()) {
            return;
        }
        if (this.isStarted() && !this.checkLicense()) {
            return;
        }
        BAbsTime now = BAbsTime.now();
        if (this.getLastDailyCalculation().dateEquals(now)) {
            return;
        }
        double curValue = this.getInNumeric().getNumeric();
        this.setYesterdaysStartValue(this.getTodaysStartValue());
        this.setTodaysStartValue(curValue);
        this.setYesterday(new BStatusNumeric(this.getTodaysStartValue() - this.getYesterdaysStartValue()));
        this.setToday(new BStatusNumeric(0.0));
        this.setLastDailyCalculation(now);
        if (this.getLastWeeklyCalculation().isBefore(now.prev(now.getWeekday())) || now.getWeekday().equals((Object)this.getWeeklyRollover())) {
            this.setLastWeekStartValue(this.getWeekToDateStartValue());
            this.setWeekToDateStartValue(curValue);
            this.setLastWeekTotal(new BStatusNumeric(this.getWeekToDateStartValue() - this.getLastWeekStartValue()));
            this.setWeekToDate(new BStatusNumeric(0.0));
            this.setLastWeeklyCalculation(now);
        }
        if (this.getLastMonthlyCalculation().isBefore(now.prevMonth()) || now.getDay() == this.getMonthlyRollover()) {
            this.setLastMonthStartValue(this.getMonthToDateStartValue());
            this.setMonthToDateStartValue(curValue);
            this.setLastMonthTotal(new BStatusNumeric(this.getMonthToDateStartValue() - this.getLastMonthStartValue()));
            this.setMonthToDate(new BStatusNumeric(0.0));
            this.setLastMonthlyCalculation(now);
        }
        if (this.getLastYearlyCalculation().isBefore(now.prevYear()) || now.getDay() == this.getYearlyRollover().getDay() && now.getMonth().equals((Object)this.getYearlyRollover().getMonth())) {
            this.setLastYearStartValue(this.getYearToDateStartValue());
            this.setYearToDateStartValue(curValue);
            this.setLastYearTotal(new BStatusNumeric(this.getYearToDateStartValue() - this.getLastYearStartValue()));
            this.setYearToDate(new BStatusNumeric(0.0));
            this.setLastYearlyCalculation(now);
        }
    }

    @Override
    public void doSetMonthToDate(BValue v) {
        this.setMonthToDate(new BStatusNumeric(((BStatusNumeric)v).getNumeric() - this.getMonthToDateStartValue()));
    }

    @Override
    public void doSetToday(BValue v) {
        BStatusNumeric in = (BStatusNumeric)v;
        this.setToday(new BStatusNumeric(in.getNumeric() - this.getTodaysStartValue(), in.getStatus()));
    }

    @Override
    public void doSetWeekToDate(BValue v) {
        this.setWeekToDate(new BStatusNumeric(((BStatusNumeric)v).getNumeric() - this.getWeekToDateStartValue()));
    }

    @Override
    public void doSetYearToDate(BValue v) {
        this.setYearToDate(new BStatusNumeric(((BStatusNumeric)v).getNumeric() - this.getYearToDateStartValue()));
    }

    private BStatusNumeric getInNumeric() {
        return (BStatusNumeric)this.getIn();
    }

    @Override
    public Property getInProp() {
        return in;
    }

    @Override
    public Property getTodayProp() {
        return today;
    }

    @Override
    public Property getYesterdayProp() {
        return yesterday;
    }

    @Override
    public Property getWeekToDateProp() {
        return weekToDate;
    }

    @Override
    public Property getLastWeekProp() {
        return lastWeekTotal;
    }

    @Override
    public Property getMonthToDateProp() {
        return monthToDate;
    }

    @Override
    public Property getLastMonthProp() {
        return lastMonthTotal;
    }

    @Override
    public Property getYearToDateProp() {
        return yearToDate;
    }

    @Override
    public Property getLastYearProp() {
        return lastYearTotal;
    }

    @Override
    public BIcon getIcon() {
        if (this.isRunning() && this.getHistories().length > 0) {
            return iconHist;
        }
        BIcon i = Util.getIcon((BComplex)this);
        if (i == BIcon.DEFAULT) {
            return icon;
        }
        return i;
    }
}

