/*
 * Decompiled with CFR 0.152.
 */
package com.lynxspring.control;

import javax.baja.data.BIDataValue;
import javax.baja.status.BStatus;
import javax.baja.status.BStatusNumeric;
import javax.baja.sys.BComponent;
import javax.baja.sys.BFacets;
import javax.baja.sys.BFloat;
import javax.baja.sys.BValue;
import javax.baja.sys.Context;
import javax.baja.sys.Property;
import javax.baja.sys.Slot;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;

public class BNumericThrottle
extends BComponent {
    public static final Property out = BNumericThrottle.newProperty((int)11, (BValue)new BStatusNumeric(0.0, BStatus.DEFAULT), null);
    public static final Property in = BNumericThrottle.newProperty((int)10, (BValue)new BStatusNumeric(0.0, BStatus.DEFAULT), null);
    public static final Property facets = BNumericThrottle.newProperty((int)0, (BValue)BFacets.makeNumeric(), null);
    public static final Property changeTolerance = BNumericThrottle.newProperty((int)0, (double)0.0, (BFacets)BFacets.make((String)"min", (BIDataValue)BFloat.make((float)0.0f)));
    public static final Type TYPE = Sys.loadType(BNumericThrottle.class);
    private double lastValue = 0.0;
    private BStatus lastStatus = null;

    public BStatusNumeric getOut() {
        return (BStatusNumeric)this.get(out);
    }

    public void setOut(BStatusNumeric v) {
        this.set(out, (BValue)v, null);
    }

    public BStatusNumeric getIn() {
        return (BStatusNumeric)this.get(in);
    }

    public void setIn(BStatusNumeric v) {
        this.set(in, (BValue)v, null);
    }

    public BFacets getFacets() {
        return (BFacets)this.get(facets);
    }

    public void setFacets(BFacets v) {
        this.set(facets, (BValue)v, null);
    }

    public double getChangeTolerance() {
        return this.getDouble(changeTolerance);
    }

    public void setChangeTolerance(double v) {
        this.setDouble(changeTolerance, v, null);
    }

    public Type getType() {
        return TYPE;
    }

    public void changed(Property p, Context cx) {
        if (p == in) {
            boolean valueChange = false;
            if (this.lastStatus == null || !this.lastStatus.equals((Object)this.getIn().getStatus())) {
                valueChange = true;
            } else {
                double dIn = this.getIn().getNumeric();
                if (Double.isNaN(dIn) && Double.isNaN(this.lastValue)) {
                    valueChange = false;
                } else if (Double.isNaN(dIn) || Double.isNaN(this.lastValue)) {
                    valueChange = true;
                } else {
                    boolean bl = valueChange = Math.abs(dIn - this.lastValue) > this.getChangeTolerance();
                }
            }
            if (valueChange) {
                this.lastValue = this.getIn().getNumeric();
                this.lastStatus = this.getIn().getStatus();
                this.setOut((BStatusNumeric)this.getIn().newCopy());
            }
        }
    }

    public BFacets getSlotFacets(Slot slot) {
        if (slot == out || slot == in) {
            return this.getFacets();
        }
        return super.getSlotFacets(slot);
    }
}

