/*
 * Decompiled with CFR 0.152.
 */
package com.lynxspring.control;

import com.lynxspring.control.util.Util;
import javax.baja.control.BBooleanPoint;
import javax.baja.status.BStatus;
import javax.baja.status.BStatusBoolean;
import javax.baja.status.BStatusValue;
import javax.baja.sys.BComplex;
import javax.baja.sys.BFacets;
import javax.baja.sys.BIcon;
import javax.baja.sys.BValue;
import javax.baja.sys.Context;
import javax.baja.sys.Property;
import javax.baja.sys.Slot;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;

public class BBooleanSwitch
extends BBooleanPoint {
    public static final Property inSwitch = BBooleanSwitch.newProperty((int)8, (BValue)new BStatusBoolean(false), null);
    public static final Property inTrue = BBooleanSwitch.newProperty((int)8, (BValue)new BStatusBoolean(false), null);
    public static final Property inFalse = BBooleanSwitch.newProperty((int)8, (BValue)new BStatusBoolean(false), null);
    public static final Property propagateFlags = BBooleanSwitch.newProperty((int)0, (BValue)BStatus.nullStatus, null);
    public static final Type TYPE = Sys.loadType(BBooleanSwitch.class);
    private boolean licensed = false;
    BStatusBoolean workingValue = new BStatusBoolean();

    public BStatusBoolean getInSwitch() {
        return (BStatusBoolean)this.get(inSwitch);
    }

    public void setInSwitch(BStatusBoolean v) {
        this.set(inSwitch, (BValue)v, null);
    }

    public BStatusBoolean getInTrue() {
        return (BStatusBoolean)this.get(inTrue);
    }

    public void setInTrue(BStatusBoolean v) {
        this.set(inTrue, (BValue)v, null);
    }

    public BStatusBoolean getInFalse() {
        return (BStatusBoolean)this.get(inFalse);
    }

    public void setInFalse(BStatusBoolean v) {
        this.set(inFalse, (BValue)v, null);
    }

    public BStatus getPropagateFlags() {
        return (BStatus)this.get(propagateFlags);
    }

    public void setPropagateFlags(BStatus v) {
        this.set(propagateFlags, (BValue)v, null);
    }

    public Type getType() {
        return TYPE;
    }

    public void started() {
        if (!this.isRunning()) {
            return;
        }
        this.licensed = Util.checkLicense();
    }

    public BFacets getSlotFacets(Slot slot) {
        if (slot.getName().startsWith("in")) {
            return this.getFacets();
        }
        return super.getSlotFacets(slot);
    }

    public void onExecute(BStatusValue out, Context cx) {
        if (!this.licensed) {
            Util.notLicensed();
            return;
        }
        String invalidFacet = Util.lex.getText("switch.invalidInSwitch");
        if (this.getInSwitch().getStatus().isValid()) {
            if (this.getInSwitch().getValue()) {
                this.workingValue.copyFrom((BComplex)this.getInTrue());
                this.workingValue.setStatus(this.propagate(this.getInTrue().getStatus()));
            } else {
                this.workingValue.copyFrom((BComplex)this.getInFalse());
                this.workingValue.setStatus(this.propagate(this.getInFalse().getStatus()));
            }
            BStatus s = this.workingValue.getStatus();
            this.workingValue.setStatus(BStatus.make((int)s.getBits(), (BFacets)BFacets.makeRemove((BFacets)s.getFacets(), (String)invalidFacet)));
        } else {
            this.workingValue.copyFrom((BComplex)this.getOut());
            this.workingValue.setStatus(BStatus.make((BStatus)this.workingValue.getStatus(), (String)invalidFacet, (boolean)true));
        }
        out.copyFrom((BComplex)this.workingValue);
    }

    public BStatus propagate(BStatus s) {
        return BStatus.make((int)(s.getBits() & this.getPropagateFlags().getBits()));
    }

    public BIcon getIcon() {
        BIcon icon = Util.getIcon((BComplex)this);
        if (icon.equivalent((Object)BIcon.DEFAULT)) {
            return super.getIcon();
        }
        return icon;
    }
}

