/*
 * Decompiled with CFR 0.152.
 */
package com.lynxspring.control;

import com.lynxspring.control.BExecutableComponent;
import com.lynxspring.control.util.Util;
import javax.baja.status.BStatus;
import javax.baja.status.BStatusBoolean;
import javax.baja.status.BStatusNumeric;
import javax.baja.sys.Action;
import javax.baja.sys.BFacets;
import javax.baja.sys.BInteger;
import javax.baja.sys.BLink;
import javax.baja.sys.BValue;
import javax.baja.sys.Context;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;

public class BBooleanCounter
extends BExecutableComponent {
    public static final Property out = BBooleanCounter.newProperty((int)3, (BValue)new BStatusNumeric(), (BFacets)BFacets.makeInt((int)0, (int)Integer.MAX_VALUE));
    public static final Property inputCount = BBooleanCounter.newProperty((int)0, (int)0, (BFacets)BFacets.makeInt((int)0, (int)Integer.MAX_VALUE));
    public static final Property propagateFlags = BBooleanCounter.newProperty((int)0, (BValue)BStatus.ok, null);
    public static final Action setNumberOfInputs = BBooleanCounter.newAction((int)0, (BValue)BInteger.make((int)0), null);
    public static final Type TYPE = Sys.loadType(BBooleanCounter.class);
    private boolean licensed = false;
    private static final String inPrefix = "In$20";

    public BStatusNumeric getOut() {
        return (BStatusNumeric)this.get(out);
    }

    public void setOut(BStatusNumeric v) {
        this.set(out, (BValue)v, null);
    }

    public int getInputCount() {
        return this.getInt(inputCount);
    }

    public void setInputCount(int v) {
        this.setInt(inputCount, v, null);
    }

    public BStatus getPropagateFlags() {
        return (BStatus)this.get(propagateFlags);
    }

    public void setPropagateFlags(BStatus v) {
        this.set(propagateFlags, (BValue)v, null);
    }

    public void setNumberOfInputs(BInteger arg) {
        this.invoke(setNumberOfInputs, (BValue)arg, null);
    }

    @Override
    public Type getType() {
        return TYPE;
    }

    @Override
    public void started() {
        this.checkInputs();
        this.licensed = Util.checkLicense();
        if (this.licensed) {
            this.execute();
        }
    }

    @Override
    public void changed(Property p, Context cx) {
        if (cx == Context.decoding) {
            return;
        }
        if (p == inputCount) {
            this.checkInputs();
        }
        super.changed(p, cx);
    }

    @Override
    public void doExecute() {
        if (!this.licensed) {
            Util.notLicensed();
            return;
        }
        int propStatus = 0;
        Property[] props = this.getDynamicPropertiesArray();
        int trueInputs = 0;
        for (int i = 0; i < props.length; ++i) {
            BValue val = this.get(props[i]);
            if (!(val instanceof BStatusBoolean) || !props[i].getName().startsWith(inPrefix)) continue;
            BStatusBoolean tmpIn = (BStatusBoolean)val;
            if (tmpIn.getStatus().isValid() && tmpIn.getValue()) {
                ++trueInputs;
            }
            propStatus |= tmpIn.getStatus().getBits();
        }
        this.getOut().setValue((double)trueInputs);
        this.getOut().setStatus(this.propagate(BStatus.make((int)propStatus)));
    }

    public void removed(Property p, BValue v, Context cx) {
        BValue in;
        if (v instanceof BLink && ((BLink)v).getTargetSlotName().startsWith(inPrefix) && (in = this.get(((BLink)v).getTargetSlotName())) instanceof BStatusBoolean) {
            ((BStatusBoolean)in).setValue(false);
            ((BStatusBoolean)in).setStatus(BStatus.nullStatus);
        }
    }

    public void doSetNumberOfInputs(BInteger value) {
        this.setInputCount(value.getInt());
    }

    public BValue getActionParameterDefault(Action action) {
        if (action == setNumberOfInputs) {
            int result = this.getInputCount();
            if (result < 2) {
                result = 2;
            }
            return BInteger.make((int)result);
        }
        return super.getActionParameterDefault(action);
    }

    public BStatus propagate(BStatus s) {
        return BStatus.make((int)(s.getBits() & this.getPropagateFlags().getBits()));
    }

    private void checkInputs() {
        int min;
        int inCount = 0;
        Property[] props = this.getDynamicPropertiesArray();
        for (int i = 0; i < props.length; ++i) {
            if (!(this.get(props[i]) instanceof BStatusBoolean) || !props[i].getName().startsWith(inPrefix)) continue;
            ++inCount;
        }
        if (inCount == this.getInputCount()) {
            return;
        }
        int max = Math.max(inCount, this.getInputCount()) + 1;
        for (int i = min = Math.min(inCount, this.getInputCount()) + 1; i < max; ++i) {
            if (i > this.getInputCount()) {
                this.remove(inPrefix + i);
                continue;
            }
            this.add(inPrefix + i, (BValue)new BStatusBoolean(false, BStatus.nullStatus), 520);
        }
    }
}

