/*
 * Decompiled with CFR 0.152.
 */
package com.lynxspring.control;

import com.lynxspring.control.BExecutableComponent;
import javax.baja.data.BIDataValue;
import javax.baja.naming.SlotPath;
import javax.baja.nre.util.Array;
import javax.baja.status.BStatusBoolean;
import javax.baja.sys.Action;
import javax.baja.sys.BAbsTime;
import javax.baja.sys.BComponent;
import javax.baja.sys.BFacets;
import javax.baja.sys.BInteger;
import javax.baja.sys.BMonth;
import javax.baja.sys.BRelTime;
import javax.baja.sys.BString;
import javax.baja.sys.BValue;
import javax.baja.sys.BVector;
import javax.baja.sys.BajaRuntimeException;
import javax.baja.sys.Clock;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.timezone.BTimeZone;
import javax.baja.timezone.TimeZoneDatabase;

public class BAstroClock
extends BExecutableComponent {
    public static final Property out = BAstroClock.newProperty((int)11, (BValue)new BStatusBoolean(), null);
    public static final Property action = BAstroClock.newProperty((int)512, (boolean)true, (BFacets)BFacets.makeBoolean((String)"Normal", (String)"Reverse"));
    public static final Property timezone = BAstroClock.newProperty((int)520, (BValue)BTimeZone.getLocal(), (BFacets)BFacets.make((String)"fieldEditor", (String)"lynxKitControl:AstroTimeZoneFE"));
    public static final Property nextSunrise = BAstroClock.newProperty((int)11, (BValue)BAbsTime.NULL, null);
    public static final Property nextSunset = BAstroClock.newProperty((int)11, (BValue)BAbsTime.NULL, null);
    public static final Property sunriseOffset = BAstroClock.newProperty((int)512, (BValue)BRelTime.DEFAULT, null);
    public static final Property sunsetOffset = BAstroClock.newProperty((int)512, (BValue)BRelTime.DEFAULT, null);
    public static final Property latitude = BAstroClock.newProperty((int)512, (double)0.0, (BFacets)BFacets.make((String[])new String[]{"fieldEditor", "min", "max"}, (BIDataValue[])new BIDataValue[]{BString.make((String)"lynxKitControl:LatitudeFieldEditor"), BInteger.make((int)-90), BInteger.make((int)90)}));
    public static final Property longitude = BAstroClock.newProperty((int)512, (double)0.0, (BFacets)BFacets.make((String[])new String[]{"fieldEditor", "min", "max"}, (BIDataValue[])new BIDataValue[]{BString.make((String)"lynxKitControl:LongitudeFieldEditor"), BInteger.make((int)-180), BInteger.make((int)180)}));
    public static final Action getLocalTimeZones = BAstroClock.newAction((int)260, null);
    public static final Action getLocalTimeZone = BAstroClock.newAction((int)260, null);
    public static final Type TYPE = Sys.loadType(BAstroClock.class);
    Clock.Ticket calcTicket;
    private BVector allTimeZones;
    private BTimeZone timeZone;
    private static final int TYPE_SUNRISE = 0;
    private static final int TYPE_SUNSET = 1;

    public BStatusBoolean getOut() {
        return (BStatusBoolean)this.get(out);
    }

    public void setOut(BStatusBoolean v) {
        this.set(out, (BValue)v, null);
    }

    public boolean getAction() {
        return this.getBoolean(action);
    }

    public void setAction(boolean v) {
        this.setBoolean(action, v, null);
    }

    public BTimeZone getTimezone() {
        return (BTimeZone)this.get(timezone);
    }

    public void setTimezone(BTimeZone v) {
        this.set(timezone, (BValue)v, null);
    }

    public BAbsTime getNextSunrise() {
        return (BAbsTime)this.get(nextSunrise);
    }

    public void setNextSunrise(BAbsTime v) {
        this.set(nextSunrise, (BValue)v, null);
    }

    public BAbsTime getNextSunset() {
        return (BAbsTime)this.get(nextSunset);
    }

    public void setNextSunset(BAbsTime v) {
        this.set(nextSunset, (BValue)v, null);
    }

    public BRelTime getSunriseOffset() {
        return (BRelTime)this.get(sunriseOffset);
    }

    public void setSunriseOffset(BRelTime v) {
        this.set(sunriseOffset, (BValue)v, null);
    }

    public BRelTime getSunsetOffset() {
        return (BRelTime)this.get(sunsetOffset);
    }

    public void setSunsetOffset(BRelTime v) {
        this.set(sunsetOffset, (BValue)v, null);
    }

    public double getLatitude() {
        return this.getDouble(latitude);
    }

    public void setLatitude(double v) {
        this.setDouble(latitude, v, null);
    }

    public double getLongitude() {
        return this.getDouble(longitude);
    }

    public void setLongitude(double v) {
        this.setDouble(longitude, v, null);
    }

    public BVector getLocalTimeZones() {
        return (BVector)this.invoke(getLocalTimeZones, null, null);
    }

    public BTimeZone getLocalTimeZone() {
        return (BTimeZone)this.invoke(getLocalTimeZone, null, null);
    }

    @Override
    public Type getType() {
        return TYPE;
    }

    @Override
    public void started() {
        super.started();
        this.execute();
    }

    public BTimeZone doGetLocalTimeZone() {
        if (this.timeZone == null) {
            this.timeZone = BTimeZone.getLocal();
        }
        return this.timeZone;
    }

    public BVector doGetLocalTimeZones() {
        if (this.allTimeZones == null) {
            try {
                BTimeZone[] abtimezone = TimeZoneDatabase.get().getTimeZones();
                Array array = new Array(BTimeZone.class);
                for (int i = 0; i < abtimezone.length; ++i) {
                    array.add((Object)abtimezone[i]);
                }
                array = array.sort();
                this.allTimeZones = new BVector();
                for (int j = 0; j < array.size(); ++j) {
                    BTimeZone btimezone = (BTimeZone)array.get(j);
                    this.allTimeZones.add(SlotPath.escape((String)btimezone.getId()), (BValue)btimezone);
                }
            }
            catch (RuntimeException runtimeexception) {
                throw runtimeexception;
            }
            catch (Exception exception) {
                throw new BajaRuntimeException((Throwable)exception);
            }
        }
        return this.allTimeZones;
    }

    @Override
    public void doExecute() {
        BAbsTime next;
        if (this.calcTicket != null && !this.calcTicket.isExpired()) {
            this.calcTicket.cancel();
        }
        this.setTimes(BAbsTime.now());
        BAbsTime sunrise = this.getNextSunrise().add(this.getSunriseOffset());
        BAbsTime sunset = this.getNextSunset().add(this.getSunsetOffset());
        if (BAbsTime.now().isBefore(sunrise) && BAbsTime.now().isBefore(sunset) || BAbsTime.now().isAfter(sunrise) && BAbsTime.now().isAfter(sunset)) {
            if (sunrise.isBefore(sunset)) {
                this.setOut(new BStatusBoolean(!this.getAction()));
                next = sunrise;
            } else {
                this.setOut(new BStatusBoolean(this.getAction()));
                next = sunset;
            }
        } else if (BAbsTime.now().isBefore(sunset)) {
            this.setOut(new BStatusBoolean(this.getAction()));
            next = sunset;
        } else {
            this.setOut(new BStatusBoolean(!this.getAction()));
            next = sunrise;
        }
        this.calcTicket = Clock.schedule((BComponent)this, (BAbsTime)next, (Action)execute, null);
    }

    public void clockChanged(BRelTime shift) {
        this.execute();
    }

    private void setTimes(BAbsTime now) {
        boolean winter;
        double JD = this.calcJD(now);
        boolean prevSunrise = !this.calcSunEvent(JD - 1.0, 0).isNull();
        boolean prevSunset = !this.calcSunEvent(JD - 1.0, 1).isNull();
        BAbsTime sunrise = this.calcSunEvent(JD, 0);
        BAbsTime sunset = this.calcSunEvent(JD, 1);
        while (sunrise.isNull() || sunset.isNull() || sunrise.isBefore(now) || sunset.isBefore(now)) {
            JD += 1.0;
            if (sunrise.isNull() || sunrise.isBefore(now)) {
                sunrise = this.calcSunEvent(JD, 0);
            }
            if (!sunset.isNull() && !sunset.isBefore(now)) continue;
            sunset = this.calcSunEvent(JD, 1);
        }
        boolean northern = this.getLatitude() > 0.0;
        int doy = now.getDayOfYear();
        boolean bl = winter = (doy > 265 || doy < 81) == northern;
        if (!prevSunrise || !prevSunset) {
            if (winter) {
                while (sunset.isBefore(sunrise)) {
                    sunset = this.calcSunEvent(JD += 1.0, 1);
                }
            } else {
                while (sunrise.isBefore(sunset)) {
                    sunrise = this.calcSunEvent(JD += 1.0, 0);
                }
            }
        }
        this.setNextSunrise(sunrise);
        this.setNextSunset(sunset);
    }

    private double calcUTC(double JD, int type) {
        double t = this.calcTimeJulianCent(JD);
        double noonmin = this.calcSolNoonUTC(t);
        double tnoon = this.calcTimeJulianCent(JD + noonmin / 1440.0);
        double timeUTC = this.calcUTC_Pass(tnoon, type);
        double newt = this.calcTimeJulianCent(this.calcJDFromJulianCent(t) + timeUTC / 1440.0);
        return this.calcUTC_Pass(newt, type);
    }

    private double calcUTC_Pass(double time, int type) {
        double eqTime = this.calcEquationOfTime(time);
        double solarDec = this.calcSunDeclination(time);
        double hourAngle = this.calcHourAngle(solarDec, type);
        double delta = -this.getLongitude() - Math.toDegrees(hourAngle);
        double timeDiff = 4.0 * delta;
        return 720.0 + timeDiff - eqTime;
    }

    private double calcSolNoonUTC(double t) {
        double tnoon = this.calcTimeJulianCent(this.calcJDFromJulianCent(t) + -this.getLongitude() / 360.0);
        double solNoonUTC = this.calcSolNoonUTC_Pass(tnoon);
        double newt = this.calcTimeJulianCent(this.calcJDFromJulianCent(t) - 0.5 + solNoonUTC / 1440.0);
        return this.calcSolNoonUTC_Pass(newt);
    }

    private double calcSolNoonUTC_Pass(double time) {
        double eqTime = this.calcEquationOfTime(time);
        return 720.0 + -this.getLongitude() * 4.0 - eqTime;
    }

    private double calcEquationOfTime(double time) {
        double epsilon = this.calcObliquityCorrection(time);
        double l0 = this.calcGeomMeanLongSun(time);
        double e = this.calcEccentricityEarthOrbit(time);
        double m = this.calcGeomMeanAnomalySun(time);
        double y = Math.tan(Math.toRadians(epsilon) / 2.0);
        y *= y;
        double sin2l0 = Math.sin(2.0 * Math.toRadians(l0));
        double sinm = Math.sin(Math.toRadians(m));
        double cos2l0 = Math.cos(2.0 * Math.toRadians(l0));
        double sin4l0 = Math.sin(4.0 * Math.toRadians(l0));
        double sin2m = Math.sin(2.0 * Math.toRadians(m));
        double Etime = y * sin2l0 - 2.0 * e * sinm + 4.0 * e * y * sinm * cos2l0 - 0.5 * y * y * sin4l0 - 1.25 * e * e * sin2m;
        return Math.toDegrees(Etime) * 4.0;
    }

    private double calcSunDeclination(double time) {
        double e = this.calcObliquityCorrection(time);
        double lambda = this.calcSunApparentLong(time);
        double sint = Math.sin(Math.toRadians(e)) * Math.sin(Math.toRadians(lambda));
        return Math.toDegrees(Math.asin(sint));
    }

    private double calcHourAngle(double solarDec, int type) {
        double lat = this.getLatitude();
        if (lat < -89.0) {
            lat = -89.0;
        } else if (lat > 89.0) {
            lat = 89.0;
        }
        double latRad = Math.toRadians(lat);
        double sdRad = Math.toRadians(solarDec);
        double HA = Math.acos(Math.cos(Math.toRadians(90.833)) / (Math.cos(latRad) * Math.cos(sdRad)) - Math.tan(latRad) * Math.tan(sdRad));
        if (type == 0) {
            return HA;
        }
        return -HA;
    }

    private double calcObliquityCorrection(double time) {
        double e0 = this.calcMeanObliquityOfEcliptic(time);
        double omega = 125.04 - 1934.136 * time;
        return e0 + 0.00256 * Math.cos(Math.toRadians(omega));
    }

    private double calcGeomMeanLongSun(double time) {
        double L0;
        for (L0 = 280.46646 + time * (36000.76983 + 3.032E-4 * time); L0 > 360.0; L0 -= 360.0) {
        }
        while (L0 < 0.0) {
            L0 += 360.0;
        }
        return L0;
    }

    private double calcEccentricityEarthOrbit(double time) {
        return 0.016708634 - time * (4.2037E-5 + 1.267E-7 * time);
    }

    private double calcGeomMeanAnomalySun(double time) {
        return 357.52911 + time * (35999.05029 - 1.537E-4 * time);
    }

    private double calcSunApparentLong(double time) {
        double o = this.calcSunTrueLong(time);
        double omega = 125.04 - 1934.136 * time;
        return o - 0.00569 - 0.00478 * Math.sin(Math.toRadians(omega));
    }

    private double calcMeanObliquityOfEcliptic(double time) {
        double seconds = 21.448 - time * (46.815 + time * (5.9E-4 - time * 0.001813));
        return 23.0 + (26.0 + seconds / 60.0) / 60.0;
    }

    private double calcSunTrueLong(double time) {
        double l0 = this.calcGeomMeanLongSun(time);
        double c = this.calcSunEqOfCenter(time);
        return l0 + c;
    }

    private double calcSunEqOfCenter(double time) {
        double m = this.calcGeomMeanAnomalySun(time);
        double mrad = Math.toRadians(m);
        double sinm = Math.sin(mrad);
        double sin2m = Math.sin(mrad + mrad);
        double sin3m = Math.sin(mrad + mrad + mrad);
        return sinm * (1.914602 - time * (0.004817 + 1.4E-5 * time)) + sin2m * (0.019993 - 1.01E-4 * time) + sin3m * 2.89E-4;
    }

    private double calcJD(BAbsTime date) {
        int year = date.getYear();
        int month = date.getMonth().getMonthOfYear();
        if (month <= 2) {
            --year;
            month += 12;
        }
        int day = date.getDay();
        double A = Math.floor(year / 100);
        double B = 2.0 - A + Math.floor(A / 4.0);
        return Math.floor(365.25 * (double)(year + 4716)) + Math.floor(30.6001 * (double)(month + 1)) + (double)day + B - 1524.5;
    }

    private double calcTimeJulianCent(double jd) {
        return (jd - 2451545.0) / 36525.0;
    }

    private double calcJDFromJulianCent(double time) {
        return time * 36525.0 + 2451545.0;
    }

    private BAbsTime calcSunEvent(double jd, int type) {
        double A;
        double utc = this.calcUTC(jd, type);
        if (Double.isNaN(utc)) {
            return BAbsTime.NULL;
        }
        double floatHour = utc / 60.0;
        int hour = (int)Math.floor(floatHour);
        double floatMinute = 60.0 * (floatHour - Math.floor(floatHour));
        int minute = (int)Math.floor(floatMinute);
        double floatSec = 60.0 * (floatMinute - Math.floor(floatMinute));
        int second = (int)Math.floor(floatSec + 0.5);
        if ((minute += second >= 30 ? 1 : 0) >= 60) {
            minute -= 60;
            ++hour;
        }
        if (hour > 23) {
            hour -= 24;
            jd += 1.0;
        }
        if (hour < 0) {
            hour += 24;
            jd -= 1.0;
        }
        double z = Math.floor(jd + 0.5);
        double f = jd + 0.5 - z;
        if (z < 2299161.0) {
            A = z;
        } else {
            double alpha = Math.floor((z - 1867216.25) / 36524.25);
            A = z + 1.0 + alpha - Math.floor(alpha / 4.0);
        }
        double B = A + 1524.0;
        double C = Math.floor((B - 122.1) / 365.25);
        double D = Math.floor(365.25 * C);
        double E = Math.floor((B - D) / 30.6001);
        int day = (int)(B - D - Math.floor(30.6001 * E) + f);
        int month = (int)(E < 14.0 ? E - 1.0 : E - 13.0);
        int year = (int)(month > 2 ? C - 4716.0 : C - 4715.0);
        BAbsTime utcTime = BAbsTime.make((int)year, (BMonth)BMonth.make((int)(month - 1)), (int)day, (int)hour, (int)minute, (int)0, (int)0, (BTimeZone)BTimeZone.UTC);
        return BAbsTime.make((BAbsTime)utcTime, (BTimeZone)this.getTimezone());
    }
}

