/*
 * Decompiled with CFR 0.152.
 */
package com.lynxspring.control;

import com.lynxspring.control.BExecutableComponent;
import javax.baja.data.BIDataValue;
import javax.baja.status.BStatusNumeric;
import javax.baja.sys.Action;
import javax.baja.sys.BAbsTime;
import javax.baja.sys.BComponent;
import javax.baja.sys.BFacets;
import javax.baja.sys.BInteger;
import javax.baja.sys.BRelTime;
import javax.baja.sys.BValue;
import javax.baja.sys.Clock;
import javax.baja.sys.Context;
import javax.baja.sys.Property;
import javax.baja.sys.Slot;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;

public class BAnalogAverage
extends BExecutableComponent {
    public static final Property out = BAnalogAverage.newProperty((int)11, (BValue)new BStatusNumeric(), null);
    public static final Property in = BAnalogAverage.newProperty((int)10, (BValue)new BStatusNumeric(), null);
    public static final Property facets = BAnalogAverage.newProperty((int)0, (BValue)BFacets.make((String)"precision", (BIDataValue)BInteger.make((int)1)), null);
    public static final Property updateInterval = BAnalogAverage.newProperty((int)0, (BValue)BRelTime.makeSeconds((int)5), (BFacets)BFacets.make((String)"min", (BIDataValue)BRelTime.makeSeconds((int)1)));
    public static final Property maxTime = BAnalogAverage.newProperty((int)512, (BValue)BRelTime.DEFAULT, (BFacets)BFacets.make((String)"min", (BIDataValue)BRelTime.DEFAULT));
    public static final Property maxChanges = BAnalogAverage.newProperty((int)0, (int)20, (BFacets)BFacets.makeInt((int)5, (int)50));
    public static final Property ignoreIfNotOk = BAnalogAverage.newProperty((int)0, (boolean)true, null);
    public static final Type TYPE = Sys.loadType(BAnalogAverage.class);
    private double[] polled = new double[0];
    private BAbsTime[] pollTime = new BAbsTime[0];
    private Clock.Ticket updateTicket;

    public BStatusNumeric getOut() {
        return (BStatusNumeric)this.get(out);
    }

    public void setOut(BStatusNumeric v) {
        this.set(out, (BValue)v, null);
    }

    public BStatusNumeric getIn() {
        return (BStatusNumeric)this.get(in);
    }

    public void setIn(BStatusNumeric v) {
        this.set(in, (BValue)v, null);
    }

    public BFacets getFacets() {
        return (BFacets)this.get(facets);
    }

    public void setFacets(BFacets v) {
        this.set(facets, (BValue)v, null);
    }

    public BRelTime getUpdateInterval() {
        return (BRelTime)this.get(updateInterval);
    }

    public void setUpdateInterval(BRelTime v) {
        this.set(updateInterval, (BValue)v, null);
    }

    public BRelTime getMaxTime() {
        return (BRelTime)this.get(maxTime);
    }

    public void setMaxTime(BRelTime v) {
        this.set(maxTime, (BValue)v, null);
    }

    public int getMaxChanges() {
        return this.getInt(maxChanges);
    }

    public void setMaxChanges(int v) {
        this.setInt(maxChanges, v, null);
    }

    public boolean getIgnoreIfNotOk() {
        return this.getBoolean(ignoreIfNotOk);
    }

    public void setIgnoreIfNotOk(boolean v) {
        this.setBoolean(ignoreIfNotOk, v, null);
    }

    @Override
    public Type getType() {
        return TYPE;
    }

    @Override
    public void changed(Property p, Context cx) {
        if (!this.isRunning()) {
            return;
        }
        if (p == maxChanges) {
            this.updateArrays();
        } else if (p == updateInterval) {
            this.update();
        } else if (p == in) {
            this.addValue();
        }
    }

    public BFacets getSlotFacets(Slot slot) {
        if (slot == out || slot == in) {
            return this.getFacets();
        }
        return super.getSlotFacets(slot);
    }

    @Override
    public void started() {
        super.started();
        if (!this.isRunning() || !this.isLicensed()) {
            return;
        }
        this.update();
    }

    private void updateArrays() {
        if (this.getMaxChanges() < this.polled.length) {
            double[] ad = new double[this.getMaxChanges()];
            BAbsTime[] at = new BAbsTime[this.getMaxChanges()];
            for (int i = 0; i < ad.length; ++i) {
                ad[i] = this.polled[i + (this.polled.length - this.getMaxChanges())];
                at[i] = this.pollTime[i + (this.polled.length - this.getMaxChanges())];
            }
            this.polled = ad;
            this.pollTime = at;
        }
        this.execute();
    }

    public void addValue() {
        if (this.getIgnoreIfNotOk() && !this.getIn().getStatus().isOk()) {
            return;
        }
        if (this.polled.length == this.getMaxChanges()) {
            for (int i = 1; i < this.polled.length; ++i) {
                this.polled[i - 1] = this.polled[i];
                this.pollTime[i - 1] = this.pollTime[i];
            }
        } else {
            double[] ad = new double[this.polled.length + 1];
            BAbsTime[] at = new BAbsTime[this.polled.length + 1];
            for (int i = 0; i < this.polled.length; ++i) {
                ad[i] = this.polled[i];
                at[i] = this.pollTime[i];
            }
            this.polled = ad;
            this.pollTime = at;
        }
        this.polled[this.polled.length - 1] = this.getIn().getNumeric();
        this.pollTime[this.pollTime.length - 1] = BAbsTime.now();
        this.execute();
    }

    private void update() {
        if (this.updateTicket != null && !this.updateTicket.isExpired()) {
            this.updateTicket.cancel();
        }
        if (this.getUpdateInterval().getMillis() > 0L) {
            this.updateTicket = Clock.schedule((BComponent)this, (BRelTime)this.getUpdateInterval(), (Action)execute, null);
        }
    }

    @Override
    public void doExecute() {
        int i;
        this.update();
        if (this.polled.length < 2) {
            this.getOut().setValue(this.getIn().getNumeric());
            return;
        }
        BAbsTime now = BAbsTime.now();
        for (i = 0; i < this.pollTime.length && this.getMaxTime().getMillis() != 0L && this.pollTime[i].delta(now).getMillis() > this.getMaxTime().getMillis(); ++i) {
        }
        if (this.pollTime.length - i < 2) {
            this.getOut().setValue(this.getIn().getNumeric());
            return;
        }
        long total = this.pollTime[i].delta(now).getMillis();
        double avg = 0.0;
        while (i < this.polled.length) {
            BAbsTime next = i == this.polled.length - 1 ? now : this.pollTime[i + 1];
            avg += this.polled[i] * ((double)this.pollTime[i].delta(next).getMillis() / (double)total);
            ++i;
        }
        this.getOut().setValue(avg);
    }
}

