/*
 * Decompiled with CFR 0.152.
 */
package com.lynxspring.control;

import com.lynxspring.control.BLicensedComponent;
import com.lynxspring.control.util.Util;
import com.tridium.util.ArrayUtil;
import javax.baja.collection.BITable;
import javax.baja.collection.TableCursor;
import javax.baja.data.BIDataValue;
import javax.baja.naming.BOrd;
import javax.baja.sys.Action;
import javax.baja.sys.BAbsTime;
import javax.baja.sys.BBoolean;
import javax.baja.sys.BComplex;
import javax.baja.sys.BComponent;
import javax.baja.sys.BFacets;
import javax.baja.sys.BIcon;
import javax.baja.sys.BMonth;
import javax.baja.sys.BObject;
import javax.baja.sys.BRelTime;
import javax.baja.sys.BString;
import javax.baja.sys.BTime;
import javax.baja.sys.BValue;
import javax.baja.sys.BWeekday;
import javax.baja.sys.Clock;
import javax.baja.sys.Context;
import javax.baja.sys.Property;
import javax.baja.sys.Slot;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;

public abstract class BAbstractRecorder
extends BLicensedComponent {
    public static final Property facets = BAbstractRecorder.newProperty((int)0, (BValue)BFacets.DEFAULT, null);
    public static final Property weeklyRollover = BAbstractRecorder.newProperty((int)0, (BValue)BWeekday.sunday, null);
    public static final Property monthlyRollover = BAbstractRecorder.newProperty((int)0, (int)1, (BFacets)BFacets.makeInt((int)1, (int)28));
    public static final Property yearlyRollover = BAbstractRecorder.newProperty((int)0, (BValue)BAbsTime.make((int)2000, (BMonth)BMonth.january, (int)1), (BFacets)BFacets.make((String)"fieldEditor", (BIDataValue)BString.make((String)"lynxKitControl:DayOfYearFE")));
    public static final Property lastDailyCalculation = BAbstractRecorder.newProperty((int)5, (BValue)BAbsTime.now(), null);
    public static final Property lastWeeklyCalculation = BAbstractRecorder.newProperty((int)5, (BValue)BAbsTime.now(), null);
    public static final Property lastMonthlyCalculation = BAbstractRecorder.newProperty((int)5, (BValue)BAbsTime.now(), null);
    public static final Property lastYearlyCalculation = BAbstractRecorder.newProperty((int)5, (BValue)BAbsTime.now(), null);
    public static final Action calculate = BAbstractRecorder.newAction((int)4, null);
    public static final Action activateHistories = BAbstractRecorder.newAction((int)16, null);
    public static final Action deactivateHistories = BAbstractRecorder.newAction((int)16, null);
    public static final Type TYPE = Sys.loadType(BAbstractRecorder.class);
    private static final BIcon icon = BIcon.make((String)Util.lex.getText("pulse.icon"));
    private static final BIcon iconHist = BIcon.make((String)Util.lex.getText("pulseHist.icon"));
    private Clock.Ticket schedule;

    public BFacets getFacets() {
        return (BFacets)this.get(facets);
    }

    public void setFacets(BFacets v) {
        this.set(facets, (BValue)v, null);
    }

    public BWeekday getWeeklyRollover() {
        return (BWeekday)this.get(weeklyRollover);
    }

    public void setWeeklyRollover(BWeekday v) {
        this.set(weeklyRollover, (BValue)v, null);
    }

    public int getMonthlyRollover() {
        return this.getInt(monthlyRollover);
    }

    public void setMonthlyRollover(int v) {
        this.setInt(monthlyRollover, v, null);
    }

    public BAbsTime getYearlyRollover() {
        return (BAbsTime)this.get(yearlyRollover);
    }

    public void setYearlyRollover(BAbsTime v) {
        this.set(yearlyRollover, (BValue)v, null);
    }

    public BAbsTime getLastDailyCalculation() {
        return (BAbsTime)this.get(lastDailyCalculation);
    }

    public void setLastDailyCalculation(BAbsTime v) {
        this.set(lastDailyCalculation, (BValue)v, null);
    }

    public BAbsTime getLastWeeklyCalculation() {
        return (BAbsTime)this.get(lastWeeklyCalculation);
    }

    public void setLastWeeklyCalculation(BAbsTime v) {
        this.set(lastWeeklyCalculation, (BValue)v, null);
    }

    public BAbsTime getLastMonthlyCalculation() {
        return (BAbsTime)this.get(lastMonthlyCalculation);
    }

    public void setLastMonthlyCalculation(BAbsTime v) {
        this.set(lastMonthlyCalculation, (BValue)v, null);
    }

    public BAbsTime getLastYearlyCalculation() {
        return (BAbsTime)this.get(lastYearlyCalculation);
    }

    public void setLastYearlyCalculation(BAbsTime v) {
        this.set(lastYearlyCalculation, (BValue)v, null);
    }

    public void calculate() {
        this.invoke(calculate, null, null);
    }

    public void activateHistories() {
        this.invoke(activateHistories, null, null);
    }

    public void deactivateHistories() {
        this.invoke(deactivateHistories, null, null);
    }

    @Override
    public Type getType() {
        return TYPE;
    }

    public void changed(Property prop, Context cx) {
        if (!this.isRunning()) {
            return;
        }
        if (prop == lastDailyCalculation && this.getLastDailyCalculation().equals((Object)BAbsTime.NULL)) {
            this.setLastDailyCalculation(BAbsTime.now());
        } else if (prop == lastWeeklyCalculation && this.getLastWeeklyCalculation().equals((Object)BAbsTime.NULL)) {
            this.setLastWeeklyCalculation(BAbsTime.now());
        } else if (prop == lastMonthlyCalculation && this.getLastMonthlyCalculation().equals((Object)BAbsTime.NULL)) {
            this.setLastMonthlyCalculation(BAbsTime.now());
        } else if (prop == lastDailyCalculation && this.getLastYearlyCalculation().equals((Object)BAbsTime.NULL)) {
            this.setLastYearlyCalculation(BAbsTime.now());
        } else if (prop == this.getInProp()) {
            this.doSetToday(this.getIn());
            this.doSetWeekToDate(this.getIn());
            this.doSetMonthToDate(this.getIn());
            this.doSetYearToDate(this.getIn());
        }
    }

    @Override
    public void started() {
        super.started();
        if (!this.isRunning() || !this.isLicensed()) {
            return;
        }
        if (this.getLastDailyCalculation().isBefore(BAbsTime.make((BAbsTime)BAbsTime.now(), (BTime)BTime.MIDNIGHT))) {
            this.doCalculate();
        }
        this.schedule();
    }

    public BFacets getSlotFacets(Slot slot) {
        if (slot == this.getTodayProp() || slot == this.getYesterdayProp() || slot == this.getWeekToDateProp() || slot == this.getLastWeekProp() || slot == this.getMonthToDateProp() || slot == this.getLastMonthProp() || slot == this.getYearToDateProp() || slot == this.getLastYearProp()) {
            return this.getFacets();
        }
        return super.getSlotFacets(slot);
    }

    public void clockChanged(BRelTime shift) {
        if (!this.isRunning()) {
            return;
        }
        if (!this.getLastDailyCalculation().dateEquals(BAbsTime.now()) && this.getLastDailyCalculation().isAfter(BAbsTime.now())) {
            this.schedule();
        }
    }

    private void schedule() {
        if (this.schedule != null && !this.schedule.isExpired()) {
            this.schedule.cancel();
        }
        this.schedule = Clock.schedulePeriodically((BComponent)this, (BAbsTime)BAbsTime.make((BAbsTime)BAbsTime.now().nextDay(), (BTime)BTime.MIDNIGHT), (BRelTime)BRelTime.makeHours((int)24), (Action)calculate, null);
    }

    public void doActivateHistories() {
        this.updateHistories(true);
    }

    public void doDeactivateHistories() {
        this.updateHistories(false);
    }

    private void updateHistories(boolean flag) {
        if (!this.isRunning()) {
            return;
        }
        if (this.isStarted() && !this.checkLicense()) {
            return;
        }
        BObject[] histories = this.getHistories();
        for (int i = 0; i < histories.length; ++i) {
            BComplex tmp;
            if (!(histories[i] instanceof BComplex) || (tmp = (BComplex)histories[i]).get("enabled") == null || !(tmp.get("enabled") instanceof BBoolean)) continue;
            tmp.set("enabled", (BValue)BBoolean.make((boolean)flag));
        }
    }

    BObject[] getHistories() {
        Object[] histories = new BObject[]{};
        BOrd bqlOrd = BOrd.make((String)"slot:|bql:select slotPath from history:HistoryExt");
        BITable result = (BITable)bqlOrd.resolve((BObject)this).get();
        TableCursor c = result.cursor();
        while (c.next()) {
            histories = (BObject[])ArrayUtil.addOne((Object[])histories, (Object)c.get());
        }
        return histories;
    }

    @Override
    public BIcon getIcon() {
        if (this.isRunning() && this.getHistories().length > 0) {
            return iconHist;
        }
        BIcon i = Util.getIcon((BComplex)this);
        if (i.isNull()) {
            return icon;
        }
        return i;
    }

    public abstract BValue getIn();

    public abstract void added(Property var1, Context var2);

    public abstract void doCalculate();

    public abstract void doSetToday(BValue var1);

    public abstract void doSetWeekToDate(BValue var1);

    public abstract void doSetMonthToDate(BValue var1);

    public abstract void doSetYearToDate(BValue var1);

    public abstract Property getInProp();

    public abstract Property getTodayProp();

    public abstract Property getYesterdayProp();

    public abstract Property getWeekToDateProp();

    public abstract Property getLastWeekProp();

    public abstract Property getMonthToDateProp();

    public abstract Property getLastMonthProp();

    public abstract Property getYearToDateProp();

    public abstract Property getLastYearProp();
}

