/*
 * Decompiled with CFR 0.152.
 */
package javax.baja.ui.wizard;

import com.tridium.ui.theme.Theme;
import javax.baja.gx.BColor;
import javax.baja.gx.BImage;
import javax.baja.gx.Graphics;
import javax.baja.nre.annotations.Generated;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.sys.BValue;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.ui.BLabel;
import javax.baja.ui.BWidget;
import javax.baja.ui.enums.BHalign;

@NiagaraType
public class BWizardHeader
extends BWidget {
    @Generated
    public static final Type TYPE = Sys.loadType(BWizardHeader.class);
    private static final double margin = 5.0;
    private BLabel title;
    private BLabel description;
    private BLabel icon;

    @Override
    @Generated
    public Type getType() {
        return TYPE;
    }

    public BWizardHeader(BImage icon, String title, String description) {
        this.icon = new BLabel(icon);
        this.add("icon", (BValue)this.icon);
        this.title = new BLabel(title, BHalign.left);
        this.title.setFont(Theme.widget().getLargeBoldFont());
        this.add("title", (BValue)this.title);
        this.description = new BLabel(description, BHalign.left);
        this.add("description", (BValue)this.description);
    }

    public BWizardHeader(BImage icon, String title) {
        this(icon, title, "");
    }

    public BWizardHeader() {
        this(null, "", "");
    }

    public String getTitle() {
        return this.title.getText();
    }

    public void setTitle(String title) {
        if (title == null) {
            title = "";
        }
        this.title.setText(title);
        this.relayout();
    }

    public String getDescription() {
        return this.description.getText();
    }

    public void setDescription(String description) {
        if (description == null) {
            description = "";
        }
        this.description.setText(description);
        this.relayout();
    }

    public BImage getImage() {
        return this.icon.getImage();
    }

    public void setIcon(BImage image) {
        this.icon.setImage(image);
    }

    @Override
    public void computePreferredSize() {
        this.icon.computePreferredSize();
        double iw = this.icon.getPreferredWidth();
        double ih = this.icon.getPreferredHeight();
        boolean titleVisible = !this.title.getText().equals("");
        this.title.computePreferredSize();
        double tw = this.title.getPreferredWidth();
        double th = this.title.getPreferredHeight();
        if (!titleVisible) {
            th = 0.0;
            tw = 0.0;
        }
        boolean descriptionVisible = !this.description.getText().equals("");
        this.description.computePreferredSize();
        double dw = this.description.getPreferredWidth();
        double dh = this.description.getPreferredHeight();
        if (!descriptionVisible) {
            dh = 0.0;
            dw = 0.0;
        }
        double w = 5.0 + iw + 5.0 + Math.max(tw, dw) + 5.0;
        double h = 5.0 + Math.max(ih, th + dh) + 5.0;
        this.setPreferredSize(w, h);
    }

    @Override
    public void doLayout(BWidget[] kids) {
        double tx;
        double h = this.getHeight();
        this.icon.computePreferredSize();
        double iw = this.icon.getPreferredWidth();
        double ih = this.icon.getPreferredHeight();
        double ix = 5.0;
        double iy = (h - ih) / 2.0;
        boolean titleVisible = !this.title.getText().equals("");
        this.title.computePreferredSize();
        double tw = this.title.getPreferredWidth();
        double th = this.title.getPreferredHeight();
        if (!titleVisible) {
            th = 0.0;
            tw = 0.0;
        }
        boolean descriptionVisible = !this.description.getText().equals("");
        this.description.computePreferredSize();
        double dw = this.description.getPreferredWidth();
        double dh = this.description.getPreferredHeight();
        if (!descriptionVisible) {
            dh = 0.0;
            dw = 0.0;
        }
        double dx = tx = ix + iw + 5.0;
        double ty = 0.0;
        double dy = 0.0;
        if (titleVisible) {
            if (descriptionVisible) {
                double tdh = th + dh;
                ty = (h - tdh) / 2.0;
                dy = ty + th;
            } else {
                ty = (h - th) / 2.0;
            }
        } else if (descriptionVisible) {
            dy = (h - dh) / 2.0;
        }
        this.icon.setBounds(ix, iy, iw, ih);
        this.title.setBounds(tx, ty, tw, th);
        this.description.setBounds(dx, dy, dw, dh);
    }

    @Override
    public void paint(Graphics g) {
        double w = this.getWidth();
        double h = this.getHeight();
        g.setBrush(Theme.widget().getControlHeader());
        g.fillRect(0.0, 0.0, w, h - 1.0);
        this.paintChildren(g);
        g.setBrush(BColor.black);
        g.strokeLine(0.0, h - 1.0, w, h - 1.0);
    }
}

