/*
 * Decompiled with CFR 0.152.
 */
package javax.baja.ui.tree;

import com.tridium.ui.theme.Theme;
import java.util.ArrayList;
import javax.baja.gx.Graphics;
import javax.baja.gx.IRectGeom;
import javax.baja.gx.RectGeom;
import javax.baja.gx.Size;
import javax.baja.nre.annotations.Generated;
import javax.baja.nre.annotations.NiagaraProperty;
import javax.baja.nre.annotations.NiagaraTopic;
import javax.baja.nre.annotations.NiagaraTopics;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.sys.BValue;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Topic;
import javax.baja.sys.Type;
import javax.baja.ui.BWidget;
import javax.baja.ui.BWidgetShell;
import javax.baja.ui.CommandArtifact;
import javax.baja.ui.event.BFocusEvent;
import javax.baja.ui.event.BKeyEvent;
import javax.baja.ui.event.BMouseEvent;
import javax.baja.ui.event.BMouseWheelEvent;
import javax.baja.ui.event.BWidgetEvent;
import javax.baja.ui.pane.BTreePane;
import javax.baja.ui.transfer.BTransferWidget;
import javax.baja.ui.transfer.TransferContext;
import javax.baja.ui.transfer.TransferEnvelope;
import javax.baja.ui.tree.TreeController;
import javax.baja.ui.tree.TreeModel;
import javax.baja.ui.tree.TreeNode;
import javax.baja.ui.tree.TreeNodeRenderer;
import javax.baja.ui.tree.TreeSelection;

@NiagaraType
@NiagaraProperty(name="multipleSelection", type="boolean", defaultValue="false")
@NiagaraTopics(value={@NiagaraTopic(name="actionPerformed", eventType="BWidgetEvent"), @NiagaraTopic(name="cancelled", eventType="BWidgetEvent"), @NiagaraTopic(name="treeModified", eventType="BWidgetEvent"), @NiagaraTopic(name="selectionModified", eventType="BWidgetEvent")})
public class BTree
extends BTransferWidget {
    @Generated
    public static final Property multipleSelection = BTree.newProperty((int)0, (boolean)false, null);
    @Generated
    public static final Topic actionPerformed = BTree.newTopic((int)0, null);
    @Generated
    public static final Topic cancelled = BTree.newTopic((int)0, null);
    @Generated
    public static final Topic treeModified = BTree.newTopic((int)0, null);
    @Generated
    public static final Topic selectionModified = BTree.newTopic((int)0, null);
    @Generated
    public static final Type TYPE = Sys.loadType(BTree.class);
    TreeModel model;
    TreeController controller;
    TreeNodeRenderer nodeRenderer;
    TreeSelection selection;
    ArrayList<TreeNode> visibleNodes = new ArrayList(64);
    TreeNode toVisible = null;
    TreeNode lastExpand = null;
    RectGeom toVisibleRect = null;

    @Generated
    public boolean getMultipleSelection() {
        return this.getBoolean(multipleSelection);
    }

    @Generated
    public void setMultipleSelection(boolean v) {
        this.setBoolean(multipleSelection, v, null);
    }

    @Generated
    public void fireActionPerformed(BWidgetEvent event) {
        this.fire(actionPerformed, (BValue)event, null);
    }

    @Generated
    public void fireCancelled(BWidgetEvent event) {
        this.fire(cancelled, (BValue)event, null);
    }

    @Generated
    public void fireTreeModified(BWidgetEvent event) {
        this.fire(treeModified, (BValue)event, null);
    }

    @Generated
    public void fireSelectionModified(BWidgetEvent event) {
        this.fire(selectionModified, (BValue)event, null);
    }

    @Override
    @Generated
    public Type getType() {
        return TYPE;
    }

    public BTree() {
        this(new TreeModel.DefaultTreeModel(), new TreeController());
    }

    public BTree(TreeModel model) {
        this(model, new TreeController());
    }

    public BTree(TreeModel model, TreeController controller) {
        this.setModel(model);
        this.setController(controller);
        this.setNodeRenderer(new TreeNodeRenderer());
        this.setSelection(new TreeSelection());
    }

    public TreeModel getModel() {
        return this.model;
    }

    public void setModel(TreeModel model) {
        this.installSupport(this.model, model);
        this.model = model;
        this.visibleNodes = new ArrayList(64);
        this.toVisible = null;
        this.lastExpand = null;
        this.toVisibleRect = null;
    }

    public TreeController getController() {
        return this.controller;
    }

    public void setController(TreeController controller) {
        this.installSupport(this.controller, controller);
        this.controller = controller;
    }

    public TreeNodeRenderer getNodeRenderer() {
        return this.nodeRenderer;
    }

    public void setNodeRenderer(TreeNodeRenderer r) {
        this.installSupport(this.nodeRenderer, r);
        this.nodeRenderer = r;
    }

    public TreeSelection getSelection() {
        return this.selection;
    }

    public void setSelection(TreeSelection selModel) {
        this.installSupport(this.selection, selModel);
        this.selection = selModel;
    }

    private void installSupport(TreeSupport old, TreeSupport support) {
        if (support == null) {
            throw new NullPointerException();
        }
        if (old == support) {
            return;
        }
        if (support.tree != null) {
            throw new IllegalArgumentException("Already installed on another tree");
        }
        if (old != null) {
            old.tree = null;
        }
        support.tree = this;
    }

    @Override
    public void computePreferredSize() {
        Size prefSize = new Size(0.0, 0.0);
        prefSize = this.doLayout(null, prefSize);
        this.setPreferredSize(prefSize.width, prefSize.height);
    }

    @Override
    public void doLayout(BWidget[] children) {
        this.doLayout(children, null);
        if (this.toVisibleRect != null) {
            this.scrollToVisible(this.toVisibleRect);
        }
        this.lastExpand = null;
        this.toVisibleRect = null;
    }

    public Size doLayout(BWidget[] children, Size prefSize) {
        if (prefSize == null) {
            prefSize = new Size(0.0, 0.0);
        }
        double x = Theme.tree().getInsets().left;
        double y = Theme.tree().getInsets().top;
        this.visibleNodes.clear();
        TreeModel model = this.model;
        int rootCount = model.getRootCount();
        for (int i = 0; i < rootCount; ++i) {
            y = model.getRoot(i).layout(x, y, i == 0, i == rootCount - 1, this.visibleNodes, prefSize);
        }
        prefSize.height = y;
        if (this.getParent() instanceof BTreePane) {
            prefSize.height += this.getRowHeight();
        }
        return prefSize;
    }

    public double getRowHeight() {
        return Math.max(Theme.tree().getExpanderHeight(), this.nodeRenderer.getHeight());
    }

    public int getRow(double y) {
        double rowHeight = this.getRowHeight();
        if ((y -= Theme.tree().getInsets().top) < 0.0) {
            y = 0.0;
        }
        return (int)(y / rowHeight);
    }

    public TreeNode yToTreeNode(double y) {
        int row = this.getRow(y);
        if (row >= this.visibleNodes.size()) {
            return null;
        }
        return this.visibleNodes.get(row);
    }

    public TreeNode getPrevious(TreeNode startNode) {
        double y = startNode.getY();
        int row = this.getRow(y);
        if (row == 0) {
            return null;
        }
        return this.visibleNodes.get(row - 1);
    }

    public TreeNode getNext(TreeNode startNode) {
        double y = startNode.getY();
        int row = this.getRow(y);
        if (row == this.visibleNodes.size() - 1) {
            return null;
        }
        return this.visibleNodes.get(row + 1);
    }

    @Override
    public void paint(Graphics g) {
        IRectGeom clip = g.getClipBounds();
        g.setBrush(Theme.tree().getBackground(this));
        g.fillRect(0.0, 0.0, this.getWidth(), this.getHeight());
        int rootCount = this.model.getRootCount();
        double height = this.nodeRenderer.getHeight();
        double viewTop = clip.y();
        double viewBottom = clip.y() + clip.height();
        double prevY = 0.0;
        boolean belowBottom = false;
        for (int i = 0; i < rootCount; ++i) {
            TreeNode nextRoot;
            TreeNode thisRoot = this.model.getRoot(i);
            if (thisRoot.getY() > viewBottom) {
                if (belowBottom) break;
                belowBottom = true;
            }
            TreeNode treeNode = nextRoot = i == rootCount - 1 ? null : this.model.getRoot(i + 1);
            if (nextRoot != null && nextRoot.getY() <= viewTop) continue;
            prevY = thisRoot.paint(g, prevY);
            if (this.toVisible == null) continue;
            RectGeom nodeRect = new RectGeom(this.toVisible.getX(), this.toVisible.getY(), this.toVisible.getWidth() + 4.0, this.getRowHeight());
            this.scrollToVisible(nodeRect);
            this.toVisible = null;
        }
    }

    @Override
    public String getStyleSelector() {
        return "tree";
    }

    public final void toggleExpanded(TreeNode node) {
        this.setExpanded(node, !node.isExpanded());
    }

    public void setExpanded(TreeNode node, boolean exp) {
        if (node.isExpanded() == exp) {
            return;
        }
        node.setExpanded(exp);
        if (!exp) {
            this.selection.collapsed(node);
            this.controller.collapsed(node);
        } else {
            this.selection.expanded(node);
            this.controller.expanded(node);
            this.lastExpand = node;
        }
        this.relayout();
    }

    public void expandToNode(TreeNode node) {
        this.expandPath(node.getPathFromRoot());
    }

    public void expandPath(TreeNode[] path) {
        int count = path.length;
        for (int i = 0; i < count - 1; ++i) {
            path[i].setExpanded(true);
        }
        this.relayout();
    }

    public void scrollNodeToVisible(TreeNode node) {
        this.scrollPathToVisible(node.getPathFromRoot());
    }

    public void scrollPathToVisible(TreeNode[] path) {
        this.toVisible = path[path.length - 1];
        this.expandPath(path);
    }

    @Override
    public Object widgetSupport(Object arg) {
        if (arg instanceof TreeNode) {
            if (arg == this.lastExpand) {
                return Boolean.TRUE;
            }
            return null;
        }
        if (arg instanceof RectGeom) {
            this.toVisibleRect = (RectGeom)arg;
            return null;
        }
        return super.widgetSupport(arg);
    }

    @Override
    public boolean isFocusTraversable() {
        return this.controller.isFocusTraversable();
    }

    @Override
    public void focusGained(BFocusEvent event) {
        this.controller.focusGained(event);
    }

    @Override
    public void focusLost(BFocusEvent event) {
        this.controller.focusLost(event);
    }

    @Override
    public void mousePressed(BMouseEvent evt) {
        this.controller.mousePressed(evt);
    }

    @Override
    public void mouseReleased(BMouseEvent evt) {
        this.controller.mouseReleased(evt);
    }

    @Override
    public void mouseEntered(BMouseEvent evt) {
        this.controller.mouseEntered(evt);
    }

    @Override
    public void mouseExited(BMouseEvent evt) {
        this.controller.mouseExited(evt);
    }

    @Override
    public void mousePulsed(BMouseEvent evt) {
        this.controller.mousePulsed(evt);
    }

    @Override
    public void mouseMoved(BMouseEvent evt) {
        this.controller.mouseMoved(evt);
    }

    @Override
    public void mouseDragged(BMouseEvent evt) {
        this.controller.mouseDragged(evt);
    }

    @Override
    public void mouseWheel(BMouseWheelEvent evt) {
        this.controller.mouseWheel(evt);
    }

    @Override
    public void keyPressed(BKeyEvent evt) {
        this.controller.keyPressed(evt);
    }

    @Override
    public void keyReleased(BKeyEvent evt) {
        this.controller.keyReleased(evt);
    }

    @Override
    public void keyTyped(BKeyEvent evt) {
        this.controller.keyTyped(evt);
    }

    @Override
    public TransferEnvelope getTransferData() throws Exception {
        throw new UnsupportedOperationException();
    }

    @Override
    public CommandArtifact insertTransferData(TransferContext cx) throws Exception {
        throw new UnsupportedOperationException();
    }

    @Override
    public CommandArtifact removeTransferData(TransferContext cx) throws Exception {
        throw new UnsupportedOperationException();
    }

    @Override
    public int dragOver(TransferContext cx) {
        if (cx.isPulse()) {
            this.controller.pulseViewport(cx.getX(), cx.getY());
        }
        return super.dragOver(cx);
    }

    public TreeNode[] getVisibleNodes() {
        TreeNode[] arr = new TreeNode[this.visibleNodes.size()];
        for (int i = 0; i < this.visibleNodes.size(); ++i) {
            arr[i] = this.visibleNodes.get(i);
        }
        return arr;
    }

    public static abstract class TreeSupport {
        BTree tree;

        public final BTree getTree() {
            return this.tree;
        }

        public final TreeModel getModel() {
            return this.tree.model;
        }

        public final TreeController getController() {
            return this.tree.controller;
        }

        public final TreeNodeRenderer getNodeRenderer() {
            return this.tree.nodeRenderer;
        }

        public final TreeSelection getSelection() {
            return this.tree.selection;
        }

        public final BWidgetShell getShell() {
            return this.tree.getShell();
        }
    }
}

