/*
 * Decompiled with CFR 0.152.
 */
package javax.baja.ui.text.commands;

import javax.baja.ui.CommandArtifact;
import javax.baja.ui.text.BTextEditor;
import javax.baja.ui.text.Position;

class LineShiftArtifact
implements CommandArtifact {
    BTextEditor editor;
    boolean right;
    int line0;
    int line1;

    LineShiftArtifact(BTextEditor editor, boolean right) {
        this.editor = editor;
        this.right = right;
        Position start = editor.getSelection().getStart();
        Position end = editor.getSelection().getEnd();
        this.line0 = start.line;
        this.line1 = end.column > 0 ? end.line : end.line - 1;
    }

    private void shiftLeft() {
        String[] lines = this.getLines();
        String text = this.shiftLeft(lines);
        Position rs = new Position(this.line0, 0);
        Position re = new Position(this.line1, this.editor.getModel().getLine(this.line1).getColumnCount());
        this.editor.getModel().remove(rs, re);
        this.editor.getModel().insert(rs, text);
    }

    private String shiftLeft(String[] lines) {
        StringBuilder s = new StringBuilder();
        int spaces = this.editor.getOptions().getTabToSpaceConversion();
        for (int i = 0; i < lines.length; ++i) {
            char c;
            int j;
            String line = lines[i];
            for (j = 0; j < spaces && (j >= line.length() || (c = line.charAt(j)) == ' '); ++j) {
            }
            while (j < line.length()) {
                s.append(line.charAt(j));
                ++j;
            }
        }
        return s.toString();
    }

    private void shiftRight() {
        String[] lines = this.getLines();
        String text = this.shiftRight(lines);
        Position rs = new Position(this.line0, 0);
        Position re = new Position(this.line1, this.editor.getModel().getLine(this.line1).getColumnCount());
        this.editor.getModel().remove(rs, re);
        this.editor.getModel().insert(rs, text);
    }

    private String shiftRight(String[] lines) {
        StringBuilder s = new StringBuilder();
        int spaces = this.editor.getOptions().getTabToSpaceConversion();
        for (int i = 0; i < lines.length; ++i) {
            String line = lines[i];
            for (int j = 0; j < spaces; ++j) {
                s.append(' ');
            }
            s.append(lines[i]);
        }
        return s.toString();
    }

    private String[] getLines() {
        String[] lines = new String[this.line1 - this.line0 + 1];
        for (int i = 0; i < lines.length; ++i) {
            lines[i] = new String(this.editor.getModel().getLine((int)(i + this.line0)).buffer);
        }
        return lines;
    }

    @Override
    public void undo() {
        if (this.right) {
            this.shiftLeft();
        } else {
            this.shiftRight();
        }
    }

    @Override
    public void redo() {
        if (this.right) {
            this.shiftRight();
        } else {
            this.shiftLeft();
        }
    }
}

