/*
 * Decompiled with CFR 0.152.
 */
package javax.baja.ui.text;

import java.util.ArrayList;
import javax.baja.ui.text.BTextEditor;
import javax.baja.ui.text.Line;
import javax.baja.ui.text.Segment;

public class TextParser
extends BTextEditor.TextSupport {
    protected char[] buffer;
    protected int length;
    protected int lineStart;
    protected int segmentStart;
    protected int pos;
    protected int lastLast = -1;
    protected int last = -1;
    protected int current = -1;
    protected int next = -1;

    public synchronized Line[] parse(char[] buffer) {
        this.buffer = buffer;
        this.length = buffer.length;
        this.pos = 0;
        this.last = -1;
        this.current = this.length > 0 ? buffer[0] : -1;
        this.next = this.length > 1 ? buffer[1] : -1;
        this.segmentStart = 0;
        this.lineStart = 0;
        ArrayList<Line> lines = new ArrayList<Line>();
        ArrayList<Segment> segments = new ArrayList<Segment>();
        while (this.pos < this.length) {
            Segment seg = this.nextSegment();
            segments.add(seg);
            if (seg.type == 3) {
                int len = this.pos - this.lineStart;
                if (seg.modifiers == 4) {
                    --len;
                }
                lines.add(new Line(buffer, this.lineStart, len, segments));
                segments.clear();
                this.lineStart = this.pos;
            }
            this.segmentStart = this.pos;
        }
        if (segments.size() > 0) {
            lines.add(new Line(buffer, this.lineStart, buffer.length - this.lineStart, segments));
        }
        if (lines.size() == 0) {
            lines.add(new Line(new char[0], new Segment[0]));
        }
        return lines.toArray(new Line[0]);
    }

    protected Segment nextSegment() {
        Segment whitespace = this.parseWhitespace();
        if (whitespace != null) {
            return whitespace;
        }
        int c = this.current;
        while (c != 32 && c != 10 && c != 13 && c != 9 && this.advance()) {
            c = this.current;
        }
        return this.newSegment(0, 8);
    }

    protected Segment parseWhitespace() {
        int c = this.current;
        if (c == 10 || c == 13) {
            int mod = 1;
            int p = this.pos;
            if (c == 13) {
                mod = 2;
                this.buffer[p] = 10;
                if (this.next == 10) {
                    this.advance();
                    mod = 4;
                }
            }
            this.advance();
            return new Segment(3, mod, p - this.lineStart, 1);
        }
        if (c == 32 || c == 9) {
            boolean n = true;
            while (this.current == 32 || this.current == 9) {
                if (this.current == 9) {
                    this.buffer[this.pos] = 32;
                }
                this.advance();
            }
            return this.newSegment(1);
        }
        return null;
    }

    protected final Segment newSegment(int type) {
        return new Segment(type, this.segmentStart - this.lineStart, this.pos - this.segmentStart);
    }

    protected final Segment newSegment(int type, int subType) {
        return new Segment(type, subType, this.segmentStart - this.lineStart, this.pos - this.segmentStart);
    }

    protected final int getSegmentOffset() {
        return this.segmentStart - this.lineStart;
    }

    protected final int getSegmentLength() {
        return this.pos - this.segmentStart - 1;
    }

    protected final boolean advance() {
        ++this.pos;
        this.lastLast = this.last;
        this.last = this.current;
        this.current = this.next;
        this.next = this.pos + 1 < this.length ? this.buffer[this.pos + 1] : -1;
        return this.current != -1;
    }

    protected boolean isCurrent(String s) {
        int i;
        int len = s.length();
        if (this.pos + len >= this.length) {
            return false;
        }
        for (i = 0; i < len; ++i) {
            if (this.buffer[this.pos + i] == s.charAt(i)) continue;
            return false;
        }
        for (i = 0; i < len; ++i) {
            this.advance();
        }
        return true;
    }
}

