/*
 * Decompiled with CFR 0.152.
 */
package javax.baja.ui.text;

import com.tridium.ui.UiEnv;
import java.lang.reflect.Constructor;
import java.text.AttributedCharacterIterator;
import java.text.AttributedString;
import javax.baja.nre.util.TextUtil;
import javax.baja.ui.Command;
import javax.baja.ui.CommandArtifact;
import javax.baja.ui.MouseCursor;
import javax.baja.ui.event.BFocusEvent;
import javax.baja.ui.event.BInputMethodEvent;
import javax.baja.ui.event.BKeyEvent;
import javax.baja.ui.event.BMouseEvent;
import javax.baja.ui.text.BKeyBindings;
import javax.baja.ui.text.BTextEditor;
import javax.baja.ui.text.BTextEditorOptions;
import javax.baja.ui.text.Line;
import javax.baja.ui.text.Position;
import javax.baja.ui.text.Segment;
import javax.baja.ui.text.TextRenderer;
import javax.baja.ui.text.commands.ComposeText;
import javax.baja.ui.text.commands.InsertText;

public class TextController
extends BTextEditor.TextSupport {
    private StringBuffer committedText = new StringBuffer();
    private AttributedCharacterIterator composedText = null;
    private Position composedOriginPos = null;
    private int composedStart = 0;
    private int composedEnd = 0;
    static final char BACKSPACE = '\b';
    static final char TAB = '\t';
    static final char NEWLINE = '\n';
    static final char ESCAPE = '\u001b';
    static final char DELETE = '\u007f';
    private Position mouseAnchor;
    protected final ITextControllerImpl impl;

    public TextController() {
        ITextControllerImpl im;
        try {
            Class<?> awtComponentClass = Class.forName("java.awt.Component");
            Constructor<?> ctor = Class.forName("com.tridium.ui.awt.se.AwtTextControllerImpl").getConstructor(TextController.class);
            im = (ITextControllerImpl)ctor.newInstance(this);
        }
        catch (Throwable e) {
            im = new TextControllerImpl(this);
        }
        this.impl = im;
    }

    public boolean isFocusTraversable() {
        return true;
    }

    public void focusGained(BFocusEvent event) {
        BTextEditor editor = this.getEditor();
        editor.setCaretBlinking(true);
        if (editor.isSingleLine() && editor.isEditable()) {
            this.getSelection().selectAll();
        }
    }

    public void focusLost(BFocusEvent event) {
        this.getEditor().setCaretBlinking(false);
        this.getSelection().deselect();
    }

    public void keyPressed(BKeyEvent event) {
        int keyCode = event.getKeyCode();
        this.clearMatchHighlight();
        if (this.getEditor().isSingleLine() && (keyCode == 9 || keyCode == 38 || keyCode == 40)) {
            return;
        }
        BKeyBindings keys = this.getOptions().getKeyBindings();
        Command command = keys.eventToCommand(this.getEditor(), event);
        if (command != null) {
            event.consume();
            command.invoke();
        }
        if (event.isAltDown() && event.isControlDown() && event.getKeyCode() == 123) {
            this.getEditor().getModel().dump();
        }
        if (keyCode == 10 && !this.getEditor().isSingleLine()) {
            event.consume();
        }
    }

    public void keyReleased(BKeyEvent event) {
        int keyCode = event.getKeyCode();
        if (keyCode == 10 && !this.getEditor().isSingleLine()) {
            event.consume();
        }
    }

    public void keyTyped(BKeyEvent event) {
        int col;
        char key = event.getKeyChar();
        if (event.isControlDown() || event.isAltDown()) {
            return;
        }
        event.consume();
        if (key == '\b' || key == '\t' || key == '\u001b' || key == '\u007f') {
            return;
        }
        String text = String.valueOf(key);
        if (key == '\n' && (col = this.columnForNewline()) > 0) {
            text = text + TextUtil.getSpaces((int)col);
        }
        this.insertText(text);
        if (this.composedText != null) {
            this.composedText = null;
            this.committedText = new StringBuffer();
            this.setComposedPosition(null);
            this.setTextBeginIndex(0);
            this.setTextEndIndex(0);
        }
        BTextEditorOptions options = this.getEditor().getOptions();
        if (key == '}' && options.getMatchBraces()) {
            this.matchPrev('{', '}');
        }
        if (key == ')' && options.getMatchParens()) {
            this.matchPrev('(', ')');
        }
        if (key == ']' && options.getMatchBrackets()) {
            this.matchPrev('[', ']');
        }
    }

    private void insertText(String text) {
        if (this.validateTextToInsert(text)) {
            new InsertText(this.getEditor(), text).invoke();
        }
    }

    protected CommandArtifact doInsertText(String text) {
        if (this.validateTextToInsert(text)) {
            return new InsertText(this.getEditor(), text).doInvoke();
        }
        return null;
    }

    protected boolean validateTextToInsert(String text) {
        return true;
    }

    protected int columnForNewline() {
        Position cur = this.getEditor().getCaretPosition();
        if (cur.line == 0) {
            return 0;
        }
        Line line = this.getModel().getLine(cur.line);
        int n = -1;
        for (int i = 0; i < line.segments.length; ++i) {
            if (line.segments[i].isWhitespace()) continue;
            n = i;
            break;
        }
        if (n != -1) {
            return line.segments[n].offset;
        }
        return cur.column;
    }

    public void caretPositionChanged(BInputMethodEvent event) {
        System.out.println("TextController - change the character at the current position");
    }

    public void imTextChanged(BInputMethodEvent event) {
        boolean deleteComposed = true;
        if (this.composedText == null) {
            deleteComposed = false;
        }
        int committedCharacterCount = event.getCommittedCharacterCount();
        AttributedCharacterIterator combinedText = event.getText();
        this.composedText = null;
        char c = '\u0000';
        if (combinedText != null) {
            int toCopy = committedCharacterCount;
            c = combinedText.first();
            while (toCopy-- > 0) {
                this.committedText.append(c);
                c = combinedText.next();
            }
            if (combinedText.getEndIndex() - (combinedText.getBeginIndex() + committedCharacterCount) > 0) {
                AttributedString composedTextString = new AttributedString(combinedText, combinedText.getBeginIndex() + committedCharacterCount, combinedText.getEndIndex(), this.impl.getIMAtrributes());
                this.composedText = composedTextString.getIterator();
            }
        }
        event.consume();
        String composedTextString = this.getText(this.composedText);
        int composedBeginIndex = this.composedText == null ? 0 : combinedText.getBeginIndex();
        int composedEndIndex = this.composedText == null ? 0 : combinedText.getEndIndex();
        boolean commit = false;
        if (committedCharacterCount > 0) {
            commit = true;
        }
        new ComposeText(this.getEditor(), composedTextString, this.committedText.toString(), composedBeginIndex, composedEndIndex, event.getCaret().getCharIndex(), commit, deleteComposed).invoke();
        if (committedCharacterCount == 0) {
            this.committedText = new StringBuffer();
        }
    }

    protected String getText(AttributedCharacterIterator aci) {
        if (aci == null) {
            return "";
        }
        StringBuilder sb = new StringBuilder(aci.getEndIndex() - aci.getBeginIndex());
        char c = aci.first();
        while (c != '\uffff') {
            sb.append(c);
            c = aci.next();
        }
        return sb.toString();
    }

    private void matchPrev(char open, char close) {
        Position pos = this.getEditor().getCaretPosition();
        int depth = 1;
        int q = pos.line;
        int c = pos.column - 2;
        if (c < 0) {
            --q;
            c = -1;
        }
        block0: while (q >= 0) {
            Line line = this.getModel().getLine(q);
            char[] buf = line.buffer;
            if (c == -1) {
                c = buf.length - 1;
            }
            while (c >= 0) {
                char ch = buf[c];
                if (ch == close) {
                    ++depth;
                }
                if (ch == open) {
                    --depth;
                }
                if (depth == 0) break block0;
                --c;
            }
            --q;
        }
        if (q == -1) {
            return;
        }
        if (q == pos.line && c == pos.column - 2) {
            return;
        }
        TextRenderer renderer = this.getEditor().getRenderer();
        renderer.matchOpenPos = new Position(q, c);
        renderer.matchClosePos = new Position(pos.line, pos.column - 1);
    }

    public void clearMatchHighlight() {
        TextRenderer renderer = this.getEditor().getRenderer();
        if (renderer != null) {
            renderer.matchOpenPos = null;
            renderer.matchClosePos = null;
        }
    }

    public void mousePressed(BMouseEvent event) {
        this.getEditor().requestFocus();
        Position pos = this.mouseEventToPosition(event);
        if (event.isShiftDown()) {
            this.mouseAnchor = this.getSelection().getAnchor();
            if (this.mouseAnchor == null) {
                this.mouseAnchor = this.getEditor().getCaretPosition();
            }
            this.getSelection().select(this.mouseAnchor, pos);
        } else {
            this.mouseAnchor = pos;
            this.getSelection().deselect();
        }
        this.getEditor().moveCaretPosition(pos);
        this.getEditor().updateAnchorX();
        if (event.getClickCount() % 2 == 0) {
            Line line = this.getModel().getLine(pos.line);
            Segment seg = line.getSegmentAt(pos.column);
            if (seg == null) {
                int len = line.segments.length;
                if (len > 1) {
                    seg = line.segments[len - 2];
                } else if (len > 0) {
                    seg = line.segments[len - 1];
                }
            }
            if (seg != null) {
                Position start = new Position(pos.line, seg.offset);
                Position end = new Position(pos.line, seg.offset + seg.length);
                this.getSelection().select(start, end);
            }
        } else if (event.getClickCount() % 3 == 0) {
            Line line = this.getModel().getLine(pos.line);
            Position start = new Position(pos.line, 0);
            Position end = new Position(pos.line + 1, 0);
            Position docEnd = this.getModel().getEndPosition();
            if (end.compareTo(docEnd) > 0) {
                end = docEnd;
            }
            this.getSelection().select(start, end);
            this.getEditor().moveCaretPosition(pos);
        }
    }

    public void mouseReleased(BMouseEvent event) {
        BTextEditor editor = this.getEditor();
        if (!UiEnv.get().hasKeyboard() && editor.isEditable()) {
            UiEnv.get().input(editor);
            return;
        }
    }

    public void mouseEntered(BMouseEvent event) {
        this.getEditor().setMouseCursor(MouseCursor.text);
    }

    public void mouseExited(BMouseEvent event) {
        this.getEditor().setMouseCursor(MouseCursor.normal);
    }

    public void mouseMoved(BMouseEvent event) {
    }

    public void mouseDragged(BMouseEvent event) {
        Position pos;
        if (event.isButton1Down() && !(pos = this.mouseEventToPosition(event)).equals(this.getEditor().getCaretPosition())) {
            this.getSelection().select(this.mouseAnchor, pos);
            this.getEditor().moveCaretPosition(pos);
        }
    }

    public void mousePulsed(BMouseEvent event) {
    }

    private Position mouseEventToPosition(BMouseEvent event) {
        Position pos = this.getEditor().getPositionAt(event.getX(), event.getY());
        Position end = this.getModel().getEndPosition();
        int line = pos.line;
        int col = pos.column;
        if (line < 0) {
            line = 0;
        } else if (line > end.line) {
            line = end.line;
        }
        if (col < 0) {
            col = 0;
        } else if (line == end.line && col > end.column) {
            col = end.column;
        }
        return new Position(line, col);
    }

    public AttributedCharacterIterator cancelLatestCommittedText(AttributedCharacterIterator.Attribute[] attributes) {
        return null;
    }

    public AttributedCharacterIterator getCommittedText(int beginIndex, int endIndex, AttributedCharacterIterator.Attribute[] attributes) {
        AttributedString string = new AttributedString(this.committedText.toString());
        return string.getIterator(null, beginIndex, endIndex);
    }

    public int getCommittedTextLength() {
        return this.committedText.length();
    }

    public int getInsertPositionOffset() {
        return 0;
    }

    public Object getLocationOffset(int x, int y) {
        return this.impl.getLocationOffset(x, y);
    }

    public AttributedCharacterIterator getSelectedText(AttributedCharacterIterator.Attribute[] attributes) {
        return null;
    }

    public Object getTextLocation(Object offset) {
        return this.impl.getTextLocation(offset);
    }

    public int getTextBeginIndex() {
        return this.composedStart;
    }

    public int getTextEndIndex() {
        return this.composedEnd;
    }

    public void setTextBeginIndex(int index) {
        this.composedStart = index;
    }

    public void setTextEndIndex(int index) {
        this.composedEnd = index;
    }

    public Position getComposedPosition() {
        return this.composedOriginPos;
    }

    public void setComposedPosition(Position pos) {
        this.composedOriginPos = pos;
    }

    public static interface ITextControllerImpl {
        default public Object getLocationOffset(int x, int y) {
            return null;
        }

        default public AttributedCharacterIterator.Attribute[] getIMAtrributes() {
            return new AttributedCharacterIterator.Attribute[0];
        }

        default public Object getTextLocation(Object offset) {
            return null;
        }
    }

    public class TextControllerImpl
    implements ITextControllerImpl {
        private TextController textController;

        public TextControllerImpl(TextController textController) {
            this.textController = textController;
        }
    }
}

