/*
 * Decompiled with CFR 0.152.
 */
package javax.baja.ui.table;

import com.tridium.data.BDataTable;
import javax.baja.collection.BITable;
import javax.baja.data.BIDataValue;
import javax.baja.gx.BImage;
import javax.baja.naming.SlotPath;
import javax.baja.sys.BFacets;
import javax.baja.sys.BIObject;
import javax.baja.sys.BObject;
import javax.baja.sys.BString;
import javax.baja.sys.Type;
import javax.baja.ui.enums.BHalign;
import javax.baja.ui.event.BWidgetEvent;
import javax.baja.ui.table.BTable;

public abstract class TableModel
extends BTable.TableSupport {
    public abstract int getRowCount();

    public abstract int getColumnCount();

    public abstract String getColumnName(int var1);

    public abstract Object getValueAt(int var1, int var2);

    public Object getSubject(int row) {
        return this.getRowValues(row);
    }

    public BHalign getColumnAlignment(int col) {
        return BHalign.left;
    }

    public BImage getRowIcon(int row) {
        return null;
    }

    public String[] getColumnNames() {
        String[] names = new String[this.getColumnCount()];
        for (int c = 0; c < names.length; ++c) {
            names[c] = this.getColumnName(c);
        }
        return names;
    }

    public Object[] getRowValues(int row) {
        Object[] x = new Object[this.getColumnCount()];
        for (int c = 0; c < x.length; ++c) {
            x[c] = this.getValueAt(row, c);
        }
        return x;
    }

    public Object[] getColumnValues(int col) {
        Object[] x = new Object[this.getRowCount()];
        for (int r = 0; r < x.length; ++r) {
            x[r] = this.getValueAt(r, col);
        }
        return x;
    }

    public void updateTable() {
        this.updateTable(false);
    }

    public void updateTable(boolean resizeColumns) {
        BTable table = this.getTable();
        if (table != null) {
            if (resizeColumns) {
                this.getTable().sizeColumnsToFit();
            } else {
                this.getTable().relayout();
            }
            this.getTable().fireTableModified(new BWidgetEvent(1, this.getTable()));
        }
    }

    public boolean isColumnSortable(int col) {
        return false;
    }

    public void sortByColumn(int col, boolean ascending) {
        throw new UnsupportedOperationException();
    }

    public BITable<? extends BIObject> export() {
        int colCount = this.getColumnCount();
        int rowCount = this.getRowCount();
        BDataTable t = new BDataTable();
        for (int c = 0; c < colCount; ++c) {
            String displayName = this.getColumnName(c);
            String name = SlotPath.escape((String)displayName);
            Type type = BIDataValue.TYPE;
            t.addColumn(name, displayName, type, 0, BFacets.NULL);
        }
        t.startRows();
        for (int r = 0; r < rowCount; ++r) {
            t.startRow();
            for (int c = 0; c < colCount; ++c) {
                t.set(this.export(r, c).toDataValue(), BFacets.NULL);
            }
            t.endRow();
        }
        t.endRows();
        return t;
    }

    public BObject export(int row, int col) {
        Object cell = this.getValueAt(row, col);
        if (cell instanceof BObject) {
            return (BObject)cell;
        }
        return BString.make((String)String.valueOf(cell));
    }
}

