/*
 * Decompiled with CFR 0.152.
 */
package javax.baja.ui.px;

import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.util.HashMap;
import javax.baja.agent.BAbstractPxView;
import javax.baja.naming.SlotPath;
import javax.baja.nre.util.SortUtil;
import javax.baja.sys.BComplex;
import javax.baja.sys.BFacets;
import javax.baja.sys.BObject;
import javax.baja.sys.BSimple;
import javax.baja.sys.BValue;
import javax.baja.sys.Flags;
import javax.baja.sys.Property;
import javax.baja.sys.Slot;
import javax.baja.sys.SlotCursor;
import javax.baja.ui.BWidget;
import javax.baja.ui.pane.BPane;
import javax.baja.ui.px.BPxInclude;
import javax.baja.ui.px.PxLayer;
import javax.baja.ui.px.PxProperty;
import javax.baja.ui.util.WebProperty;
import javax.baja.util.BTypeSpec;
import javax.baja.xml.XWriter;

public class PxEncoder
extends XWriter {
    private static final int NEVER = 0;
    private static final int ATTRIB = 1;
    private static final int SUBELEM = 2;
    private boolean preserveIdentities;

    public PxEncoder(File file) throws IOException {
        super(file);
    }

    public PxEncoder(OutputStream out) throws IOException {
        super(out);
    }

    public boolean getPreserveIdentities() {
        return this.preserveIdentities;
    }

    public PxEncoder setPreserveIdentities(boolean preserve) {
        this.preserveIdentities = preserve;
        return this;
    }

    public void encodeDocument(BWidget widget) throws IOException {
        this.encodeDocument(widget, null, null);
    }

    public void encodeDocument(BWidget widget, PxProperty[] properties, BAbstractPxView view) throws IOException {
        this.encodeDocument(widget, properties, null, view);
    }

    public void encodeDocument(BWidget widget, PxProperty[] properties, PxLayer[] layers, BAbstractPxView view) throws IOException {
        this.encodeDocumentWithMedia(widget, properties, layers, view != null ? view.getMedia() : null);
    }

    public void encodeDocumentWithMedia(BWidget widget, PxProperty[] properties, PxLayer[] layers, BTypeSpec media) throws IOException {
        this.w("<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n");
        this.w("<!-- Niagara Presentation XML -->\n");
        this.w("<px version=\"1.0\"");
        if (media != null) {
            this.w(" media=\"").w((Object)media).w((Object)"\"");
        }
        this.w(">\n");
        this.encodeImport(widget);
        this.encodeProperties(widget, properties);
        this.encodeLayers(widget, layers);
        this.encodeContent(widget);
        this.w("</px>\n");
        this.flush();
    }

    private void encodeImport(BWidget widget) {
        HashMap<String, String> map = new HashMap<String, String>();
        this.scanModules(map, (BObject)widget);
        Object[] modules = map.keySet().toArray(new String[0]);
        SortUtil.sort((Object[])modules);
        this.w("<import>\n");
        for (int i = 0; i < modules.length; ++i) {
            this.w("  <module name=\"").w(modules[i]).w((Object)"\"/>\n");
        }
        this.w("</import>\n");
    }

    private void scanModules(HashMap<String, String> map, BObject value) {
        String module = value.getType().getModule().getModuleName();
        map.put(module, "");
        if (value instanceof BComplex) {
            SlotCursor c = ((BComplex)value).getProperties();
            while (c.next()) {
                if (c.getTypeAccess() != 7 || Flags.isRemoveOnClone((BComplex)((BComplex)value), (Slot)c.property())) continue;
                this.scanModules(map, (BObject)c.get());
            }
        }
    }

    private void encodeProperties(BWidget root, PxProperty[] props) throws IOException {
        if (props == null) {
            return;
        }
        if (props.length == 0) {
            return;
        }
        this.w("<properties>\n\n");
        for (int i = 0; i < props.length; ++i) {
            PxProperty prop = props[i];
            this.w("  <property");
            this.w(" name=\"").w((Object)prop.getName()).w((Object)"\"");
            this.w(" type=\"").w((Object)prop.getTypeSpec().toString()).w((Object)"\"");
            this.w(" value=\"").w((Object)((BSimple)prop.getValue()).encodeToString()).w((Object)"\"");
            this.w(">\n");
            SlotPath[] targets = prop.getTargets();
            for (int j = 0; j < targets.length; ++j) {
                this.w("    <target");
                this.w(" ord=\"").w((Object)targets[j]).w((Object)"\"");
                this.w("/>\n");
            }
            this.w("  </property>\n\n");
        }
        this.w("</properties>\n");
    }

    private void encodeLayers(BWidget root, PxLayer[] layers) throws IOException {
        if (layers == null) {
            return;
        }
        if (layers.length == 0) {
            return;
        }
        this.w("<layers>\n");
        for (int i = 0; i < layers.length; ++i) {
            PxLayer layer = layers[i];
            this.w("  <layer");
            this.w(" name=\"").w((Object)layer.getName()).w((Object)"\"");
            this.w(" status=\"").w((Object)layer.getStatus().encodeToString()).w((Object)"\"");
            this.w("/>\n");
        }
        this.w("</layers>\n");
    }

    private void encodeContent(BWidget widget) throws IOException {
        this.w("<content>\n");
        this.encodeToElem((BComplex)widget, null, (BValue)widget, 0);
        this.w("</content>\n");
    }

    private void encodeToElem(BComplex clx, Property prop, BValue v, int indent) throws IOException {
        String type = v.getType().getTypeName();
        this.indent(indent).w((Object)"<").w((Object)type);
        if (prop != null && (prop.isFrozen() || !v.isComponent() || this.preserveIdentities)) {
            this.w(" name=\"").w((Object)prop.getName()).w((Object)"\"");
        }
        if (this.preserveIdentities && v.isComponent() && v.asComponent().getHandle() != null) {
            this.w(" h=\"").w(v.asComponent().getHandle()).w((Object)"\"");
        }
        if (prop != null && WebProperty.isWebProperty(clx, prop)) {
            int flags = clx.getFlags((Slot)prop);
            this.w(" f=\"").safe(Flags.encodeToString((int)flags)).w((Object)"\"");
            BFacets facets = clx.getSlotFacets((Slot)prop);
            if (!facets.isEmpty()) {
                this.w(" ft=\"").safe(facets.encodeToString()).w((Object)"\"");
            }
        }
        if (v.isSimple()) {
            BSimple simple = (BSimple)v;
            this.w(" value=\"").safe(simple.encodeToString()).w((Object)"\"/>\n");
        } else {
            boolean emptyElem = this.encodeProps((BComplex)v, indent + 2);
            if (emptyElem) {
                this.w("/>\n");
            } else {
                this.indent(indent).w((Object)"</").w((Object)type).w((Object)">\n");
            }
        }
    }

    private boolean encodeProps(BComplex c, int indent) throws IOException {
        Property[] pa = c.getPropertiesArray();
        for (int i = 0; i < pa.length; ++i) {
            BValue value;
            Property prop = pa[i];
            if (Flags.isRemoveOnClone((BComplex)c, (Slot)prop) || this.encodeAs(c, prop, value = c.get(prop)) != 1) continue;
            this.w(' ').attr(prop.getName(), value.asSimple().encodeToString());
        }
        boolean emptyElem = true;
        boolean extraWhitespace = c instanceof BPane;
        for (int i = 0; i < pa.length; ++i) {
            BValue value;
            Property prop = pa[i];
            if (Flags.isRemoveOnClone((BComplex)c, (Slot)prop) || this.encodeAs(c, prop, value = c.get(prop)) != 2) continue;
            if (emptyElem) {
                this.w(">\n");
                if (extraWhitespace) {
                    this.w("\n");
                }
                emptyElem = false;
            }
            this.encodeToElem(c, prop, value, indent);
            if (!extraWhitespace) continue;
            this.w("\n");
        }
        return emptyElem;
    }

    private int encodeAs(BComplex c, Property prop, BValue propVal) {
        if (prop.isFrozen()) {
            if (Flags.isTransient((BComplex)c, (Slot)prop)) {
                return 0;
            }
            if (WebProperty.isWebProperty(c, prop)) {
                return 2;
            }
            if (prop.isEquivalentToDefaultValue(propVal)) {
                return 0;
            }
            if (c instanceof BWidget && ((BWidget)c).isOverriddenByBinding(prop)) {
                return 0;
            }
        } else {
            if (Flags.isTransient((BComplex)c, (Slot)prop)) {
                return 0;
            }
            if (c instanceof BPxInclude) {
                BPxInclude px = (BPxInclude)c;
                if (propVal == px.root) {
                    return 0;
                }
            } else if (WebProperty.isWebProperty(c, prop)) {
                return 2;
            }
        }
        return prop.isFrozen() && !prop.getType().isAbstract() && propVal.isSimple() ? 1 : 2;
    }
}

