/*
 * Decompiled with CFR 0.152.
 */
package javax.baja.ui.list;

import com.tridium.ui.theme.Theme;
import javax.baja.gx.BBrush;
import javax.baja.gx.BFont;
import javax.baja.gx.BImage;
import javax.baja.gx.Graphics;
import javax.baja.ui.BWidget;
import javax.baja.ui.list.BList;

public class ListRenderer
extends BList.ListSupport {
    public BBrush getForeground(Item item) {
        BList list = this.getList();
        BWidget parent = list.getParentWidget();
        if (this.getList().isEnabled() && (parent == null || parent.isEnabled())) {
            return Theme.dropDown().getTextBrush(list);
        }
        return Theme.textEditor().getDisabledTextBrush(list);
    }

    public BBrush getBackground(Item item) {
        return null;
    }

    public BBrush getSelectionForeground(Item item) {
        return Theme.dropDown().getSelectionForeground(this.getList());
    }

    public BBrush getSelectionBackground(Item item) {
        return Theme.dropDown().getSelectionBackground(this.getList());
    }

    public double getItemHeight() {
        return Math.max(Theme.dropDown().getTextFont(this.getList()).getHeight() + 5.0, 18.0);
    }

    public double getPreferredItemWidth(Item item) {
        String s = this.getItemText(item);
        double w = Theme.table().getCellFont().width(s) + 12.0;
        if (item.icon != null) {
            w += 18.0;
        }
        return w;
    }

    public void paintItem(Graphics g, Item item) {
        this.paintItemBackground(g, item);
        double x = 4.0;
        if (item.icon != null) {
            g.drawImage(item.icon, x, (item.height - item.icon.getHeight()) / 2.0);
            x += 20.0;
        }
        String s = this.getItemText(item);
        BFont font = Theme.dropDown().getTextFont(this.list);
        double th = font.getHeight();
        double ta = font.getAscent();
        double ty = (item.height - th) / 2.0;
        g.setFont(font);
        g.drawString(s, x, ty + ta);
    }

    public String getItemText(Item item) {
        return String.valueOf(item.value);
    }

    protected void paintItemBackground(Graphics g, Item item) {
        if (item.selected) {
            BBrush bg = this.getSelectionBackground(item);
            if (bg != null) {
                g.setBrush(bg);
                g.fillRect(0.0, 0.0, item.width - 1.0, item.height - 1.0);
            }
            g.setBrush(this.getSelectionForeground(item));
        } else {
            BBrush bg = this.getBackground(item);
            if (bg != null) {
                g.setBrush(bg);
                g.fillRect(0.0, 0.0, item.width, item.height);
            }
            g.setBrush(this.getForeground(item));
        }
        g.setFont(Theme.table().getCellFont());
    }

    public static class Item {
        public int index;
        public BImage icon;
        public Object value;
        public double width;
        public double height;
        public boolean selected;
    }
}

