/*
 * Decompiled with CFR 0.152.
 */
package javax.baja.ui.commands;

import java.util.HashMap;
import javax.baja.sys.BComponent;
import javax.baja.sys.BIPropertyContainer;
import javax.baja.sys.BValue;
import javax.baja.sys.Property;
import javax.baja.sys.Slot;
import javax.baja.ui.BDialog;
import javax.baja.ui.BWidget;
import javax.baja.ui.Command;
import javax.baja.ui.CommandArtifact;
import javax.baja.ui.util.UiLexicon;
import javax.baja.util.BFormat;
import javax.baja.util.BNameMap;

public class SetDisplayNameCommand
extends Command {
    private static final UiLexicon lex = UiLexicon.bajaui();
    private BComponent myComponent;

    public SetDisplayNameCommand(BWidget owner, BComponent comp) {
        super(owner, UiLexicon.bajaui().module, "commands.setDisplayName");
        this.myComponent = comp;
    }

    @Override
    public CommandArtifact doInvoke() throws Exception {
        String newDisplayName;
        BComponent parent = (BComponent)this.myComponent.getParent();
        String initVal = "";
        BFormat currName = parent.getDisplayNameFormat(this.myComponent.getPropertyInParent());
        if (currName != null) {
            initVal = currName.getFormat();
        }
        if ((newDisplayName = SetDisplayNameCommand.promptForNewDisplayName(this.getOwner(), (BIPropertyContainer)parent, initVal)) == null) {
            return null;
        }
        DisplayNameArtifact artifact = new DisplayNameArtifact(parent, this.myComponent.getPropertyInParent(), BFormat.make((String)initVal), BFormat.make((String)newDisplayName));
        artifact.redo();
        return artifact;
    }

    public static String promptForNewDisplayName(BWidget owner, BIPropertyContainer parent, String oldDisplayName) {
        boolean done = false;
        String initVal = oldDisplayName;
        String newDisplayName = null;
        while (!done) {
            newDisplayName = BDialog.prompt(owner, lex.getText("commands.setDisplayName.prompt"), initVal, 20);
            if (newDisplayName == null) {
                return null;
            }
            if ((newDisplayName = newDisplayName.trim()).equals(oldDisplayName)) {
                return null;
            }
            if (SetDisplayNameCommand.isDuplicateDisplayName(newDisplayName, parent)) {
                int dialogResponse = BDialog.confirm(owner, lex.getText("commands.setDisplayName.duplicate.title"), lex.getText("commands.setDisplayName.duplicate.confirm"), 3);
                if (dialogResponse != 1) continue;
                done = true;
                continue;
            }
            done = true;
        }
        return newDisplayName;
    }

    private static boolean isDuplicateDisplayName(String newDisplayName, BIPropertyContainer parent) {
        boolean isDuplicate = false;
        HashMap map = new HashMap();
        BNameMap currNameMap = BNameMap.make(map);
        BValue x = parent.get("displayNames");
        if (x instanceof BNameMap) {
            currNameMap = (BNameMap)x;
        }
        Slot[] slots = parent.getSlotsArray();
        for (int i = 0; i < slots.length; ++i) {
            Slot slot = slots[i];
            String name = slot.getName();
            BFormat displayNameFormat = currNameMap.get(name);
            if (displayNameFormat != null) {
                if (!newDisplayName.equals(displayNameFormat.getFormat())) continue;
                isDuplicate = true;
                continue;
            }
            if (!newDisplayName.equals(slot.getDefaultDisplayName(null))) continue;
            isDuplicate = true;
        }
        return isDuplicate;
    }

    @Override
    protected Command doMerge(Command c) {
        return this;
    }

    public class DisplayNameArtifact
    implements CommandArtifact {
        private BComponent parent;
        private Property property;
        private BFormat oldValue;
        private BFormat newValue;

        public DisplayNameArtifact(BComponent parent, Property property, BFormat oldValue, BFormat newValue) {
            this.parent = parent;
            this.property = property;
            this.oldValue = oldValue;
            this.newValue = newValue;
        }

        @Override
        public void redo() {
            this.parent.setDisplayName(this.property, this.newValue, null);
        }

        @Override
        public void undo() {
            this.parent.setDisplayName(this.property, this.oldValue, null);
        }
    }
}

