/*
 * Decompiled with CFR 0.152.
 */
package javax.baja.ui;

import java.util.Stack;
import javax.baja.ui.BDialog;
import javax.baja.ui.BWidget;
import javax.baja.ui.Command;
import javax.baja.ui.CommandArtifact;
import javax.baja.ui.util.UiLexicon;

public class UndoManager {
    protected final BWidget owner;
    private UndoCommand undoCommand;
    private RedoCommand redoCommand;
    private Stack<CommandArtifact> undos = new Stack();
    private Stack<CommandArtifact> redos = new Stack();
    private int maxArtifacts = 10;

    public UndoManager(BWidget owner) {
        if (owner == null) {
            throw new NullPointerException("Null owner");
        }
        this.owner = owner;
        this.undoCommand = new UndoCommand(owner);
        this.redoCommand = new RedoCommand(owner);
    }

    public int getMaxArtifacts() {
        return this.maxArtifacts;
    }

    public synchronized void setMaxArtifacts(int maxArtifacts) {
        if (this.undos.size() > maxArtifacts) {
            while (this.undos.size() > maxArtifacts) {
                this.undos.remove(0);
            }
            this.redos.clear();
        }
        this.maxArtifacts = maxArtifacts;
    }

    public Command getUndoCommand() {
        return this.undoCommand;
    }

    public Command getRedoCommand() {
        return this.redoCommand;
    }

    public synchronized void undo() {
        if (this.undos.size() == 0) {
            return;
        }
        CommandArtifact artifact = this.undos.pop();
        this.redos.push(artifact);
        try {
            artifact.undo();
        }
        catch (Throwable e) {
            e.printStackTrace();
            String title = UiLexicon.bajaui().getText("dialog.error");
            String msg = UiLexicon.bajaui().getText("undo.error");
            BDialog.error(this.owner, title, (Object)msg, e);
        }
        this.checkCommandEnables();
    }

    public synchronized void redo() {
        if (this.redos.size() == 0) {
            return;
        }
        CommandArtifact artifact = this.redos.pop();
        this.undos.push(artifact);
        try {
            artifact.redo();
        }
        catch (Throwable e) {
            e.printStackTrace();
            String title = UiLexicon.bajaui().getText("dialog.error");
            String msg = UiLexicon.bajaui().getText("redo.error");
            BDialog.error(this.owner, title, (Object)msg, e);
        }
        this.checkCommandEnables();
    }

    public synchronized void addArtifact(CommandArtifact artifact) {
        if (this.undos.size() > this.maxArtifacts) {
            this.undos.remove(0);
        }
        this.undos.add(artifact);
        this.redos.clear();
        this.checkCommandEnables();
    }

    public synchronized void discardAllArtifacts() {
        this.undos.clear();
        this.redos.clear();
        this.checkCommandEnables();
    }

    private void checkCommandEnables() {
        this.undoCommand.setEnabled(this.undos.size() > 0);
        this.redoCommand.setEnabled(this.redos.size() > 0);
    }

    public static interface Scope {
        public UndoManager getInstalledUndoManager();

        public void setInstalledUndoManager(UndoManager var1);
    }

    class RedoCommand
    extends Command {
        RedoCommand(BWidget owner) {
            super(owner, UiLexicon.bajaui().module, "commands.redo");
            this.setEnabled(false);
        }

        @Override
        public CommandArtifact doInvoke() {
            UndoManager.this.redo();
            return null;
        }
    }

    class UndoCommand
    extends Command {
        UndoCommand(BWidget owner) {
            super(owner, UiLexicon.bajaui().module, "commands.undo");
            this.setEnabled(false);
        }

        @Override
        public CommandArtifact doInvoke() {
            UndoManager.this.undo();
            return null;
        }
    }
}

