/*
 * Decompiled with CFR 0.152.
 */
package javax.baja.ui;

import com.tridium.ui.theme.SpinnerButtonTheme;
import com.tridium.ui.theme.Theme;
import javax.baja.gx.BBrush;
import javax.baja.gx.Graphics;
import javax.baja.nre.annotations.Generated;
import javax.baja.nre.annotations.NiagaraAction;
import javax.baja.nre.annotations.NiagaraActions;
import javax.baja.nre.annotations.NiagaraTopic;
import javax.baja.nre.annotations.NiagaraTopics;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.sys.Action;
import javax.baja.sys.BValue;
import javax.baja.sys.Clock;
import javax.baja.sys.Slot;
import javax.baja.sys.Sys;
import javax.baja.sys.Topic;
import javax.baja.sys.Type;
import javax.baja.ui.BButton;
import javax.baja.ui.BWidget;
import javax.baja.ui.event.BMouseEvent;
import javax.baja.ui.event.BWidgetEvent;

@NiagaraType
@NiagaraActions(value={@NiagaraAction(name="handleUpMouseEvent", parameterType="BMouseEvent", defaultValue="new BMouseEvent()"), @NiagaraAction(name="handleDownMouseEvent", parameterType="BMouseEvent", defaultValue="new BMouseEvent()")})
@NiagaraTopics(value={@NiagaraTopic(name="increment", eventType="BWidgetEvent"), @NiagaraTopic(name="decrement", eventType="BWidgetEvent")})
public class BSpinnerButton
extends BWidget {
    @Generated
    public static final Action handleUpMouseEvent = BSpinnerButton.newAction((int)0, (BValue)new BMouseEvent(), null);
    @Generated
    public static final Action handleDownMouseEvent = BSpinnerButton.newAction((int)0, (BValue)new BMouseEvent(), null);
    @Generated
    public static final Topic increment = BSpinnerButton.newTopic((int)0, null);
    @Generated
    public static final Topic decrement = BSpinnerButton.newTopic((int)0, null);
    @Generated
    public static final Type TYPE = Sys.loadType(BSpinnerButton.class);
    BButton up = new BButton();
    BButton down;
    boolean mUpInside = false;
    boolean mUpPressed = false;
    boolean mDownInside = false;
    boolean mDownPressed = false;
    long lastDownPulse = 0L;
    long lastUpPulse = 0L;
    static final long MIN_PULSE_ELAPSED = 250L;

    @Generated
    public void handleUpMouseEvent(BMouseEvent parameter) {
        this.invoke(handleUpMouseEvent, (BValue)parameter, null);
    }

    @Generated
    public void handleDownMouseEvent(BMouseEvent parameter) {
        this.invoke(handleDownMouseEvent, (BValue)parameter, null);
    }

    @Generated
    public void fireIncrement(BWidgetEvent event) {
        this.fire(increment, (BValue)event, null);
    }

    @Generated
    public void fireDecrement(BWidgetEvent event) {
        this.fire(decrement, (BValue)event, null);
    }

    @Override
    @Generated
    public Type getType() {
        return TYPE;
    }

    public BSpinnerButton() {
        this.up.setFocusTraversable(false);
        this.add("up", (BValue)this.up);
        this.down = new BButton();
        this.down.setFocusTraversable(false);
        this.add("down", (BValue)this.down);
        this.linkTo(this.up, (Slot)BButton.mouseEvent, (Slot)handleUpMouseEvent);
        this.linkTo(this.down, (Slot)BButton.mouseEvent, (Slot)handleDownMouseEvent);
    }

    @Override
    public void setEnabled(boolean value) {
        super.setEnabled(value);
        this.up.setEnabled(value);
        this.down.setEnabled(value);
    }

    public void doHandleUpMouseEvent(BMouseEvent event) {
        switch (event.getId()) {
            case 504: {
                this.mUpInside = true;
                break;
            }
            case 505: {
                this.mUpInside = false;
                this.lastDownPulse = 0L;
                break;
            }
            case 501: {
                this.mUpPressed = true;
                break;
            }
            case 502: {
                this.mUpPressed = false;
                this.lastUpPulse = 0L;
                break;
            }
            case 510: {
                long now;
                if (!this.mUpInside || (now = Clock.ticks()) - this.lastUpPulse <= 250L) break;
                this.fireIncrement(event);
                this.lastUpPulse = now;
            }
        }
    }

    public void doHandleDownMouseEvent(BMouseEvent event) {
        switch (event.getId()) {
            case 504: {
                this.mDownInside = true;
                break;
            }
            case 505: {
                this.mDownInside = false;
                this.lastDownPulse = 0L;
                break;
            }
            case 501: {
                this.mDownPressed = true;
                break;
            }
            case 502: {
                this.mDownPressed = false;
                this.lastDownPulse = 0L;
                break;
            }
            case 510: {
                long now;
                if (!this.mDownInside || (now = Clock.ticks()) - this.lastDownPulse <= 250L) break;
                this.fireDecrement(event);
                this.lastDownPulse = now;
            }
        }
    }

    @Override
    public void paint(Graphics g) {
        SpinnerButtonTheme theme = Theme.spinner();
        double w = this.getWidth();
        double h = this.getHeight();
        g.setBrush(theme.getControlShadow(this));
        g.strokeLine(0.0, 0.0, w - 1.0, 0.0);
        g.strokeLine(0.0, 0.0, 0.0, h - 1.0);
        g.setBrush(theme.getControlHighlight(this));
        g.strokeLine(w - 1.0, 1.0, w - 1.0, h - 1.0);
        g.strokeLine(1.0, h - 1.0, w - 1.0, h - 1.0);
        this.paintChild(g, this.up);
        this.paintChild(g, this.down);
        BBrush fg = theme.getControlForeground(this);
        g.setBrush(fg);
        theme.paintArrows(g, this.up, this.down, this.mUpInside && this.mUpPressed, this.mDownInside && this.mDownPressed);
    }

    @Override
    public String getStyleSelector() {
        return "button spinner";
    }

    @Override
    public void computePreferredSize() {
        this.setPreferredSize(this.getWidth(), this.getHeight());
    }

    @Override
    public void doLayout(BWidget[] children) {
        double width = this.getWidth();
        double height = this.getHeight();
        if (Theme.spinner().isStacked()) {
            double buttonHeight = height / 2.0;
            double buttonWidth = width - 2.0;
            this.up.setBounds(1.0, 1.0, buttonWidth, buttonHeight);
            this.down.setBounds(1.0, buttonHeight, buttonWidth, buttonHeight);
        } else {
            double buttonHeight = height - 2.0;
            double buttonWidth = width / 2.0;
            this.up.setBounds(1.0, 1.0, buttonWidth, buttonHeight);
            this.down.setBounds(buttonWidth, 1.0, buttonWidth, buttonHeight);
        }
    }
}

