/*
 * Decompiled with CFR 0.152.
 */
package javax.baja.ui;

import com.tridium.ui.theme.ScrollBarTheme;
import com.tridium.ui.theme.Theme;
import java.util.Date;
import javax.baja.gx.Graphics;
import javax.baja.gx.RectGeom;
import javax.baja.nre.annotations.Generated;
import javax.baja.nre.annotations.NiagaraProperties;
import javax.baja.nre.annotations.NiagaraProperty;
import javax.baja.nre.annotations.NiagaraTopic;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.sys.BIcon;
import javax.baja.sys.BValue;
import javax.baja.sys.BasicContext;
import javax.baja.sys.Context;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Topic;
import javax.baja.sys.Type;
import javax.baja.ui.BWidget;
import javax.baja.ui.enums.BOrientation;
import javax.baja.ui.event.BMouseEvent;
import javax.baja.ui.event.BScrollEvent;

@NiagaraType
@NiagaraProperties(value={@NiagaraProperty(name="orientation", type="BOrientation", defaultValue="BOrientation.vertical"), @NiagaraProperty(name="min", type="int", defaultValue="0"), @NiagaraProperty(name="max", type="int", defaultValue="100"), @NiagaraProperty(name="position", type="int", defaultValue="0"), @NiagaraProperty(name="extent", type="int", defaultValue="10"), @NiagaraProperty(name="unitIncrement", type="int", defaultValue="1"), @NiagaraProperty(name="blockIncrement", type="int", defaultValue="10"), @NiagaraProperty(name="snapToUnitIncrement", type="boolean", defaultValue="true")})
@NiagaraTopic(name="positionChanged", eventType="BScrollEvent")
public class BScrollBar
extends BWidget {
    @Generated
    public static final Property orientation = BScrollBar.newProperty((int)0, (BValue)BOrientation.vertical, null);
    @Generated
    public static final Property min = BScrollBar.newProperty((int)0, (int)0, null);
    @Generated
    public static final Property max = BScrollBar.newProperty((int)0, (int)100, null);
    @Generated
    public static final Property position = BScrollBar.newProperty((int)0, (int)0, null);
    @Generated
    public static final Property extent = BScrollBar.newProperty((int)0, (int)10, null);
    @Generated
    public static final Property unitIncrement = BScrollBar.newProperty((int)0, (int)1, null);
    @Generated
    public static final Property blockIncrement = BScrollBar.newProperty((int)0, (int)10, null);
    @Generated
    public static final Property snapToUnitIncrement = BScrollBar.newProperty((int)0, (boolean)true, null);
    @Generated
    public static final Topic positionChanged = BScrollBar.newTopic((int)0, null);
    @Generated
    public static final Type TYPE = Sys.loadType(BScrollBar.class);
    private static final BIcon icon = BIcon.std((String)"widgets/scrollBar.png");
    private static final int SIZE = 13;
    private static final int UP = 0;
    private static final int DOWN = 1;
    private static final int LEFT = 2;
    private static final int RIGHT = 3;
    private static Context resetContext = new BasicContext();
    private static final int minThumbSize = 7;
    private RectGeom up = new RectGeom();
    private RectGeom down = new RectGeom();
    private RectGeom thumb = new RectGeom();
    private RectGeom track = new RectGeom();
    private double thumbGrab;
    private RectGeom inside;
    private RectGeom armed;
    private double thumbPosition;
    private double thumbPadding;
    private long lastScrollTimestamp;
    private long scrollStartPosition;
    private double accumulatedScroll;

    @Generated
    public BOrientation getOrientation() {
        return (BOrientation)this.get(orientation);
    }

    @Generated
    public void setOrientation(BOrientation v) {
        this.set(orientation, (BValue)v, null);
    }

    @Generated
    public int getMin() {
        return this.getInt(min);
    }

    @Generated
    public void setMin(int v) {
        this.setInt(min, v, null);
    }

    @Generated
    public int getMax() {
        return this.getInt(max);
    }

    @Generated
    public void setMax(int v) {
        this.setInt(max, v, null);
    }

    @Generated
    public int getPosition() {
        return this.getInt(position);
    }

    @Generated
    public void setPosition(int v) {
        this.setInt(position, v, null);
    }

    @Generated
    public int getExtent() {
        return this.getInt(extent);
    }

    @Generated
    public void setExtent(int v) {
        this.setInt(extent, v, null);
    }

    @Generated
    public int getUnitIncrement() {
        return this.getInt(unitIncrement);
    }

    @Generated
    public void setUnitIncrement(int v) {
        this.setInt(unitIncrement, v, null);
    }

    @Generated
    public int getBlockIncrement() {
        return this.getInt(blockIncrement);
    }

    @Generated
    public void setBlockIncrement(int v) {
        this.setInt(blockIncrement, v, null);
    }

    @Generated
    public boolean getSnapToUnitIncrement() {
        return this.getBoolean(snapToUnitIncrement);
    }

    @Generated
    public void setSnapToUnitIncrement(boolean v) {
        this.setBoolean(snapToUnitIncrement, v, null);
    }

    @Generated
    public void firePositionChanged(BScrollEvent event) {
        this.fire(positionChanged, (BValue)event, null);
    }

    @Override
    @Generated
    public Type getType() {
        return TYPE;
    }

    public BScrollBar(BOrientation o, int unitIncrement, int blockIncrement, boolean snapToUnit) {
        this.setOrientation(o);
        this.setUnitIncrement(unitIncrement);
        this.setBlockIncrement(blockIncrement);
        this.setSnapToUnitIncrement(snapToUnit);
    }

    public BScrollBar(BOrientation o) {
        this.setOrientation(o);
    }

    public BScrollBar() {
    }

    @Override
    public void changed(Property prop, Context context) {
        super.changed(prop, context);
        if (context == resetContext) {
            return;
        }
        if (prop == orientation) {
            this.relayout();
        } else {
            this.resetPosition(this.getPosition(), 602);
        }
    }

    public double getThumbPosition() {
        return this.thumbPosition;
    }

    public void resetPosition(double thumbPosition, int adjustment) {
        double bottom;
        double min = this.getMin();
        double max = this.getMax();
        double range = Math.max(max, min);
        double extent = this.getExtent();
        if (extent > range) {
            extent = range;
        }
        if (thumbPosition > (bottom = max - extent)) {
            thumbPosition = bottom;
        }
        if (thumbPosition < min) {
            thumbPosition = min;
        }
        this.thumbPosition = thumbPosition;
        double pos = thumbPosition;
        if (this.getSnapToUnitIncrement()) {
            double inc = this.getUnitIncrement();
            double rem = Math.IEEEremainder(pos, inc);
            double lo = pos - rem;
            double hi = lo + inc;
            if (rem != 0.0) {
                double half = inc / 2.0;
                pos = rem > half ? hi : lo;
            }
            if (pos > bottom) {
                pos = bottom;
            }
            if (pos < min) {
                pos = min;
            }
        }
        this.layoutThumb();
        if ((double)this.getPosition() != pos) {
            this.setInt(position, (int)pos, resetContext);
            this.firePositionChanged(new BScrollEvent(601, this, (int)pos, adjustment));
        }
        this.repaint();
    }

    public void decrementByUnit() {
        this.scrollByUnits(-1.0);
    }

    public void incrementByUnit() {
        this.scrollByUnits(1.0);
    }

    public void scrollByUnits(double units) {
        this.scrollByPixels(units * (double)this.getUnitIncrement(), 1);
    }

    private void scrollByPixels(double px, int adjustment) {
        long now = new Date().getTime();
        if (now - this.lastScrollTimestamp <= 100L) {
            this.accumulatedScroll += px;
        } else {
            this.scrollStartPosition = this.getPosition();
            this.accumulatedScroll = px;
        }
        this.accumulatedScroll = Math.max(this.accumulatedScroll, (double)((long)this.getMin() - this.scrollStartPosition));
        this.accumulatedScroll = Math.min(this.accumulatedScroll, (double)((long)(this.getMax() - this.getExtent()) - this.scrollStartPosition));
        double pos = (double)this.scrollStartPosition + this.accumulatedScroll;
        this.lastScrollTimestamp = now;
        this.resetPosition(pos, adjustment);
    }

    public void decrementByBlock() {
        this.scrollByPixels(-this.getBlockIncrement(), 3);
    }

    public void incrementByBlock() {
        this.scrollByPixels(this.getBlockIncrement(), 4);
    }

    @Override
    public void computePreferredSize() {
        double size = Theme.scrollBar().getFixedWidth();
        if (this.getOrientation() == BOrientation.horizontal) {
            this.setPreferredSize(100.0, size);
        } else {
            this.setPreferredSize(size, 100.0);
        }
    }

    @Override
    public void doLayout(BWidget[] children) {
        if (this.getOrientation() == BOrientation.horizontal) {
            this.layoutHorizontal();
        } else {
            this.layoutVertical();
        }
    }

    private void layoutHorizontal() {
        double size = Theme.scrollBar().getFixedWidth();
        double w = this.getWidth();
        double buttonWidth = size;
        if (w < size * 2.0) {
            buttonWidth = w / 2.0;
        }
        this.up.x = 0.0;
        this.up.y = 0.0;
        this.up.width = buttonWidth;
        this.up.height = size;
        this.down.x = w - buttonWidth;
        this.down.y = 0.0;
        this.down.width = buttonWidth;
        this.down.height = size;
        this.track.x = buttonWidth;
        this.track.y = 0.0;
        this.track.width = w - buttonWidth * 2.0;
        this.track.height = size;
        this.layoutThumb();
    }

    private void layoutVertical() {
        double size = Theme.scrollBar().getFixedWidth();
        double h = this.getHeight();
        double buttonHeight = size;
        if (h < size * 2.0) {
            buttonHeight = h / 2.0;
        }
        this.up.x = 0.0;
        this.up.y = 0.0;
        this.up.width = size;
        this.up.height = buttonHeight;
        this.down.x = 0.0;
        this.down.y = h - buttonHeight;
        this.down.width = size;
        this.down.height = buttonHeight;
        this.track.x = 0.0;
        this.track.y = buttonHeight;
        this.track.width = size;
        this.track.height = h - buttonHeight * 2.0;
        this.layoutThumb();
    }

    private void layoutThumb() {
        double pos = this.thumbPosition;
        double size = Theme.scrollBar().getFixedWidth();
        double trackLength = this.getOrientation() == BOrientation.horizontal ? (double)((int)this.track.width) : (double)((int)this.track.height);
        double min = this.getMin();
        double max = this.getMax();
        double range = Math.abs(max - min);
        double extent = this.getExtent();
        if (extent > range) {
            extent = range;
        }
        if (trackLength < size) {
            this.thumb.width = 0.0;
            this.thumb.height = 0.0;
            return;
        }
        double len = (int)(trackLength * extent / range) + 1;
        this.thumbPadding = 0.0;
        if (len < 7.0) {
            this.thumbPadding = 7.0 - len;
            len = 7.0;
        }
        double offset = (int)((trackLength - this.thumbPadding) * (pos - min) / range);
        if (this.getOrientation() == BOrientation.horizontal) {
            this.thumb.x = this.track.x + offset;
            this.thumb.y = 0.0;
            this.thumb.width = len;
            this.thumb.height = size;
        } else {
            this.thumb.x = 0.0;
            this.thumb.y = this.track.y + offset;
            this.thumb.width = size;
            this.thumb.height = len;
        }
    }

    private void dragThumb(double mx, double my) {
        double offset;
        double trackLength;
        boolean maxed = false;
        if (this.getOrientation() == BOrientation.horizontal) {
            trackLength = this.track.width;
            offset = mx - this.track.x - this.thumbGrab;
            if (trackLength <= offset + this.thumb.width) {
                offset = trackLength - this.thumb.width;
                maxed = true;
            }
        } else {
            trackLength = this.track.height;
            offset = my - this.track.y - this.thumbGrab;
            if (trackLength <= offset + this.thumb.height) {
                offset = trackLength - this.thumb.height;
                maxed = true;
            }
        }
        if (maxed) {
            this.resetPosition(this.getMax() - this.getExtent(), 5);
        } else {
            double min = this.getMin();
            double max = this.getMax();
            double range = Math.abs(max - min);
            double extent = this.getExtent();
            double pos = min + range / (trackLength - this.thumbPadding) * offset;
            if (pos < min) {
                pos = min;
            }
            if (pos > max - extent) {
                pos = max - extent;
            }
            this.resetPosition(pos, 5);
        }
    }

    @Override
    public void paint(Graphics g) {
        ScrollBarTheme theme = Theme.scrollBar();
        if (this.getOrientation() == BOrientation.horizontal) {
            theme.paintButton(g, this, this.up, 2, this.up == this.inside && this.up == this.armed);
            theme.paintButton(g, this, this.down, 3, this.down == this.inside && this.down == this.armed);
        } else {
            theme.paintButton(g, this, this.up, 0, this.up == this.inside && this.up == this.armed);
            theme.paintButton(g, this, this.down, 1, this.down == this.inside && this.down == this.armed);
        }
        theme.paintTrack(g, this, this.track);
        theme.paintThumb(g, this, this.thumb);
    }

    @Override
    public String getStyleSelector() {
        return "scroll-bar";
    }

    @Override
    public void mouseReleased(BMouseEvent event) {
        this.armed = null;
        this.thumbGrab = -1.0;
        this.layoutThumb();
        this.repaint();
    }

    @Override
    public void mousePressed(BMouseEvent event) {
        this.armed = this.buttonAt(event);
        if (this.armed == this.thumb) {
            this.thumbGrab = this.getOrientation() == BOrientation.horizontal ? (double)((int)(event.getX() - this.thumb.x)) : (double)((int)(event.getY() - this.thumb.y));
            this.repaint();
        }
    }

    @Override
    public void mouseExited(BMouseEvent event) {
        this.inside = this.buttonAt(event);
        this.repaint();
    }

    @Override
    public void mouseEntered(BMouseEvent event) {
        this.inside = this.buttonAt(event);
        this.repaint();
    }

    @Override
    public void mouseMoved(BMouseEvent event) {
        RectGeom oldInside = this.inside;
        this.inside = this.buttonAt(event);
        if (oldInside != this.inside) {
            this.repaint();
        }
    }

    @Override
    public void mouseDragged(BMouseEvent event) {
        RectGeom oldInside = this.inside;
        this.inside = this.buttonAt(event);
        if (this.armed == this.thumb) {
            this.dragThumb(event.getX(), event.getY());
        } else if (oldInside != this.inside) {
            this.repaint();
        }
    }

    @Override
    public void mousePulsed(BMouseEvent event) {
        double y;
        if (this.armed == this.up && this.inside == this.up) {
            this.decrementByUnit();
            return;
        }
        if (this.armed == this.down && this.inside == this.down) {
            this.incrementByUnit();
            return;
        }
        double x = event.getX();
        if (this.track.contains(x, y = event.getY()) && !this.thumb.contains(x, y) && this.thumb.width > 0.0) {
            if (this.getOrientation() == BOrientation.horizontal) {
                if (x < this.thumb.x) {
                    this.decrementByBlock();
                } else if (x > this.thumb.x + this.thumb.width) {
                    this.incrementByBlock();
                }
            } else if (y < this.thumb.y) {
                this.decrementByBlock();
            } else if (y > this.thumb.y + this.thumb.height) {
                this.incrementByBlock();
            }
        }
    }

    private RectGeom buttonAt(BMouseEvent event) {
        double y;
        double x = event.getX();
        if (this.up.contains(x, y = event.getY())) {
            return this.up;
        }
        if (this.down.contains(x, y)) {
            return this.down;
        }
        if (this.thumb.contains(x, y)) {
            return this.thumb;
        }
        return null;
    }

    @Override
    public BIcon getIcon() {
        return icon;
    }
}

