/*
 * Decompiled with CFR 0.152.
 */
package javax.baja.ui;

import com.tridium.gx.ImagePeer;
import com.tridium.ui.util.ScaledLayout;
import java.lang.reflect.Constructor;
import java.util.Optional;
import java.util.logging.Logger;
import javax.baja.gx.BImage;
import javax.baja.gx.BSize;
import javax.baja.gx.BTransform;
import javax.baja.gx.Graphics;
import javax.baja.naming.BOrdList;
import javax.baja.nre.annotations.Generated;
import javax.baja.nre.annotations.NiagaraProperties;
import javax.baja.nre.annotations.NiagaraProperty;
import javax.baja.nre.annotations.NiagaraTopic;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.sys.BIcon;
import javax.baja.sys.BValue;
import javax.baja.sys.Context;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Topic;
import javax.baja.sys.Type;
import javax.baja.ui.BWidget;
import javax.baja.ui.enums.BHalign;
import javax.baja.ui.enums.BScaleMode;
import javax.baja.ui.enums.BValign;
import javax.baja.ui.event.BMouseEvent;
import javax.baja.ui.event.BWidgetEvent;

@NiagaraType
@NiagaraProperties(value={@NiagaraProperty(name="image", type="BImage", defaultValue="BImage.NULL"), @NiagaraProperty(name="scale", type="BScaleMode", defaultValue="BScaleMode.none"), @NiagaraProperty(name="halign", type="BHalign", defaultValue="BHalign.center"), @NiagaraProperty(name="valign", type="BValign", defaultValue="BValign.center"), @NiagaraProperty(name="animate", type="boolean", defaultValue="true")})
@NiagaraTopic(name="actionPerformed", eventType="BWidgetEvent")
public class BPicture
extends BWidget {
    @Generated
    public static final Property image = BPicture.newProperty((int)0, (BValue)BImage.NULL, null);
    @Generated
    public static final Property scale = BPicture.newProperty((int)0, (BValue)BScaleMode.none, null);
    @Generated
    public static final Property halign = BPicture.newProperty((int)0, (BValue)BHalign.center, null);
    @Generated
    public static final Property valign = BPicture.newProperty((int)0, (BValue)BValign.center, null);
    @Generated
    public static final Property animate = BPicture.newProperty((int)0, (boolean)true, null);
    @Generated
    public static final Topic actionPerformed = BPicture.newTopic((int)0, null);
    @Generated
    public static final Type TYPE = Sys.loadType(BPicture.class);
    private static final BIcon icon = BIcon.std((String)"widgets/image.png");
    static final Logger LOG = Logger.getLogger("bajaui");
    BTransform.Scale transScale;
    protected double dx;
    protected double dy;
    private boolean imageWasScaled;
    private BOrdList lastImageOrdList;
    protected final Optional<IPictureImpl> impl;

    @Generated
    public BImage getImage() {
        return (BImage)this.get(image);
    }

    @Generated
    public void setImage(BImage v) {
        this.set(image, (BValue)v, null);
    }

    @Generated
    public BScaleMode getScale() {
        return (BScaleMode)this.get(scale);
    }

    @Generated
    public void setScale(BScaleMode v) {
        this.set(scale, (BValue)v, null);
    }

    @Generated
    public BHalign getHalign() {
        return (BHalign)this.get(halign);
    }

    @Generated
    public void setHalign(BHalign v) {
        this.set(halign, (BValue)v, null);
    }

    @Generated
    public BValign getValign() {
        return (BValign)this.get(valign);
    }

    @Generated
    public void setValign(BValign v) {
        this.set(valign, (BValue)v, null);
    }

    @Generated
    public boolean getAnimate() {
        return this.getBoolean(animate);
    }

    @Generated
    public void setAnimate(boolean v) {
        this.setBoolean(animate, v, null);
    }

    @Generated
    public void fireActionPerformed(BWidgetEvent event) {
        this.fire(actionPerformed, (BValue)event, null);
    }

    @Override
    @Generated
    public Type getType() {
        return TYPE;
    }

    public BPicture() {
        Optional<Object> im;
        try {
            Class<?> awtComponentClass = Class.forName("java.awt.Component");
            Constructor<?> ctor = Class.forName("javax.baja.ui.AwtPictureImpl").getConstructor(BPicture.class);
            im = Optional.of((IPictureImpl)ctor.newInstance(this));
        }
        catch (Throwable e) {
            im = Optional.empty();
        }
        this.impl = im;
    }

    @Override
    public void changed(Property prop, Context context) {
        this.impl.ifPresent(IPictureImpl::resetPeer);
        this.relayout();
        super.changed(prop, context);
    }

    @Override
    public void paint(Graphics g) {
        this.wipePreviousPeer();
        BImage image = this.getImage();
        if (image.isNull() || !this.impl.isPresent() || !this.impl.get().ensurePeer().isDimensionsLoaded() || !this.isImageReadyToScale()) {
            return;
        }
        if (!this.impl.get().paint(g)) {
            LOG.warning("cannot render " + image + " to graphics context " + g.getClass().getName());
        }
    }

    @Override
    public void computePreferredSize() {
        BImage image = this.getImage();
        if (image.isNull() || !image.isDimensionsLoaded()) {
            this.setPreferredSize(0.0, 0.0);
        } else {
            this.setPreferredSize(image.getWidth(), image.getHeight());
        }
    }

    @Override
    public void doLayout(BWidget[] kids) {
        if (!this.wipePreviousPeer()) {
            BPicture.doScaleLayout(this);
        }
        this.impl.ifPresent(IPictureImpl::ensurePeer);
    }

    @Override
    public void animate() {
        if (!this.getAnimate()) {
            return;
        }
        BImage image = this.getImage();
        if (image.isNull() || !this.impl.isPresent() || !this.impl.get().ensurePeer().isLoaded()) {
            return;
        }
        if (this.impl.get().ensurePeer().animate()) {
            this.impl.get().resetPeer();
            this.repaint();
        }
    }

    @Override
    public void mousePressed(BMouseEvent event) {
        this.fireActionPerformed(event);
    }

    private boolean wipePreviousPeer() {
        BImage image = this.getImage();
        boolean wipePeer = false;
        if (this.lastImageOrdList != null && !this.lastImageOrdList.equals((Object)image.getOrdList())) {
            wipePeer = true;
        }
        this.lastImageOrdList = image.getOrdList();
        if (!this.imageWasScaled && this.isImageReadyToScale()) {
            wipePeer = true;
        }
        if (wipePeer) {
            this.impl.ifPresent(IPictureImpl::resetPeer);
        }
        return wipePeer;
    }

    public boolean isImageReadyToScale() {
        BImage image = this.getImage();
        return !image.isNull() && image.isLoaded() && this.getWidth() > 0.0 && this.getHeight() > 0.0;
    }

    static void doScaleLayout(BPicture pic) {
        BImage image = pic.getImage();
        pic.imageWasScaled = pic.isImageReadyToScale();
        if (!pic.imageWasScaled) {
            pic.dx = 0.0;
            pic.dy = 0.0;
            pic.transScale = null;
        } else {
            BSize inner = BSize.make((double)image.getWidth(), (double)image.getHeight());
            BSize outer = BSize.make((double)pic.getWidth(), (double)pic.getHeight());
            ScaledLayout scaledLayout = ScaledLayout.scale(inner, outer, pic.getHalign(), pic.getValign(), pic.getScale());
            pic.dx = scaledLayout.getOffsetX();
            pic.dy = scaledLayout.getOffsetY();
            pic.transScale = scaledLayout.getScale();
        }
    }

    @Override
    public BIcon getIcon() {
        return icon;
    }

    public static interface IPictureImpl {
        public void resetPeer();

        public ImagePeer ensurePeer();

        public boolean paint(Graphics var1);
    }
}

