/*
 * Decompiled with CFR 0.152.
 */
package javax.baja.ui;

import com.tridium.ui.theme.LabelTheme;
import com.tridium.ui.theme.Theme;
import java.util.ArrayList;
import java.util.StringTokenizer;
import javax.baja.gx.BBrush;
import javax.baja.gx.BFont;
import javax.baja.gx.BImage;
import javax.baja.gx.BInsets;
import javax.baja.gx.Graphics;
import javax.baja.gx.Point;
import javax.baja.gx.RectGeom;
import javax.baja.nre.annotations.Generated;
import javax.baja.nre.annotations.NiagaraProperties;
import javax.baja.nre.annotations.NiagaraProperty;
import javax.baja.nre.annotations.NiagaraTopic;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.sys.BIcon;
import javax.baja.sys.BString;
import javax.baja.sys.BValue;
import javax.baja.sys.Context;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Topic;
import javax.baja.sys.Type;
import javax.baja.ui.BAbstractButton;
import javax.baja.ui.BWidget;
import javax.baja.ui.enums.BAlign;
import javax.baja.ui.enums.BHalign;
import javax.baja.ui.enums.BValign;
import javax.baja.ui.event.BMouseEvent;
import javax.baja.ui.event.BWidgetEvent;

@NiagaraType
@NiagaraProperties(value={@NiagaraProperty(name="text", type="String", defaultValue="BString.DEFAULT"), @NiagaraProperty(name="image", type="BImage", defaultValue="BImage.NULL"), @NiagaraProperty(name="font", type="BFont", defaultValue="BFont.NULL"), @NiagaraProperty(name="foreground", type="BBrush", defaultValue="BBrush.NULL"), @NiagaraProperty(name="background", type="BBrush", defaultValue="BBrush.NULL"), @NiagaraProperty(name="halign", type="BHalign", defaultValue="BHalign.center"), @NiagaraProperty(name="valign", type="BValign", defaultValue="BValign.center"), @NiagaraProperty(name="textToIconAlign", type="BAlign", defaultValue="BAlign.right"), @NiagaraProperty(name="textIconGap", type="double", defaultValue="4"), @NiagaraProperty(name="blink", type="boolean", defaultValue="false"), @NiagaraProperty(name="wordWrapEnabled", type="boolean", defaultValue="false")})
@NiagaraTopic(name="actionPerformed", eventType="BWidgetEvent")
public class BLabel
extends BWidget {
    @Generated
    public static final Property text = BLabel.newProperty((int)0, (BValue)BString.DEFAULT, null);
    @Generated
    public static final Property image = BLabel.newProperty((int)0, (BValue)BImage.NULL, null);
    @Generated
    public static final Property font = BLabel.newProperty((int)0, (BValue)BFont.NULL, null);
    @Generated
    public static final Property foreground = BLabel.newProperty((int)0, (BValue)BBrush.NULL, null);
    @Generated
    public static final Property background = BLabel.newProperty((int)0, (BValue)BBrush.NULL, null);
    @Generated
    public static final Property halign = BLabel.newProperty((int)0, (BValue)BHalign.center, null);
    @Generated
    public static final Property valign = BLabel.newProperty((int)0, (BValue)BValign.center, null);
    @Generated
    public static final Property textToIconAlign = BLabel.newProperty((int)0, (BValue)BAlign.right, null);
    @Generated
    public static final Property textIconGap = BLabel.newProperty((int)0, (int)4, null);
    @Generated
    public static final Property blink = BLabel.newProperty((int)0, (boolean)false, null);
    @Generated
    public static final Property wordWrapEnabled = BLabel.newProperty((int)0, (boolean)false, null);
    @Generated
    public static final Topic actionPerformed = BLabel.newTopic((int)0, null);
    @Generated
    public static final Type TYPE = Sys.loadType(BLabel.class);
    private static final BIcon icon = BIcon.std((String)"widgets/label.png");
    private static final BIcon imageIcon = BIcon.std((String)"widgets/image.png");
    BInsets padding = BInsets.NULL;
    Layout layout = this.createLayout();
    boolean forceLayout;
    int blinkFrame = 2;
    private static final double METRIC_MULTIPLIER = 100.0;

    @Generated
    public String getText() {
        return this.getString(text);
    }

    @Generated
    public void setText(String v) {
        this.setString(text, v, null);
    }

    @Generated
    public BImage getImage() {
        return (BImage)this.get(image);
    }

    @Generated
    public void setImage(BImage v) {
        this.set(image, (BValue)v, null);
    }

    @Generated
    public BFont getFont() {
        return (BFont)this.get(font);
    }

    @Generated
    public void setFont(BFont v) {
        this.set(font, (BValue)v, null);
    }

    @Generated
    public BBrush getForeground() {
        return (BBrush)this.get(foreground);
    }

    @Generated
    public void setForeground(BBrush v) {
        this.set(foreground, (BValue)v, null);
    }

    @Generated
    public BBrush getBackground() {
        return (BBrush)this.get(background);
    }

    @Generated
    public void setBackground(BBrush v) {
        this.set(background, (BValue)v, null);
    }

    @Generated
    public BHalign getHalign() {
        return (BHalign)this.get(halign);
    }

    @Generated
    public void setHalign(BHalign v) {
        this.set(halign, (BValue)v, null);
    }

    @Generated
    public BValign getValign() {
        return (BValign)this.get(valign);
    }

    @Generated
    public void setValign(BValign v) {
        this.set(valign, (BValue)v, null);
    }

    @Generated
    public BAlign getTextToIconAlign() {
        return (BAlign)this.get(textToIconAlign);
    }

    @Generated
    public void setTextToIconAlign(BAlign v) {
        this.set(textToIconAlign, (BValue)v, null);
    }

    @Generated
    public double getTextIconGap() {
        return this.getDouble(textIconGap);
    }

    @Generated
    public void setTextIconGap(double v) {
        this.setDouble(textIconGap, v, null);
    }

    @Generated
    public boolean getBlink() {
        return this.getBoolean(blink);
    }

    @Generated
    public void setBlink(boolean v) {
        this.setBoolean(blink, v, null);
    }

    @Generated
    public boolean getWordWrapEnabled() {
        return this.getBoolean(wordWrapEnabled);
    }

    @Generated
    public void setWordWrapEnabled(boolean v) {
        this.setBoolean(wordWrapEnabled, v, null);
    }

    @Generated
    public void fireActionPerformed(BWidgetEvent event) {
        this.fire(actionPerformed, (BValue)event, null);
    }

    @Override
    @Generated
    public Type getType() {
        return TYPE;
    }

    public BLabel(BImage image, String text) {
        this(text, image, null, null, null);
    }

    public BLabel(String text) {
        this(text, null, null, null, null);
    }

    public BLabel(BImage image) {
        this(null, image, null, null, null);
    }

    public BLabel(String text, BHalign hAlign) {
        this(text, null, null, hAlign, null);
    }

    public BLabel(String text, BValign vAlign) {
        this(text, null, null, null, vAlign);
    }

    public BLabel(String text, BFont font) {
        this(text, null, font, null, null);
    }

    public BLabel(BImage image, String text, BFont font) {
        this(text, image, font, null, null);
    }

    public BLabel(BImage image, BHalign hAlign) {
        this(null, image, null, hAlign, null);
    }

    public BLabel(BImage image, BValign vAlign) {
        this(null, image, null, null, vAlign);
    }

    public BLabel(String text, BFont font, BHalign hAlign) {
        this(text, null, font, hAlign, null);
    }

    private BLabel(String text, BImage image, BFont font, BHalign hAlign, BValign vAlign) {
        if (text != null) {
            this.setText(text);
        }
        if (image != null) {
            this.setImage(image);
        }
        if (font != null) {
            this.setFont(font);
        }
        if (hAlign != null) {
            this.setHalign(hAlign);
        }
        if (vAlign != null) {
            this.setValign(vAlign);
        }
    }

    public BLabel() {
    }

    public void setWordWrapEnabled(boolean enabled, double maxWidth) {
        this.setWordWrapEnabled(enabled);
        this.setSize(maxWidth, this.getHeight());
    }

    @Override
    public void computePreferredSize() {
        Layout temp = this.createLayout();
        temp.computeBounds();
        BInsets padding = this.getPadding();
        temp.aw += padding.left + padding.right;
        temp.ah += padding.top + padding.bottom;
        this.setPreferredSize(temp.aw, temp.ah);
    }

    @Override
    public void doLayout(BWidget[] kids) {
        this.forceLayout = false;
        double w = this.getWidth();
        double h = this.getHeight();
        BInsets padding = this.getPadding();
        this.layout.lines = null;
        this.layout.computeBounds();
        this.layout.computeAlignment(w -= padding.left + padding.right, h -= padding.top + padding.bottom);
        this.layout.xo += padding.left;
        this.layout.yo += padding.top;
    }

    @Override
    public void changed(Property prop, Context context) {
        if (prop.equals(text)) {
            this.forceLayout = true;
            this.relayout();
        } else if (prop.equals(styleClasses)) {
            this.setImage(Theme.label().getIcon(this));
        }
        super.changed(prop, context);
    }

    public BInsets getPadding() {
        return this.padding;
    }

    public void setPadding(BInsets padding) {
        this.padding = padding;
    }

    public Layout getLabelLayout() {
        return this.layout;
    }

    @Override
    public void paint(Graphics g) {
        String text;
        if (this.getBlink() && this.blinkFrame <= 1) {
            return;
        }
        if (this.forceLayout) {
            this.forceLayout = false;
            this.relayoutSync();
        }
        LabelTheme theme = this.theme();
        Layout q = this.layout;
        double tx = q.tx;
        double ty = q.ty;
        double tw = q.tw;
        double th = q.th;
        double ix = q.ix;
        double iy = q.iy;
        double xo = q.xo;
        double yo = q.yo;
        BFont font = this.getFont();
        if (font.isNull()) {
            font = this.theme().getTextFont(this);
        }
        BBrush background = this.getBackground();
        this.paintBackground(g, background);
        BImage image = theme.getIcon(this);
        if (this.layout.ipaint && !image.isNull()) {
            if (!this.isEnabled()) {
                image = image.getDisabledImage();
            }
            this.paintIcon(g, image, ix + xo, iy + yo);
        }
        if ((text = this.getText()).length() > 0 && q.lines != null) {
            BBrush brush = this.getForeground();
            if (brush.isNull()) {
                brush = theme.getTextBrush(this);
            }
            g.setBrush(brush);
            g.setFont(font);
            BHalign ha = this.getHalign();
            for (int i = 0; i < q.lines.length; ++i) {
                double ax = 0.0;
                if (ha == BHalign.center) {
                    ax = (tw - q.widths[i]) / 2.0;
                } else if (ha == BHalign.right) {
                    ax = tw - q.widths[i];
                }
                if (this.isEnabled()) {
                    this.paintText(g, q.lines[i], tx + xo + ax, ty + yo + (double)i * q.lineHeight);
                    continue;
                }
                theme.paintDisabledText(g, this, q.lines[i], tx + xo + ax, ty + yo + (double)i * q.lineHeight);
            }
        }
    }

    protected void paintIcon(Graphics g, BImage image, double x, double y) {
        g.drawImage(image, x, y);
    }

    protected void paintBackground(Graphics g, BBrush background) {
        if (!background.isNull() && !(this instanceof BAbstractButton)) {
            g.setBrush(background);
            g.fillRect(0.0, 0.0, this.getWidth(), this.getHeight());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void paintText(Graphics g, String text, double tx, double ty) {
        g.push();
        try {
            g.useFractionalFontMetrics(true);
            g.drawString(text, tx, ty);
        }
        finally {
            g.pop();
        }
    }

    @Override
    public void animate() {
        BImage image = this.getImage();
        if (!image.isNull()) {
            if (!this.layout.iloaded && image.isLoaded()) {
                this.layout.iloaded = true;
                image.syncDimensions();
                this.relayout();
            }
            if (image.animate()) {
                this.repaint();
            }
        }
        if (this.getBlink()) {
            this.blinkFrame = (this.blinkFrame + 1) % 8;
            if (this.blinkFrame == 0 || this.blinkFrame == 2) {
                this.repaint();
            }
        }
    }

    @Override
    public String getStyleSelector() {
        return "label";
    }

    @Override
    public void mousePressed(BMouseEvent event) {
        this.fireActionPerformed(event);
    }

    LabelTheme theme() {
        return Theme.label();
    }

    @Override
    public BIcon getIcon() {
        return this.getImage().isNull() ? icon : imageIcon;
    }

    @Override
    public boolean receiveInputEvents() {
        return this.hasBindings();
    }

    @Override
    public String getDebugString() {
        return "\"" + this.getText() + "\"; ";
    }

    protected Layout createLayout() {
        return new Layout();
    }

    public class Layout {
        BFont layoutFont = BFont.DEFAULT;
        boolean valid;
        double tx;
        double ty;
        double tw;
        double th;
        double ix;
        double iy;
        double iw;
        double ih;
        double aw;
        double ah;
        double xo = 0.0;
        double yo = 0.0;
        boolean ipaint;
        boolean iloaded;
        double lineHeight;
        String[] lines = null;
        double[] widths = null;
        boolean requiresMultipleLines;
        public static final String SOFT_DELIM = " \t";
        public static final String HARD_DELIM = "\n\r\f";
        public static final String ALL_DELIM = " \t\n\r\f";

        void computeAlignment(double w, double h) {
            switch (BLabel.this.getHalign().getOrdinal()) {
                case 0: {
                    this.xo = 0.0;
                    break;
                }
                case 1: {
                    this.xo = (w - this.aw) / 2.0;
                    break;
                }
                case 2: {
                    this.xo = w - this.aw;
                    break;
                }
                case 3: {
                    this.xo = (w - this.aw) / 2.0;
                }
            }
            switch (BLabel.this.getValign().getOrdinal()) {
                case 0: {
                    this.yo = 0.0;
                    break;
                }
                case 1: {
                    this.yo = (h - this.ah) / 2.0;
                    break;
                }
                case 2: {
                    this.yo = h - this.ah;
                    break;
                }
                case 3: {
                    this.yo = (h - this.ah) / 2.0;
                }
            }
        }

        void computeBounds() {
            this.computeImageBounds();
            this.computeTextBounds();
            if (this.tw > 0.0 && this.iw > 0.0) {
                this.computeCompoundLayout();
            } else {
                this.aw = Math.max(this.tw, this.iw);
                this.ah = Math.max(this.th, this.ih);
            }
        }

        private void computeTextBounds() {
            BFont font = BLabel.this.getFont();
            if (font.isNull()) {
                font = BLabel.this.theme().getTextFont(BLabel.this);
            }
            double fontHeight = font.getHeight();
            double fontDescent = font.getDescent();
            this.lineHeight = fontHeight;
            this.layoutFont = font;
            String text = BLabel.this.getText();
            if (text.length() == 0) {
                this.tw = 0.0;
                this.th = 0.0;
                return;
            }
            if (this.lines == null) {
                this.parse();
                this.widths = new double[this.lines.length];
            }
            this.tx = 0.0;
            this.ty = fontHeight - fontDescent;
            this.tw = 0.0;
            this.th = this.lineHeight * (double)this.lines.length;
            for (int i = 0; i < this.lines.length; ++i) {
                this.widths[i] = font.fractionalWidth(this.lines[i]);
                this.tw = Math.max(this.tw, this.widths[i]);
            }
            this.tw = Math.ceil(this.tw);
            this.requiresMultipleLines = this.lines.length > 1;
        }

        public boolean requiresMultipleLines() {
            return this.requiresMultipleLines;
        }

        private void computeImageBounds() {
            BImage image = BLabel.this.getImage();
            this.iy = 0.0;
            this.ix = 0.0;
            if (image.isNull() || !image.isDimensionsLoaded()) {
                image.syncDimensions();
                this.ipaint = false;
                this.iloaded = false;
            } else {
                this.ipaint = true;
                this.iloaded = true;
                this.iw = image.getWidth();
                this.ih = image.getHeight();
            }
        }

        private void computeCompoundLayout() {
            double gap = BLabel.this.getTextIconGap();
            this.aw = Math.max(this.tw, this.iw);
            this.ah = Math.max(this.th, this.ih);
            switch (BLabel.this.getTextToIconAlign().getOrdinal()) {
                case 0: {
                    this.tx += (this.aw - this.tw) / 2.0;
                    this.ix = (this.aw - this.iw) / 2.0;
                    this.iy = this.th + gap;
                    this.ah = this.th + gap + this.ih;
                    break;
                }
                case 2: {
                    this.tx += (this.aw - this.tw) / 2.0;
                    this.ix = (this.aw - this.iw) / 2.0;
                    this.ty += this.ih + gap;
                    this.ah = this.th + gap + this.ih;
                    break;
                }
                case 1: {
                    this.ty += (this.ah - this.th) / 2.0;
                    this.iy = (this.ah - this.ih) / 2.0;
                    this.ix = this.tw + gap;
                    this.aw = this.tw + gap + this.iw;
                    break;
                }
                case 3: {
                    this.ty += (this.ah - this.th) / 2.0;
                    this.iy = (this.ah - this.ih) / 2.0;
                    this.tx += this.iw + gap;
                    this.aw = this.tw + gap + this.iw;
                    break;
                }
                case 4: {
                    this.tx += (this.aw - this.tw) / 2.0;
                    this.ty += (this.ah - this.th) / 2.0;
                    this.ix = (this.aw - this.iw) / 2.0;
                    this.iy = (this.ah - this.ih) / 2.0;
                }
            }
        }

        protected void parse() {
            BFont font = BLabel.this.getFont();
            if (font.isNull()) {
                font = BLabel.this.theme().getTextFont(BLabel.this);
            }
            double w = BLabel.this.getWidth();
            boolean causedOverflow = false;
            if (this.iw > 0.0) {
                w = w - BLabel.this.getTextIconGap() - this.iw;
            }
            ArrayList<String> array = new ArrayList<String>();
            StringTokenizer st = BLabel.this.getWordWrapEnabled() ? new StringTokenizer(BLabel.this.getText(), ALL_DELIM, true) : new StringTokenizer(BLabel.this.getText(), HARD_DELIM, true);
            StringBuilder running = new StringBuilder();
            StringBuilder last = new StringBuilder();
            while (st.hasMoreTokens()) {
                String next = st.nextToken();
                if (BLabel.this.getWordWrapEnabled() && this.isSoftDelim(next)) {
                    last.append(next);
                    continue;
                }
                if (this.isHardDelim(next)) {
                    if (causedOverflow) continue;
                    array.add(running.toString());
                    last.setLength(0);
                    running.setLength(0);
                    continue;
                }
                String widthArg = running.toString() + last + next;
                double currentWidth = font.width(widthArg);
                if (w > 0.0 && currentWidth > w) {
                    causedOverflow = true;
                    if (running.length() > 0) {
                        array.add(running.toString());
                    }
                    running.setLength(0);
                    double nextWidth = font.width(next);
                    if (nextWidth > w) {
                        array.add(next);
                    } else if (next.length() > 0) {
                        running.append(next);
                    }
                } else {
                    causedOverflow = false;
                    running.append((CharSequence)last).append(next);
                }
                last.setLength(0);
            }
            if (running.length() > 0) {
                array.add(running.toString());
            }
            this.lines = array.toArray(new String[0]);
        }

        private boolean isSoftDelim(String text) {
            return SOFT_DELIM.indexOf(text) >= 0;
        }

        private boolean isHardDelim(String text) {
            return HARD_DELIM.indexOf(text) >= 0;
        }

        void dump() {
            System.out.println("  text:  " + this.tx + "," + this.ty + "," + this.tw + "," + this.th);
            System.out.println("  image: " + this.ix + "," + this.iy + "," + this.iw + "," + this.ih);
            System.out.println("  aggr:  " + this.aw + "," + this.ah);
            System.out.println("  off:   " + this.xo + "," + this.yo);
            System.out.println("  lineHt:" + this.lineHeight);
            System.out.println("  font:  " + font);
        }

        public RectGeom getTextGeom() {
            return new RectGeom(this.tx, this.ty, this.tw, this.th);
        }

        public RectGeom getImageGeom() {
            return new RectGeom(this.ix, this.iy, this.iw, this.ih);
        }

        public Point getAlignmentOffsets() {
            return new Point(this.xo, this.yo);
        }

        public double getLineHeight() {
            return this.lineHeight;
        }

        public BFont getLayoutFont() {
            return this.layoutFont;
        }
    }
}

