/*
 * Decompiled with CFR 0.152.
 */
package javax.baja.ui;

import com.tridium.gx.GxEnv;
import com.tridium.gx.ImagePeer;
import com.tridium.gx.awt.AwtGraphics;
import com.tridium.gx.awt.AwtImagePeer;
import com.tridium.gx.awt.ImageManager;
import com.tridium.gx.micro.MicroEnv;
import java.awt.Graphics2D;
import java.util.logging.Level;
import javax.baja.gx.BImage;
import javax.baja.gx.BTransform;
import javax.baja.gx.Graphics;
import javax.baja.ui.BPicture;

final class AwtPictureImpl
implements BPicture.IPictureImpl {
    private ImagePeer picturePeer;
    private final BPicture picture;

    public AwtPictureImpl(BPicture picture) {
        this.picture = picture;
    }

    @Override
    public void resetPeer() {
        this.picturePeer = null;
    }

    @Override
    public ImagePeer ensurePeer() {
        GxEnv env = GxEnv.get();
        if (env instanceof MicroEnv) {
            this.picturePeer = GxEnv.get().makeImagePeer(this.picture.getImage());
        } else {
            BPicture.doScaleLayout(this.picture);
            this.picturePeer = new AwtImagePeer(ImageManager.fetchImageData((BImage)this.picture.getImage(), (BTransform.Scale)this.picture.transScale));
            ((AwtImagePeer)this.picturePeer).data.repaintOnLoad = true;
        }
        return this.picturePeer;
    }

    @Override
    public boolean paint(Graphics g) {
        if (!(g instanceof AwtGraphics)) {
            return false;
        }
        g.push();
        try {
            g.translate(this.picture.dx, this.picture.dy);
            Graphics2D g2d = ((AwtGraphics)g).getAwtGraphics();
            g2d.drawImage(((AwtImagePeer)this.ensurePeer()).image(), 0, 0, null);
        }
        catch (Throwable e) {
            BPicture.LOG.log(Level.SEVERE, "Failed to draw image with AWT graphics: " + e.getMessage(), BPicture.LOG.isLoggable(Level.FINE) ? e : null);
        }
        finally {
            g.pop();
        }
        return true;
    }
}

