/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.ui.wizard.step;

import com.tridium.ui.wizard.step.StepArtifact;
import com.tridium.ui.wizard.step.WizardStep;
import javax.baja.nre.util.Array;

public final class StepArtifactHistory {
    private Entry head;
    private Entry tail;
    private Entry current;

    public StepArtifactHistory() {
        this.clear();
    }

    public void add(StepArtifact artifact) {
        if (artifact == null) {
            throw new IllegalArgumentException("Cannot add null StepArtifact to StepArtifactHistory!");
        }
        if (this.isForward()) {
            this.current.next = (this.current.next.last = null);
            this.tail = this.current;
        }
        Entry entry = new Entry(artifact);
        entry.last = this.tail;
        this.current = this.tail = (this.tail.next = entry);
    }

    public StepArtifact forward() {
        if (!this.isForward()) {
            return null;
        }
        this.current = this.current.next;
        return this.current.artifact;
    }

    public StepArtifact backward() {
        if (!this.isBackward()) {
            return null;
        }
        this.current = this.current.last;
        return this.current.artifact;
    }

    public void clear() {
        this.head = this.tail = new Entry(null);
        this.current = this.tail;
        this.head.last = this.tail;
    }

    public void updateCurrent(StepArtifact artifact) {
        if (artifact == null) {
            throw new IllegalArgumentException("Cannot update StepArtifact with null value to StepArtifactHistory!");
        }
        if (!this.isEmpty()) {
            this.current.artifact = artifact;
        }
    }

    public void removeCurrent() {
        if (this.isEmpty()) {
            return;
        }
        this.tail = this.current.last;
        this.tail.next = (this.current.last = null);
        this.current = this.tail;
    }

    public boolean isForward() {
        return this.current.next != null;
    }

    public boolean isBackward() {
        if (this.isEmpty()) {
            return false;
        }
        return this.current.last != this.head;
    }

    public boolean isEmpty() {
        return this.head == this.tail;
    }

    public StepArtifact peekForward() {
        if (!this.isForward()) {
            return null;
        }
        return this.current.next.artifact;
    }

    public StepArtifact peekBackward() {
        if (!this.isBackward()) {
            return null;
        }
        return this.current.last.artifact;
    }

    public StepArtifact getCurrent() {
        return this.current.artifact;
    }

    public StepArtifact[] getCurrentStepArtifacts() {
        Array a = new Array(StepArtifact.class);
        Entry entry = this.head.next;
        while (entry != null) {
            if (entry.artifact == null) {
                throw new IllegalStateException("StepArtifact is null in StepArtifactHistory!");
            }
            a.add((Object)entry.artifact);
            if (entry == this.current) break;
            entry = entry.next;
        }
        return (StepArtifact[])a.trim();
    }

    public StepArtifact[] getStepArtifacts() {
        Array a = new Array(StepArtifact.class);
        Entry entry = this.head.next;
        while (entry != null) {
            if (entry.artifact == null) {
                throw new IllegalStateException("StepArtifact is null in StepArtifactHistory!");
            }
            a.add((Object)entry.artifact);
            entry = entry.next;
        }
        return (StepArtifact[])a.trim();
    }

    public StepArtifact searchForArtifact(WizardStep step) {
        StepArtifact artifact = null;
        Entry entry = this.head.next;
        while (entry != null) {
            if (entry.artifact == null) {
                throw new IllegalStateException("StepArtifact is null in StepArtifactHistory!");
            }
            if (entry.artifact.getStep().equals(step)) {
                artifact = entry.artifact;
                break;
            }
            entry = entry.next;
        }
        return artifact;
    }

    public StepArtifact searchForArtifact(Class<?> stepArtifactCls) {
        StepArtifact artifact = null;
        Entry entry = this.head.next;
        while (entry != null) {
            if (entry.artifact == null) {
                throw new IllegalStateException("StepArtifact is null in StepArtifactHistory!");
            }
            if (entry.artifact.getClass().isAssignableFrom(stepArtifactCls)) {
                artifact = entry.artifact;
                break;
            }
            entry = entry.next;
        }
        return artifact;
    }

    public void dump() {
        StepArtifact[] artifacts = this.getStepArtifacts();
        System.out.println("Dumping Step Artifact History...");
        System.out.println("Current Step Artifact: " + this.getCurrent());
        for (int i = 0; i < artifacts.length; ++i) {
            System.out.println("Step Artifact: " + artifacts[i]);
        }
    }

    private static class Entry {
        private StepArtifact artifact;
        private Entry next;
        private Entry last;

        private Entry(StepArtifact artifact) {
            this.artifact = artifact;
        }
    }
}

