/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.ui.util;

import java.text.AttributedCharacterIterator;
import java.util.function.Predicate;
import javax.baja.ui.event.BInputMethodEvent;
import javax.baja.ui.event.BKeyEvent;
import javax.baja.ui.text.BTextEditor;
import javax.baja.ui.text.TextController;
import javax.baja.ui.text.TextSelection;

public abstract class ValidatingTextController
extends TextController {
    public static final ValidatingTextController NO_VALIDATION = new ValidatingTextController(){

        @Override
        protected boolean valid(String updatedText) {
            return true;
        }
    };

    public static ValidatingTextController make(final Predicate<String> filter) {
        return filter == null ? NO_VALIDATION : new ValidatingTextController(){

            @Override
            protected boolean valid(String updatedText) {
                return filter.test(updatedText);
            }
        };
    }

    @Override
    public void keyTyped(BKeyEvent event) {
        char key = event.getKeyChar();
        String updatedText = this.getUpdatedText(Character.toString(key));
        if (this.valid(updatedText)) {
            super.keyTyped(event);
        }
    }

    @Override
    public void keyPressed(BKeyEvent event) {
        int keyCode = event.getKeyCode();
        String updatedText = this.getUpdatedText(keyCode);
        if (this.valid(updatedText)) {
            super.keyPressed(event);
        }
    }

    @Override
    public void imTextChanged(BInputMethodEvent event) {
        AttributedCharacterIterator eventText = event.getText();
        String eventTextString = this.getText(eventText);
        String existingTextString = this.getModel().getText();
        if (this.valid(existingTextString + eventTextString)) {
            super.imTextChanged(event);
        }
    }

    @Override
    protected boolean validateTextToInsert(String text) {
        String updatedText = this.getUpdatedText(text);
        return this.valid(updatedText);
    }

    protected String getUpdatedText(int keyCode) {
        switch (keyCode) {
            case 127: {
                return this.getUpdatedTextAfterDelete();
            }
            case 8: {
                return this.getUpdatedTextAfterBackspace();
            }
        }
        return this.getModelText();
    }

    protected String getUpdatedText(String text) {
        int start = this.getEditor().getCaretPosition().column;
        int overtyped = 0;
        if (!this.getEditor().getSelection().isEmpty()) {
            start = this.getEditor().getSelection().getStart().column;
            overtyped = this.getEditor().getSelection().getEnd().column - start;
        }
        String modelText = this.getEditor().getModel().getText();
        StringBuilder updatedText = new StringBuilder();
        if (start > 0) {
            updatedText.append(modelText.substring(0, start));
        }
        updatedText.append(text);
        updatedText.append(modelText.substring(start + overtyped));
        return updatedText.toString();
    }

    private String getUpdatedTextAfterDelete() {
        int start = this.getStart();
        int end = this.getEnd();
        String modelText = this.getModelText();
        StringBuilder updatedText = new StringBuilder();
        if (start == end) {
            if (end == modelText.length()) {
                return modelText;
            }
            ++end;
        }
        if (start > 0) {
            updatedText.append(modelText.substring(0, start));
        }
        if (end < modelText.length()) {
            updatedText.append(modelText.substring(end));
        }
        return updatedText.toString();
    }

    private String getUpdatedTextAfterBackspace() {
        int start = this.getStart();
        int end = this.getEnd();
        String modelText = this.getModelText();
        StringBuilder updatedText = new StringBuilder();
        if (start == end) {
            if (start == 0) {
                return modelText;
            }
            --start;
        }
        if (start > 0) {
            updatedText.append(modelText.substring(0, start));
        }
        if (end < modelText.length()) {
            updatedText.append(modelText.substring(end));
        }
        return updatedText.toString();
    }

    private String getModelText() {
        return this.getEditor().getModel().getText();
    }

    private int getStart() {
        BTextEditor ed = this.getEditor();
        TextSelection selection = ed.getSelection();
        return selection.isEmpty() ? ed.getCaretPosition().column : selection.getStart().column;
    }

    private int getEnd() {
        BTextEditor ed = this.getEditor();
        TextSelection selection = ed.getSelection();
        return selection.isEmpty() ? ed.getCaretPosition().column : selection.getEnd().column;
    }

    protected abstract boolean valid(String var1);
}

