/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.ui.theme.palladium;

import com.tridium.ui.theme.MenuBarTheme;
import com.tridium.ui.theme.palladium.PalladiumWidgetTheme;
import javax.baja.gx.BBrush;
import javax.baja.gx.BFont;
import javax.baja.gx.BInsets;
import javax.baja.gx.Graphics;
import javax.baja.gx.Point;
import javax.baja.gx.RectGeom;
import javax.baja.ui.BMenuBar;

public class PalladiumMenuBarTheme
extends PalladiumWidgetTheme
implements MenuBarTheme {
    static Point depressedOffset = new Point(1.0, 1.0);
    static Point normalOffset = new Point(0.0, 0.0);
    static BInsets itemInsets = BInsets.make((double)2.0, (double)7.0, (double)2.0, (double)7.0);
    static BInsets barInsets = BInsets.make((double)1.0, (double)1.0, (double)1.0, (double)1.0);

    @Override
    public BInsets getBarInsets() {
        return barInsets;
    }

    @Override
    public BInsets getItemInsets() {
        return itemInsets;
    }

    @Override
    public BFont getItemFont(BMenuBar menuBar) {
        return plainText;
    }

    @Override
    public BBrush getItemTextBrush(int state, BMenuBar menuBar) {
        return this.getControlForeground();
    }

    @Override
    public Point getItemTextOffset(int state) {
        return state == 2 ? depressedOffset : normalOffset;
    }

    @Override
    public void paintItemBackground(Graphics g, BMenuBar m, RectGeom r, int state) {
        if (state != 2 && state != 1) {
            return;
        }
        double x = r.x;
        double y = r.y;
        double w = r.width;
        double h = r.height;
        g.setBrush(this.getControlForeground());
        g.strokeRect(x, y, w - 1.0, h - 1.0);
        if (state == 2) {
            g.setBrush(this.getControlShadow());
        } else {
            g.setBrush(this.getControlHighlight());
        }
        g.strokeLine(x + 1.0, y + 1.0, x + w - 3.0, y + 1.0);
        g.strokeLine(x + 1.0, y + 1.0, x + 1.0, y + h - 3.0);
        g.setBrush(this.getControlShadow());
        g.strokeLine(x + w - 2.0, y + 1.0, x + w - 2.0, y + h - 2.0);
        g.strokeLine(x + 1.0, y + h - 2.0, x + w - 2.0, y + h - 2.0);
    }

    @Override
    public void paintBackground(Graphics g, BMenuBar m) {
        double w = m.getWidth();
        double h = m.getHeight();
        g.setBrush(this.getControlBackground());
        g.fillRect(0.0, 0.0, w - 1.0, h - 1.0);
    }
}

