/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.ui.theme.palladium;

import com.tridium.ui.theme.AbstractButtonTheme;
import com.tridium.ui.theme.palladium.PalladiumLabelTheme;
import javax.baja.gx.BBrush;
import javax.baja.gx.BFont;
import javax.baja.gx.BInsets;
import javax.baja.gx.Graphics;
import javax.baja.gx.IInsets;
import javax.baja.gx.IPoint;
import javax.baja.gx.Point;
import javax.baja.gx.RectGeom;
import javax.baja.ui.BAbstractButton;
import javax.baja.ui.BToggleButton;
import javax.baja.ui.enums.BButtonStyle;

public abstract class PalladiumAbstractButtonTheme
extends PalladiumLabelTheme
implements AbstractButtonTheme {
    static Point noOffset = new Point(0.0, 0.0);
    static Point pressedOffset = new Point(1.0, 1.0);
    static BInsets normalPadding = BInsets.make((double)5.0, (double)13.0, (double)5.0, (double)13.0);
    static BInsets toolbarPadding = BInsets.make((double)3.0, (double)3.0, (double)3.0, (double)3.0);
    static double menuWidth = 11.0;

    @Override
    public BFont getTextFont() {
        return this.getBoldText();
    }

    public BBrush getTextBrush(boolean isEnabled) {
        return isEnabled ? this.getControlForeground() : this.getControlShadow();
    }

    @Override
    public IInsets getPadding(BAbstractButton b) {
        if (b.getButtonStyle() == BButtonStyle.toolBar) {
            return toolbarPadding;
        }
        return normalPadding;
    }

    @Override
    public IPoint getLabelOffset(BAbstractButton b) {
        BAbstractButton.MenuController c = b.getMenuController();
        if (c != null && !c.isMenuDistinct() && b.isMenuPressed()) {
            return pressedOffset;
        }
        if (b.isPressed() && b.isMouseOver()) {
            return pressedOffset;
        }
        if (b instanceof BToggleButton && ((BToggleButton)b).isSelected()) {
            return pressedOffset;
        }
        return noOffset;
    }

    @Override
    public double getMenuWidth() {
        return menuWidth;
    }

    @Override
    @Deprecated
    public void paintDisabledText(Graphics g, String s, double x, double y) {
        g.setBrush(this.getControlHighlight());
        g.drawString(s, x + 1.0, y + 1.0);
        g.setBrush(this.getControlShadow());
        g.drawString(s, x, y);
    }

    @Override
    public void paintBackground(Graphics g, BAbstractButton b) {
        boolean enabled = b.getEnabled();
        boolean mouseOver = b.isMouseOver();
        boolean pressed = b.isPressed();
        boolean menuPressed = b.isMenuPressed();
        boolean hasMenu = b.getMenuController() != null;
        boolean distinct = !hasMenu ? false : b.getMenuController().isMenuDistinct();
        boolean selected = false;
        if (b instanceof BToggleButton) {
            selected = ((BToggleButton)b).isSelected();
        }
        double w = b.getWidth();
        double h = b.getHeight();
        double mw = this.getMenuWidth();
        if (hasMenu) {
            w -= this.getMenuWidth();
        }
        boolean drawOutline = true;
        boolean drawShading = true;
        if (!hasMenu) {
            distinct = true;
        }
        if (!(b.getButtonStyle() != BButtonStyle.toolBar || mouseOver && enabled || menuPressed)) {
            drawOutline = false;
            if (!selected) {
                drawShading = false;
            }
        }
        g.setBrush(this.getBackground(b, pressed, selected));
        g.fillRect(1.0, 1.0, w - 2.0, h - 2.0);
        if (drawOutline) {
            if (enabled) {
                g.setBrush(this.getControlForeground());
            } else {
                g.setBrush(this.getControlShadow());
            }
            g.strokeRect(0.0, 0.0, !distinct ? w - 1.0 + mw : w - 1.0, h - 1.0);
            if (hasMenu && distinct) {
                g.strokeRect(w - 1.0, 0.0, mw, h - 1.0);
            }
        }
        if (drawShading) {
            if (menuPressed && !distinct || !menuPressed && pressed && mouseOver || selected) {
                g.setBrush(this.getControlShadow());
            } else {
                g.setBrush(this.getControlHighlight());
            }
            double tempw = w + (!distinct ? mw : 0.0);
            g.strokeLine(1.0, 1.0, tempw - 3.0, 1.0);
            g.strokeLine(1.0, 1.0, 1.0, h - 3.0);
            if (hasMenu && distinct && (b.getButtonStyle() != BButtonStyle.toolBar || pressed || mouseOver)) {
                if (menuPressed) {
                    g.setBrush(this.getControlShadow());
                } else {
                    g.setBrush(this.getControlHighlight());
                }
                g.strokeLine(w, 1.0, w + mw - 3.0, 1.0);
                g.strokeLine(w, 1.0, w, h - 3.0);
            }
            if (enabled || selected) {
                g.setBrush(this.getControlShadow());
            } else {
                g.setBrush(this.getControlAuxiliary());
            }
            g.strokeLine(tempw - 2.0, 1.0, tempw - 2.0, h - 2.0);
            g.strokeLine(1.0, h - 2.0, tempw - 2.0, h - 2.0);
            if (hasMenu && distinct && (b.getButtonStyle() != BButtonStyle.toolBar || pressed || mouseOver)) {
                g.strokeLine(w + mw - 2.0, 1.0, w + mw - 2.0, h - 2.0);
                g.strokeLine(w, h - 2.0, w + mw - 2.0, h - 2.0);
            }
        }
        if (hasMenu) {
            if (enabled) {
                g.setBrush(this.getControlForeground());
            } else {
                g.setBrush(this.getControlShadow());
            }
            int arrowWidth = 3;
            int mid = (int)w + (int)this.getMenuWidth() - arrowWidth - 4;
            if (!distinct && b.getButtonStyle() != BButtonStyle.toolBar) {
                mid -= 3;
            }
            int bottom = 0 + arrowWidth + ((int)h - arrowWidth) / 2 - 1;
            if (menuPressed) {
                mid += (int)PalladiumAbstractButtonTheme.pressedOffset.x;
                bottom += (int)PalladiumAbstractButtonTheme.pressedOffset.y;
            }
            for (int i = 0; i < arrowWidth; ++i) {
                g.strokeLine((double)(mid - i), (double)(bottom - i), (double)(mid + i), (double)(bottom - i));
            }
        }
        if (b.hasFocus() && b.getButtonStyle() != BButtonStyle.toolBar) {
            this.paintFocus(g, new RectGeom(3.0, 3.0, w - 7.0, h - 7.0));
        }
        this.paintDefaultBorder(g, b, pressed);
    }

    protected BBrush getBackground(BAbstractButton b, boolean isDepressed, boolean isSelected) {
        return b.getBackground().isNull() ? this.getControlBackground() : b.getBackground();
    }

    protected void paintDefaultBorder(Graphics g, BAbstractButton b, boolean isDepressed) {
    }
}

