/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.ui.theme.custom;

import com.tridium.ui.PaintUtil;
import com.tridium.ui.theme.WidgetTheme;
import com.tridium.ui.theme.custom.nss.NSS;
import com.tridium.ui.theme.custom.nss.NSSUtils;
import java.util.logging.Logger;
import javax.baja.gx.BBrush;
import javax.baja.gx.BFont;
import javax.baja.gx.Graphics;
import javax.baja.gx.IRectGeom;
import javax.baja.gx.RectGeom;
import javax.baja.ui.style.IStylable;

public class CustomWidgetTheme
implements WidgetTheme {
    static final Logger logger = Logger.getLogger("com.tridium.ui.theme.custom");
    private static NSS nss;

    String getNSSSelector() {
        return "";
    }

    public static NSS getNSS() {
        return nss;
    }

    public static void setNSS(NSS nss) {
        CustomWidgetTheme.nss = nss;
    }

    Object select(String selector) {
        return CustomWidgetTheme.getNSS().select(this.getNSSSelector() + " " + selector);
    }

    Object selectStrict(String selector) {
        return CustomWidgetTheme.getNSS().selectStrict(this.getNSSSelector() + " " + selector);
    }

    Object select(IStylable widget, String selector) {
        if (widget == null) {
            return this.select(selector);
        }
        String widgetPath = widget.getStyleSelector();
        if (widgetPath == null || widgetPath.trim().length() == 0) {
            widgetPath = this.getNSSSelector();
        }
        return CustomWidgetTheme.getNSS().select(widget, widgetPath, selector);
    }

    Object selectStrict(IStylable widget, String selector) {
        if (widget == null) {
            return this.selectStrict(selector);
        }
        String widgetPath = widget.getStyleSelector();
        if (widgetPath == null || widgetPath.trim().length() == 0) {
            widgetPath = this.getNSSSelector();
        }
        return CustomWidgetTheme.getNSS().selectStrict(widget, widgetPath, selector);
    }

    @Override
    public BBrush getWindowBackground() {
        BBrush color = (BBrush)this.select("window-background-color");
        if (color == null) {
            color = (BBrush)this.select("background-color");
        }
        return color;
    }

    @Override
    public BBrush getWindowBackground(IStylable widget) {
        BBrush color = (BBrush)this.selectStrict(widget, "background-color");
        if (color == null) {
            color = (BBrush)this.select(widget, "window-background-color");
        }
        if (color == null) {
            color = (BBrush)this.select(widget, "background-color");
        }
        return color;
    }

    @Override
    public BBrush getWindowForeground() {
        BBrush color = (BBrush)this.select("window-color");
        if (color == null) {
            color = (BBrush)this.select("color");
        }
        return color;
    }

    @Override
    public BBrush getWindowForeground(IStylable widget) {
        BBrush color = (BBrush)this.selectStrict(widget, "color");
        if (color == null) {
            color = (BBrush)this.select(widget, "window-color");
        }
        if (color == null) {
            color = (BBrush)this.select(widget, "color");
        }
        return color;
    }

    @Override
    public BBrush getControlBackground() {
        return (BBrush)this.select("background-color");
    }

    @Override
    public BBrush getControlBackground(IStylable widget) {
        return (BBrush)this.select(widget, "background-color");
    }

    @Override
    public BBrush getControlForeground() {
        return (BBrush)this.select("outline");
    }

    @Override
    public BBrush getControlForeground(IStylable widget) {
        return (BBrush)this.select(widget, "outline");
    }

    @Override
    public BBrush getControlHighlight() {
        return (BBrush)this.select("highlight");
    }

    @Override
    public BBrush getControlHighlight(IStylable widget) {
        return (BBrush)this.select(widget, "highlight");
    }

    @Override
    public BBrush getControlShadow() {
        return (BBrush)this.select("shadow");
    }

    @Override
    public BBrush getControlShadow(IStylable widget) {
        return (BBrush)this.select(widget, "shadow");
    }

    @Override
    public BBrush getControlAuxiliary() {
        return (BBrush)this.select("auxiliary-color");
    }

    @Override
    public BBrush getControlAuxiliary(IStylable widget) {
        return (BBrush)this.select(widget, "auxiliary-color");
    }

    @Override
    public BBrush getControlHeader() {
        return (BBrush)this.select("header-color");
    }

    @Override
    public BBrush getControlHeader(IStylable widget) {
        return (BBrush)this.select(widget, "dialog-header-color");
    }

    @Override
    public BBrush getSelectionBackground() {
        return (BBrush)this.select("selection-background-color");
    }

    @Override
    public BBrush getSelectionBackground(IStylable widget) {
        return (BBrush)this.select(widget, "selection-background-color");
    }

    @Override
    public BBrush getSelectionForeground() {
        return (BBrush)this.select("selection-color");
    }

    @Override
    public BBrush getSelectionForeground(IStylable widget) {
        return (BBrush)this.select(widget, "selection-color");
    }

    @Override
    public BBrush getDropOkForeground() {
        return (BBrush)this.select("drop-ok-color");
    }

    @Override
    public BBrush getDropOkForeground(IStylable widget) {
        return (BBrush)this.select(widget, "drop-ok-color");
    }

    @Override
    public BBrush getDropOkBackground() {
        return (BBrush)this.select("drop-ok-background-color");
    }

    @Override
    public BBrush getDropOkBackground(IStylable widget) {
        return (BBrush)this.select(widget, "drop-ok-background-color");
    }

    public BFont getPlainText() {
        return (BFont)this.select("font");
    }

    public BFont getPlainText(IStylable widget) {
        return (BFont)this.select(widget, "font");
    }

    @Override
    public BFont getBoldText() {
        return (BFont)this.select("bold-font");
    }

    @Override
    public BFont getBoldText(IStylable widget) {
        return (BFont)this.select(widget, "bold-font");
    }

    @Override
    public BFont getLargeFont() {
        return (BFont)this.select("large-font");
    }

    @Override
    public BFont getLargeFont(IStylable widget) {
        return (BFont)this.select(widget, "large-font");
    }

    @Override
    public BFont getLargeBoldFont() {
        return (BFont)this.select("large-bold-font");
    }

    @Override
    public BFont getLargeBoldFont(IStylable widget) {
        return (BFont)this.select(widget, "large-bold-font");
    }

    @Override
    public BFont getFixedWidthFont() {
        return (BFont)this.select("fixed-font");
    }

    @Override
    public BFont getFixedWidthFont(IStylable widget) {
        return (BFont)this.select(widget, "fixed-font");
    }

    @Override
    public BFont getFixedWidthBoldFont() {
        return (BFont)this.select("fixed-bold-font");
    }

    @Override
    public BFont getFixedWidthBoldFont(IStylable widget) {
        return (BFont)this.select(widget, "fixed-bold-font");
    }

    @Override
    public BFont getTextFont() {
        return (BFont)this.select("font");
    }

    @Override
    public BFont getTextFont(IStylable widget) {
        return (BFont)this.select(widget, "font");
    }

    @Override
    public BBrush getTextBrush() {
        return (BBrush)this.select("color");
    }

    @Override
    public BBrush getTextBrush(IStylable widget) {
        return (BBrush)this.select(widget, "color");
    }

    public BBrush getFocusBrush() {
        return (BBrush)this.select("focus-color");
    }

    public BBrush getFocusBrush(IStylable widget) {
        return (BBrush)this.select(widget, "focus-color");
    }

    @Override
    public BBrush getTextDisabled() {
        return (BBrush)this.select(".disabled color");
    }

    @Override
    public BBrush getTextDisabled(IStylable widget) {
        return (BBrush)this.select(widget, ".disabled color");
    }

    @Override
    @Deprecated
    public void paintDisabledText(Graphics g, String s, double x, double y) {
        this.paintDisabledText(g, null, s, x, y);
    }

    @Override
    public void paintDisabledText(Graphics g, IStylable widget, String s, double x, double y) {
        g.setBrush(this.getTextDisabled(widget));
        g.drawString(s, x, y);
    }

    @Override
    public void paintFocus(Graphics g, RectGeom bounds) {
        g.setBrush(this.getFocusBrush());
        PaintUtil.drawDashedRect(g, (IRectGeom)bounds);
    }

    void regFallbackValue(NSS nss, String property, String selector, String fallbackValue) {
        Object nssProperty = nss.select(selector);
        boolean success = false;
        boolean invalid = false;
        try {
            success = NSSUtils.setThemeProperty(this, property, nssProperty);
        }
        catch (Throwable th) {
            invalid = true;
        }
        if (!success) {
            String err = "NSS selector '" + nss.getSelector() + " " + selector + "' does not reference a valid property. ";
            if (fallbackValue != null) {
                if (invalid) {
                    logger.warning(err + "Using default of '" + fallbackValue + "'.");
                }
                NSSUtils.setThemeProperty(this, property, fallbackValue);
            } else if (invalid) {
                logger.severe(err);
            }
        }
    }

    void regFallbackSelector(NSS nss, String property, String selector, String fallbackSelector) {
        Object nssProperty = nss.select(selector);
        boolean success = false;
        boolean invalid = false;
        try {
            success = NSSUtils.setThemeProperty(this, property, nssProperty);
        }
        catch (Throwable th) {
            invalid = true;
        }
        if (!success) {
            String err = "NSS selector '" + nss.getSelector() + " " + selector + "' does not reference a valid property. ";
            if (fallbackSelector != null) {
                if (invalid) {
                    logger.warning(err + "Using default of '" + fallbackSelector + "'.");
                }
                this.regFallbackSelector(nss, property, fallbackSelector, null);
            } else if (invalid) {
                logger.severe(err);
            }
        }
    }

    void reg(NSS nss, String property, String selector) {
        this.regFallbackValue(nss, property, selector, null);
    }
}

