/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.ui.theme.custom;

import com.tridium.ui.theme.ScrollBarTheme;
import com.tridium.ui.theme.custom.CustomThemeUtils;
import com.tridium.ui.theme.custom.CustomWidgetTheme;
import com.tridium.ui.theme.custom.nss.NSS;
import javax.baja.gx.BBrush;
import javax.baja.gx.Graphics;
import javax.baja.gx.RectGeom;
import javax.baja.ui.BScrollBar;
import javax.baja.ui.enums.BOrientation;

public class CustomScrollBarTheme
extends CustomWidgetTheme
implements ScrollBarTheme {
    public static final int UP = 0;
    public static final int DOWN = 1;
    public static final int LEFT = 2;
    public static final int RIGHT = 3;
    private double fixedWidth = 0.0;

    public CustomScrollBarTheme() {
        NSS nss = CustomScrollBarTheme.getNSS();
        this.regFallbackValue(nss, "fixedWidth", "scroll-bar width", "15");
    }

    @Override
    String getNSSSelector() {
        return "scroll-bar";
    }

    @Override
    public double getFixedWidth() {
        return this.fixedWidth;
    }

    public void setFixedWidth(double fw) {
        this.fixedWidth = fw;
    }

    @Override
    public void paintButton(Graphics g, BScrollBar sb, RectGeom r, int dir, boolean isPressed) {
        g.setBrush((BBrush)this.select(sb, "button background-color"));
        g.fillRect(r.x, r.y, r.width, r.height);
        g.setBrush((BBrush)this.select(sb, "button outline"));
        g.strokeRect(r.x, r.y, r.width - 1.0, r.height - 1.0);
        g.setBrush(isPressed ? (BBrush)this.select(sb, "button shadow") : (BBrush)this.select(sb, "button highlight"));
        g.strokeLine(r.x + 1.0, r.y + 1.0, r.x + r.width - 3.0, r.y + 1.0);
        g.strokeLine(r.x + 1.0, r.y + 1.0, r.x + 1.0, r.y + r.height - 3.0);
        g.setBrush((BBrush)this.select(sb, "button shadow"));
        g.strokeLine(r.x + r.width - 2.0, r.y + 1.0, r.x + r.width - 2.0, r.y + r.height - 2.0);
        g.strokeLine(r.x + 1.0, r.y + r.height - 2.0, r.x + r.width - 2.0, r.y + r.height - 2.0);
        g.setBrush((BBrush)this.select(sb, "button color"));
        int offset = isPressed ? 1 : 0;
        CustomThemeUtils.paintArrow(g, dir, (int)r.x + offset, (int)r.y + offset, (int)r.width, (int)r.height);
    }

    @Override
    public void paintTrack(Graphics g, BScrollBar sb, RectGeom r) {
        int ay2;
        int by2;
        int ay1;
        int by1;
        int bx1;
        int bx2;
        int ax1;
        int ax2;
        if (sb.getOrientation() == BOrientation.vertical) {
            ax1 = ax2 = (int)r.x;
            bx1 = bx2 = (int)r.x + (int)r.width - 1;
            ay1 = by1 = (int)r.y;
            ay2 = by2 = (int)r.y + (int)r.height - 1;
        } else {
            ax1 = bx1 = (int)r.x;
            ax2 = bx2 = (int)r.x + (int)r.width - 1;
            ay1 = ay2 = (int)r.y;
            by1 = by2 = (int)r.y + (int)r.height - 1;
        }
        g.setBrush((BBrush)this.select(sb, "track background-color"));
        g.fillRect(r.x, r.y, r.width, r.height);
        g.setBrush((BBrush)this.select(sb, "track outline"));
        g.strokeLine((double)ax1, (double)ay1, (double)ax2, (double)ay2);
        g.strokeLine((double)bx1, (double)by1, (double)bx2, (double)by2);
        if (sb.getOrientation() == BOrientation.vertical) {
            ++ax1;
            ++ax2;
            --bx1;
            --bx2;
        } else {
            ++ay1;
            ++ay2;
            --by1;
            --by2;
        }
        g.setBrush((BBrush)this.select(sb, "track highlight"));
        g.strokeLine((double)bx1, (double)by1, (double)bx2, (double)by2);
        g.strokeLine((double)ax2, (double)ay2, (double)bx2, (double)by2);
        g.setBrush((BBrush)this.select(sb, "track shadow"));
        g.strokeLine((double)ax1, (double)ay1, (double)ax2, (double)ay2);
        g.strokeLine((double)bx1, (double)by1, (double)ax1, (double)ay1);
    }

    @Override
    public void paintThumb(Graphics g, BScrollBar sb, RectGeom r) {
        if (sb.getEnabled()) {
            this.doPaintThumb(g, sb, r);
        }
    }

    private void doPaintThumb(Graphics g, BScrollBar sb, RectGeom r) {
        block13: {
            double sz;
            double ib;
            double numi;
            double is;
            double ih;
            double iw;
            double iy;
            double ix;
            double h;
            double w;
            double y;
            double x;
            block12: {
                BOrientation orientation = sb.getOrientation();
                if (orientation == BOrientation.vertical) {
                    x = r.x + 1.0;
                    y = r.y;
                    w = r.width - 3.0;
                    h = r.height - 1.0;
                } else {
                    x = r.x;
                    y = r.y + 1.0;
                    w = r.width - 1.0;
                    h = r.height - 3.0;
                }
                if (w <= 0.0 || h <= 0.0) {
                    return;
                }
                g.setBrush((BBrush)this.select(sb, "thumb outline"));
                if (orientation == BOrientation.vertical) {
                    g.strokeRect(r.x, r.y - 1.0, r.width - 1.0, r.height + 1.0);
                } else {
                    g.strokeRect(r.x - 1.0, r.y, r.width + 1.0, r.height - 1.0);
                }
                g.setBrush((BBrush)this.select(sb, "thumb background-color"));
                g.fillRect(x + 1.0, y + 1.0, w - 1.0, h - 1.0);
                g.setBrush((BBrush)this.select(sb, "thumb highlight"));
                g.strokeLine(x, y, x + w, y);
                g.strokeLine(x, y, x, y + h);
                g.setBrush((BBrush)this.select(sb, "thumb shadow"));
                g.strokeLine(x + w, y, x + w, y + h);
                g.strokeLine(x, y + h, x + w, y + h);
                ix = 0.0;
                iy = 0.0;
                iw = 0.0;
                ih = 0.0;
                is = 2.0;
                numi = 3.0;
                ib = 3.0;
                sz = 0.0;
                if (orientation != BOrientation.vertical) break block12;
                iw = (int)(w * 0.625);
                ih = 2.0;
                sz = ih * numi + is * (numi - 1.0) + ib + ib;
                while (sz > h && numi != 0.0) {
                    if ((numi -= 1.0) == 1.0) {
                        sz = ih * numi + ib + ib;
                        continue;
                    }
                    sz = ih * numi + is * (numi - 1.0) + ib + ib;
                }
                if (!(numi > 0.0)) break block13;
                ix = x + (w - iw) / 2.0;
                iy = y + ib + (h - sz) / 2.0 + 1.0;
                int j = 0;
                while ((double)j < numi) {
                    g.setBrush((BBrush)this.select(sb, "thumb shadow"));
                    g.strokeLine(ix, iy, ix + iw - 2.0, iy);
                    g.strokeLine(ix, iy, ix, iy + ih - 1.0);
                    g.setBrush((BBrush)this.select(sb, "thumb highlight"));
                    g.strokeLine(ix + iw - 1.0, iy, ix + iw - 1.0, iy + ih - 1.0);
                    g.strokeLine(ix + iw - 1.0, iy + ih - 1.0, ix + 1.0, iy + ih - 1.0);
                    iy += ih + is;
                    ++j;
                }
                break block13;
            }
            iw = 2.0;
            ih = h * 0.625;
            sz = iw * numi + is * (numi - 1.0) + ib + ib;
            while (sz > w && numi != 0.0) {
                if ((numi -= 1.0) == 1.0) {
                    sz = iw * numi + ib + ib;
                    continue;
                }
                sz = iw * numi + is * (numi - 1.0) + ib + ib;
            }
            if (numi > 0.0) {
                ix = x + ib + (w - sz) / 2.0 + 1.0;
                iy = y + (h - ih) / 2.0 + 1.0;
                int j = 0;
                while ((double)j < numi) {
                    g.setBrush((BBrush)this.select(sb, "thumb shadow"));
                    g.strokeLine(ix, iy, ix + iw - 1.0, iy);
                    g.strokeLine(ix, iy, ix, iy + ih - 1.0);
                    g.setBrush((BBrush)this.select("thumb highlight"));
                    g.strokeLine(ix + iw - 1.0, iy + 1.0, ix + iw - 1.0, iy + ih - 1.0);
                    g.strokeLine(ix + iw - 1.0, iy + ih - 1.0, ix, iy + ih - 1.0);
                    ix += iw + is;
                    ++j;
                }
            }
        }
    }
}

