/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.ui.theme.custom;

import com.tridium.ui.theme.JavaFxTheme;
import com.tridium.ui.theme.custom.CustomWidgetTheme;
import java.security.AccessController;
import javax.baja.gx.BBrush;
import javax.baja.ui.style.IStylable;

public class CustomJavaFxTheme
extends CustomWidgetTheme
implements JavaFxTheme {
    private static final boolean javaFxEnabledDefined = AccessController.doPrivileged(() -> System.getProperty("niagara.ui.javafx")) != null;
    private static final boolean javaFxEnabledValue = AccessController.doPrivileged(() -> Boolean.getBoolean("niagara.ui.javafx"));
    private static final boolean shouldHideNonessentialIconsDefined = AccessController.doPrivileged(() -> System.getProperty("niagara.ui.hideNonessentialIcons")) != null;
    private static final boolean shouldHideNonessentialIconsValue = AccessController.doPrivileged(() -> Boolean.getBoolean("niagara.ui.hideNonessentialIcons"));

    @Override
    String getNSSSelector() {
        return "javafx";
    }

    @Override
    public boolean isEnabled() {
        if (javaFxEnabledDefined) {
            return javaFxEnabledValue;
        }
        return !"false".equals(this.select("enabled"));
    }

    @Override
    public boolean shouldHideNonessentialIcons() {
        if (shouldHideNonessentialIconsDefined) {
            return shouldHideNonessentialIconsValue;
        }
        return "true".equals(this.select("hide-nonessential-icons"));
    }

    @Override
    public double getBorderRadius() {
        Double radius = (Double)this.select("border-radius");
        return radius == null ? 0.0 : radius;
    }

    @Override
    public double getBorderRadius(IStylable widget) {
        Double radius = (Double)this.select(widget, "border-radius");
        return radius == null ? 0.0 : radius;
    }

    @Override
    public BBrush getDropShadow() {
        BBrush shadow = (BBrush)this.select("drop-shadow");
        return shadow != null ? shadow : BBrush.DEFAULT;
    }

    @Override
    public BBrush getDropShadow(IStylable widget) {
        BBrush shadow = (BBrush)this.select(widget, "drop-shadow");
        return shadow != null ? shadow : BBrush.DEFAULT;
    }

    @Override
    public double getDropShadowWidth() {
        Double width = (Double)this.select("drop-shadow-width");
        return width == null ? 0.0 : width;
    }

    @Override
    public double getDropShadowWidth(IStylable widget) {
        Double width = (Double)this.select(widget, "drop-shadow-width");
        return width == null ? 0.0 : width;
    }
}

