/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.ui.theme.custom;

import com.tridium.ui.theme.BorderPaneTheme;
import com.tridium.ui.theme.custom.CustomPaneTheme;
import com.tridium.ui.theme.custom.nss.NSS;
import javax.baja.gx.Graphics;
import javax.baja.ui.pane.BBorderPane;

public class CustomBorderPaneTheme
extends CustomPaneTheme
implements BorderPaneTheme {
    private double width = 2.0;

    public CustomBorderPaneTheme() {
        NSS nss = CustomBorderPaneTheme.getNSS();
        this.regFallbackValue(nss, "width", "pane border-pane width", "2");
    }

    @Override
    String getNSSSelector() {
        return "pane border-pane";
    }

    @Override
    public double getWidth() {
        return this.width;
    }

    public void setWidth(double width) {
        this.width = width;
    }

    @Override
    public void paintBorder(Graphics g, BBorderPane pane, double x1, double y1, double x2, double y2, double xBreak1, double xBreak2) {
        if (xBreak1 > 0.0) {
            g.setBrush(this.getControlShadow(pane));
            g.strokeLine(x1, y1, xBreak1, y1);
            g.strokeLine(xBreak2, y1, x2 - 1.0, y1);
            g.setBrush(this.getControlHighlight(pane));
            g.strokeLine(x1 + 1.0, y1 + 1.0, xBreak1, y1 + 1.0);
            g.strokeLine(xBreak2, y1 + 1.0, x2 - 1.0, y1 + 1.0);
        } else {
            g.setBrush(this.getControlShadow(pane));
            g.strokeLine(x1, y1, x2 - 1.0, y1);
            g.setBrush(this.getControlHighlight(pane));
            g.strokeLine(x1 + 1.0, y1 + 1.0, x2 - 1.0, y1 + 1.0);
        }
        g.setBrush(this.getControlHighlight(pane));
        g.strokeLine(x1 + 1.0, y1 + 1.0, x1 + 1.0, y2);
        g.strokeLine(x2, y1 + 1.0, x2, y2);
        g.strokeLine(x1 + 1.0, y2, x2, y2);
        g.setBrush(this.getControlShadow(pane));
        g.strokeLine(x1, y1, x1, y2 - 1.0);
        g.strokeLine(x2 - 1.0, y1 + 1.0, x2 - 1.0, y2 - 1.0);
        g.strokeLine(x1 - 1.0, y2 - 1.0, x2 - 1.0, y2 - 1.0);
    }
}

