/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.ui.theme.curium;

import com.tridium.ui.theme.TreeTheme;
import com.tridium.ui.theme.curium.CuriumWidgetTheme;
import javax.baja.gx.BBrush;
import javax.baja.gx.BColor;
import javax.baja.gx.BFont;
import javax.baja.gx.BInsets;
import javax.baja.gx.Graphics;
import javax.baja.ui.BWidget;

public class CuriumTreeTheme
extends CuriumWidgetTheme
implements TreeTheme {
    static final double ICON_WIDTH = 16.0;
    static final double ICON_HEIGHT = 16.0;
    static final double EXPANDER_WIDTH = 25.0;
    static final double EXPANDER_HEIGHT = 25.0;
    static final BInsets insets = BInsets.make((double)2.0, (double)4.0, (double)2.0, (double)4.0);
    static final BBrush expanderBrush = BColor.black.toBrush();
    static final BBrush connectingBrush = BColor.make((int)192, (int)192, (int)192).toBrush();

    @Override
    public BFont getFont(BWidget tree) {
        return plainText;
    }

    @Override
    public BBrush getForeground(BWidget tree) {
        return windowForeground;
    }

    @Override
    public BBrush getBackground(BWidget tree) {
        return windowBackground;
    }

    @Override
    public BBrush getSelectionForeground() {
        return selectionForeground;
    }

    @Override
    public BBrush getSelectionBackground() {
        return selectionBackground;
    }

    @Override
    public BBrush getConnectingBrush(BWidget tree) {
        return connectingBrush;
    }

    @Override
    public double getExpanderHeight() {
        return 25.0;
    }

    @Override
    public double getExpanderWidth() {
        return 25.0;
    }

    @Override
    public boolean inExpander(double expX, double expY, double x, double y) {
        return x >= expX && x <= expX + 25.0 && y >= expY && y <= expY + 25.0;
    }

    @Override
    public void paintExpander(Graphics g, BWidget tree, double x, double y, boolean expanded) {
        BBrush origBrush = g.getBrush();
        double w = 24.0;
        double h = 24.0;
        g.setBrush(connectingBrush);
        g.strokeLine(x, y, x + w, y);
        g.strokeLine(x, y, x, y + h);
        g.strokeLine(x + w, y, x + w, y + h);
        g.strokeLine(x, y + h, x + w, y + h);
        g.setBrush(expanderBrush);
        double pad = Math.max(8.0, 2.0);
        g.strokeLine(x + pad, y + 12.0, x + (24.0 - pad), y + 12.0);
        if (!expanded) {
            g.strokeLine(x + 12.0, y + pad, x + 12.0, y + (24.0 - pad));
        }
        g.setBrush(origBrush);
    }

    @Override
    public void paintExpander(Graphics g, BWidget tree, double x, double y, boolean isExpandable, boolean isExpanded) {
        this.paintExpander(g, tree, x, y, isExpanded);
    }

    @Override
    public BInsets getInsets() {
        return insets;
    }

    @Override
    public BInsets getInsets(BWidget widget) {
        return insets;
    }
}

