/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.ui.file;

import com.tridium.ui.file.FileChooserModel;
import java.util.ArrayList;
import javax.baja.file.BFileSpace;
import javax.baja.file.BIDirectory;
import javax.baja.file.BIFile;
import javax.baja.file.FilePath;
import javax.baja.gx.BImage;
import javax.baja.nav.BINavNode;
import javax.baja.nav.BNavRoot;
import javax.baja.nre.annotations.Generated;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.space.BSpace;
import javax.baja.sys.BIcon;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.ui.event.BMouseEvent;
import javax.baja.ui.tree.BTree;
import javax.baja.ui.tree.TreeController;
import javax.baja.ui.tree.TreeModel;
import javax.baja.ui.tree.TreeNode;

@NiagaraType
public class BTreeView
extends BTree {
    @Generated
    public static final Type TYPE = Sys.loadType(BTreeView.class);
    FileChooserModel fileModel;
    Model model;
    boolean selector;

    @Override
    @Generated
    public Type getType() {
        return TYPE;
    }

    public BTreeView(FileChooserModel fileModel) {
        this.fileModel = fileModel;
        this.model = new Model(fileModel.getSpace());
        this.setModel(this.model);
        this.setController(new Controller());
        this.setSelector(false);
    }

    public BTreeView() {
    }

    public boolean getSelector() {
        return this.selector;
    }

    public void setSelector(boolean v) {
        this.selector = v;
    }

    public void scrollToVisible(BINavNode nav) {
        if (this.model.root.space != this.fileModel.getSpace()) {
            this.model = new Model(this.fileModel.getSpace());
            this.setModel(this.model);
            this.relayout();
        }
        ArrayList<BINavNode> path = new ArrayList<BINavNode>();
        BINavNode parent = nav;
        while (parent != null) {
            path.add(parent);
            BINavNode node = parent.getNavParent();
            if (node instanceof BINavNode) {
                parent = node;
                continue;
            }
            parent = null;
        }
        Node treeNode = this.model.root;
        block1: for (int i = path.size() - 1; i >= 0; --i) {
            for (int j = 0; j < ((Node)treeNode).getChildCount(); ++j) {
                String yname;
                String xname = ((BINavNode)path.get(i)).getNavName();
                if (!xname.equals(yname = ((Node)((Node)treeNode).getChild((int)j)).file.getNavName()) || path.get(i) instanceof BNavRoot) continue;
                treeNode = (Node)((Node)treeNode).getChild(j);
                continue block1;
            }
        }
        if (this.getSelection().getNode() != treeNode && treeNode.file instanceof BIFile) {
            this.scrollNodeToVisible(treeNode);
            this.getSelection().select(treeNode);
            if (this.getSelector()) {
                this.fileModel.deselectAll();
                this.fileModel.select((BIFile)treeNode.file);
            }
            treeNode.setExpanded(true);
        }
    }

    public BINavNode getFileForNode(TreeNode n) {
        return n == null || !(n instanceof Node) ? null : ((Node)n).file;
    }

    public class Node
    extends TreeNode {
        BINavNode file;
        Node[] kids;

        public Node(TreeModel model, BINavNode file) {
            super(model);
            this.file = file;
        }

        public Node(TreeNode parent, BINavNode file) {
            super(parent);
            this.file = file;
        }

        @Override
        public String getText() {
            return this.file.getNavDisplayName(null);
        }

        @Override
        public BImage getIcon() {
            return BImage.make((BIcon)this.file.getNavIcon());
        }

        @Override
        public Object getSubject() {
            return this.file;
        }

        @Override
        public boolean hasChildren() {
            if (this.kids == null) {
                return true;
            }
            return this.kids.length > 0;
        }

        @Override
        public int getChildCount() {
            if (this.kids == null) {
                this.getChild(-1);
            }
            return this.kids.length;
        }

        @Override
        public TreeNode getChild(int index) {
            if (this.kids == null) {
                int i;
                BINavNode[] files = this.file.getNavChildren();
                ArrayList<BINavNode> list = new ArrayList<BINavNode>();
                for (i = 0; i < files.length; ++i) {
                    if (files[i] instanceof BIDirectory) {
                        list.add(files[i]);
                        continue;
                    }
                    if (files[i] instanceof BIFile) continue;
                    list.add(files[i]);
                }
                this.kids = new Node[list.size()];
                for (i = 0; i < list.size(); ++i) {
                    this.kids[i] = new Node(this, (BINavNode)list.get(i));
                }
            }
            return index == -1 ? null : this.kids[index];
        }
    }

    class Root
    extends Node {
        BSpace space;
        Node[] kids;

        public Root(TreeModel model, BSpace space) {
            super(model, null);
            this.space = space;
        }

        @Override
        public String getText() {
            return this.space.getNavDisplayName(null);
        }

        @Override
        public BImage getIcon() {
            return BImage.make((BIcon)this.space.getNavIcon());
        }

        @Override
        public Object getSubject() {
            return this.space;
        }

        @Override
        public boolean hasChildren() {
            if (this.kids == null) {
                return true;
            }
            return this.kids.length > 0;
        }

        @Override
        public int getChildCount() {
            if (this.kids == null) {
                this.getChild(-1);
            }
            return this.kids.length;
        }

        @Override
        public TreeNode getChild(int index) {
            if (this.kids == null) {
                int i;
                BINavNode[] files = this.space.getNavChildren();
                ArrayList<BINavNode> list = new ArrayList<BINavNode>();
                for (i = 0; i < files.length; ++i) {
                    if (files[i] instanceof BIDirectory) {
                        list.add(files[i]);
                        continue;
                    }
                    if (files[i] instanceof BIFile) continue;
                    list.add(files[i]);
                }
                this.kids = new Node[list.size()];
                for (i = 0; i < list.size(); ++i) {
                    this.kids[i] = new Node(this, (BINavNode)list.get(i));
                }
            }
            return index == -1 ? null : this.kids[index];
        }
    }

    class Model
    extends TreeModel {
        Root root;

        public Model(BSpace space) {
            this.root = new Root((TreeModel)this, space);
            this.root.setExpanded(true);
        }

        @Override
        public int getRootCount() {
            return 1;
        }

        @Override
        public TreeNode getRoot(int index) {
            return this.root;
        }
    }

    class Controller
    extends TreeController {
        Controller() {
        }

        @Override
        protected void mouseSelection(TreeNode target, BMouseEvent evt) {
            super.mouseSelection(target, evt);
            if (target != null && BTreeView.this.getSelector()) {
                BINavNode file = null;
                if (target instanceof Root) {
                    BSpace space = ((Root)target).space;
                    if (space.getType().toString().equals("fox:FoxFileSpace")) {
                        file = ((BFileSpace)space).findFile(new FilePath("^"));
                    }
                } else {
                    file = ((Node)target).file;
                }
                if (file instanceof BIFile) {
                    BTreeView.this.fileModel.deselectAll();
                    BTreeView.this.fileModel.select((BIFile)file);
                }
            }
        }

        @Override
        protected void doSelectAction(TreeNode target, double x, double y) {
            BINavNode file = ((Node)target).file;
            if (BTreeView.this.getSelector() && file instanceof BIFile) {
                BTreeView.this.fileModel.deselectAll();
                BTreeView.this.fileModel.select((BIFile)file);
                BTreeView.this.fileModel.chooseSelectedFiles();
            }
        }
    }
}

