/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.ui.file;

import com.tridium.ui.file.FileChooserModel;
import com.tridium.ui.theme.Theme;
import javax.baja.gx.BColor;
import javax.baja.gx.BFont;
import javax.baja.gx.BInsets;
import javax.baja.gx.Graphics;
import javax.baja.gx.RectGeom;
import javax.baja.nav.BINavNode;
import javax.baja.nre.annotations.Generated;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.space.BISpace;
import javax.baja.space.BSpace;
import javax.baja.sys.BModule;
import javax.baja.sys.BModuleSpace;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.ui.BWidget;
import javax.baja.ui.MouseCursor;
import javax.baja.ui.event.BMouseEvent;
import javax.baja.ui.util.UiLexicon;

@NiagaraType
public class BFilePathBar
extends BWidget {
    @Generated
    public static final Type TYPE = Sys.loadType(BFilePathBar.class);
    static BInsets insets = BInsets.make((double)3.0, (double)6.0, (double)3.0, (double)6.0);
    static final char separatorChar = '/';
    FileChooserModel model;
    RectGeom[] bounds;
    int buttonSize = 16;
    RectGeom leftButton = new RectGeom();
    RectGeom rightButton = new RectGeom();
    boolean leftButtonEnabled = false;
    boolean rightButtonEnabled = false;
    int offset = 0;
    int armed = -1;
    int pressed = -1;
    MouseCursor origCursor;

    @Override
    @Generated
    public Type getType() {
        return TYPE;
    }

    public BFilePathBar(FileChooserModel model) {
        this.model = model;
    }

    public BFilePathBar() {
    }

    @Override
    public void computePreferredSize() {
        BFont font = Theme.widget().getTextFont();
        int w = 200;
        double h = (font.getHeight() + BFilePathBar.insets.top + BFilePathBar.insets.bottom) * 2.0;
        this.setPreferredSize(w, h);
    }

    @Override
    public void doLayout(BWidget[] kids) {
        BSpace space = this.model.getSpace();
        BINavNode[] path = this.model.getPath();
        this.bounds = new RectGeom[path.length];
        BFont font = Theme.widget().getTextFont();
        double x = BFilePathBar.insets.left;
        double y = font.getHeight() + BFilePathBar.insets.top * 2.0 + BFilePathBar.insets.bottom;
        for (int i = this.offset; i < path.length; ++i) {
            String name = "";
            if (i > 0) {
                name = name + " ";
                if (!this.isLeadingChar(path[i - 1].getNavName())) {
                    name = name + "/ ";
                }
            }
            if (i == 0 && (this.model.getSpace() instanceof BModuleSpace || BModule.isModuleFileSpace((BISpace)this.model.getSpace()))) {
                BModule module = (BModule)BModule.getModule((BISpace)this.model.getSpace()).get();
                name = name + module.getModuleName();
            } else {
                name = name + path[i].getNavName();
            }
            this.bounds[i] = new RectGeom(x, y, font.width(name), font.getHeight());
            x += this.bounds[i].width;
        }
    }

    private boolean isLeadingChar(String s) {
        return s.equals("!") || s.equals("^") || s.equals("~");
    }

    @Override
    public void paint(Graphics g) {
        g.setBrush(Theme.widget().getWindowBackground());
        g.fillRect(0.0, 0.0, this.getWidth() - 1.0, this.getHeight() - 1.0);
        BINavNode[] path = this.model.getPath();
        BFont font = Theme.widget().getBoldText();
        double ascent = font.getAscent();
        double x = 0.0;
        double y = font.getHeight() + BFilePathBar.insets.top * 2.0 + BFilePathBar.insets.bottom;
        g.setFont(font);
        g.setBrush(Theme.pathBar().getControlBackground());
        g.fillRect(0.0, 0.0, this.getWidth() - 1.0, y - BFilePathBar.insets.bottom);
        g.setBrush(BColor.black);
        g.strokeLine(0.0, y - BFilePathBar.insets.bottom, this.getWidth() - 1.0, y - BFilePathBar.insets.bottom);
        g.setBrush(BColor.white);
        g.drawString(UiLexicon.bajaui().getText("fileChooser.currentPath"), BFilePathBar.insets.left, BFilePathBar.insets.top + font.getAscent());
        font = Theme.widget().getTextFont();
        g.setFont(font);
        for (int i = this.offset; i < this.bounds.length; ++i) {
            String prefix = "";
            if (i > 0) {
                prefix = prefix + " ";
                if (!this.isLeadingChar(path[i - 1].getNavName())) {
                    prefix = prefix + "/ ";
                }
            }
            String name = path[i].getNavName();
            if (i == 0 && (this.model.getSpace() instanceof BModuleSpace || BModule.isModuleFileSpace((BISpace)this.model.getSpace()))) {
                BModule module = (BModule)BModule.getModule((BISpace)this.model.getSpace()).get();
                name = module.getModuleName();
            }
            double dx = x + this.bounds[i].x;
            double dy = y + ascent;
            g.setBrush(BColor.black);
            g.drawString(prefix, dx, dy);
            if (this.armed == i) {
                g.setBrush(BColor.blue);
            }
            g.drawString(name, dx += font.width(prefix), dy);
            if (this.armed != i) continue;
            g.strokeLine(dx, dy + 1.0, dx + font.width(name) - 1.0, dy + 1.0);
        }
        if (this.leftButtonEnabled) {
            this.paintLeftButton(g);
        }
        if (this.rightButtonEnabled) {
            this.paintRightButton(g);
        }
        g.setBrush(BColor.black);
        g.strokeRect(0.0, 0.0, this.getWidth() - 1.0, this.getHeight() - 1.0);
    }

    public void paintLeftButton(Graphics g) {
        int i;
        g.setBrush(BColor.white);
        g.translate(this.leftButton.x, this.leftButton.y);
        int size = 4;
        double mid = this.leftButton.height / 2.0;
        double x = (this.leftButton.width - (double)size) / 2.0;
        g.strokeLine(x, mid, x + (double)size, mid);
        for (i = 1; i <= size; ++i) {
            g.strokeLine(x + (double)i, mid - (double)i, x + (double)size, mid - (double)i);
        }
        for (i = 1; i <= size; ++i) {
            g.strokeLine(x + (double)i, mid + (double)i, x + (double)size, mid + (double)i);
        }
        g.translate(-this.leftButton.x, -this.leftButton.y);
    }

    public void paintRightButton(Graphics g) {
        g.setBrush(BColor.white);
        g.translate(this.rightButton.x, this.rightButton.y);
        double mid = this.rightButton.height / 2.0;
        double size = 4.0;
        double x = (this.rightButton.width - size) / 2.0;
        g.strokeLine(x, mid, x + size, mid);
        int i = 1;
        while ((double)i <= size) {
            g.strokeLine(x, mid - (double)i, x + size - (double)i, mid - (double)i);
            ++i;
        }
        i = 1;
        while ((double)i <= size) {
            g.strokeLine(x, mid + (double)i, x + size - (double)i, mid + (double)i);
            ++i;
        }
        g.translate(-this.rightButton.x, -this.rightButton.y);
    }

    @Override
    public void mouseMoved(BMouseEvent event) {
        int old = this.armed;
        for (int i = this.offset; i < this.bounds.length; ++i) {
            if (this.bounds[i] == null || !this.bounds[i].contains(event.getX(), event.getY())) continue;
            if (this.origCursor == null) {
                this.origCursor = this.getMouseCursor();
                this.setMouseCursor(MouseCursor.hand);
            }
            this.armed = this.pressed != -1 ? (this.pressed == i ? i : -1) : i;
            this.repaint();
            return;
        }
        this.setMouseCursor(this.origCursor);
        this.origCursor = null;
        this.armed = -1;
        if (old != this.armed) {
            this.repaint();
        }
    }

    @Override
    public void mouseDragged(BMouseEvent event) {
        this.mouseMoved(event);
    }

    @Override
    public void mouseExited(BMouseEvent event) {
        this.mouseMoved(event);
    }

    @Override
    public void mouseEntered(BMouseEvent event) {
        this.mouseMoved(event);
    }

    @Override
    public void mousePressed(BMouseEvent event) {
        if (this.leftButtonEnabled && this.leftButton.contains(event.getX(), event.getY())) {
            --this.offset;
            if (this.offset < 0) {
                this.offset = 0;
            }
            this.relayout();
        } else if (this.rightButtonEnabled && this.rightButton.contains(event.getX(), event.getY())) {
            ++this.offset;
            if (this.offset > this.bounds.length - 1) {
                this.offset = this.bounds.length - 1;
            }
            this.relayout();
        } else {
            for (int i = this.offset; i < this.bounds.length; ++i) {
                if (!this.bounds[i].contains(event.getX(), event.getY())) continue;
                this.pressed = i;
                this.repaint();
                return;
            }
        }
    }

    @Override
    public void mouseReleased(BMouseEvent event) {
        for (int i = this.offset; i < this.bounds.length; ++i) {
            if (this.bounds[i] == null || !this.bounds[i].contains(event.getX(), event.getY())) continue;
            if (this.pressed != i) break;
            BINavNode[] path = this.model.getPath();
            this.model.setDirectory(path[i]);
            break;
        }
        this.pressed = -1;
    }
}

