/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.ui;

import com.tridium.gx.GxEnv;
import com.tridium.gx.GxEnvListener;
import com.tridium.sys.Nre;
import com.tridium.ui.UiSpy;
import java.security.AccessController;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.baja.nre.annotations.Generated;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.spy.Spy;
import javax.baja.sys.Clock;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.ui.BWidget;
import javax.baja.ui.BWidgetApplication;
import javax.baja.ui.BWidgetShell;

@NiagaraType
public abstract class BNiagaraWidgetApplication
extends BWidgetApplication
implements GxEnvListener {
    @Generated
    public static final Type TYPE = Sys.loadType(BNiagaraWidgetApplication.class);
    private static long lastInputTicks = Clock.ticks();
    protected static final Logger LOGGER = Logger.getLogger("ui.widget");
    public static long animateDelay = AccessController.doPrivileged(() -> Long.getLong("bajaui.animateDelay", 100L));

    @Override
    @Generated
    public Type getType() {
        return TYPE;
    }

    public BNiagaraWidgetApplication() {
        GxEnv.get().setGxEnvListener((GxEnvListener)this);
    }

    public boolean useAntiAlias() {
        return false;
    }

    void animate() {
        BWidgetShell[] shells;
        for (BWidgetShell shell : shells = this.getShells()) {
            try {
                shell.animate();
            }
            catch (Throwable throwable) {
                LOGGER.log(Level.SEVERE, "Throwable occurred during NiagaraWidgetApplication animate", throwable);
            }
        }
    }

    void inactivityCheck() {
        long inactivity = Clock.ticks() - lastInputTicks;
        this.checkInputActivity(inactivity);
    }

    public static void inputActivity() {
        lastInputTicks = Clock.ticks();
    }

    public void checkInputActivity(long inactivity) {
    }

    public void repaintAll() {
        BWidgetShell[] shells;
        for (BWidgetShell shell : shells = this.getShells()) {
            shell.repaint();
        }
    }

    static {
        Spy.ROOT.add("userInterface", (Spy)new UiSpy());
        new AnimateThread().start();
    }

    static class AnimateThread
    extends Thread {
        AnimateThread() {
            super(Nre.mainThreadGroup, "Ui:AnimateThread");
            this.setDaemon(true);
        }

        @Override
        public void run() {
            BNiagaraWidgetApplication app = (BNiagaraWidgetApplication)BWidget.getApplication();
            int count = 0;
            while (true) {
                try {
                    while (true) {
                        Thread.sleep(animateDelay);
                        ++count;
                        if (app == null) continue;
                        app.animate();
                        if (count % 100 != 0) continue;
                        app.inactivityCheck();
                    }
                }
                catch (Throwable throwable) {
                    LOGGER.log(Level.SEVERE, "Throwable occurred during NiagaraWidgetApplication Ui:AnimateThread run", throwable);
                    continue;
                }
                break;
            }
        }
    }
}

