/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.ddf.comm.req.util;

import com.tridium.ddf.IDdfFacetConst;
import com.tridium.ddf.comm.IDdfDataFrame;
import com.tridium.ddf.comm.defaultComm.DdfDefaultCommLexicon;
import com.tridium.ddf.comm.req.BIDdfReadRequest;
import com.tridium.ddf.comm.req.IDdfReadable;
import com.tridium.ddf.comm.req.util.DdfRequestLexicon;
import com.tridium.ddf.comm.rsp.BIDdfReadResponse;
import com.tridium.ddf.comm.rsp.BIDdfResponse;
import com.tridium.ddf.comm.rsp.DdfResponseException;
import javax.baja.sys.BajaRuntimeException;

public class DdfReadRequestUtil
implements IDdfFacetConst {
    public static void processResponse(BIDdfReadRequest ddfReq, BIDdfReadResponse ddfRsp) {
        if (ddfReq.getAutoReadOk()) {
            DdfReadRequestUtil.callReadOk(ddfReq, ddfRsp);
        }
    }

    private static void callReadOk(BIDdfReadRequest ddfReq, BIDdfReadResponse ddfRsp) {
        IDdfReadable[] readableSource = ddfReq.getReadableSource();
        if (readableSource != null) {
            for (int i = 0; i < readableSource.length; ++i) {
                DdfReadRequestUtil.callReadOk(readableSource[i], ddfRsp);
            }
        }
    }

    static void callReadOk(IDdfReadable readable, BIDdfReadResponse readRsp) {
        try {
            readable.readOk(readRsp.parseReadValue(readable));
        }
        catch (Exception e) {
            readable.readFail(DdfDefaultCommLexicon.parseError(e));
        }
    }

    public static void processTimeout(BIDdfReadRequest ddfReq) {
        IDdfReadable[] readableSource;
        if (ddfReq.getAutoReadFailOnTimeout() && (readableSource = ddfReq.getReadableSource()) != null) {
            for (int i = 0; i < readableSource.length; ++i) {
                readableSource[i].readFail(DdfRequestLexicon.requestTimeout);
            }
        }
    }

    public static void processLateResponse(BIDdfReadRequest ddfReq, BIDdfReadResponse ddfRsp) {
        if (ddfReq.getAutoReadOkLate()) {
            DdfReadRequestUtil.callReadOk(ddfReq, ddfRsp);
        }
    }

    public static BIDdfResponse processReceive(BIDdfReadRequest ddfReq, IDdfDataFrame iDdfDataFrame) throws DdfResponseException {
        BIDdfResponse ddfRsp = ddfReq.processReceive(iDdfDataFrame);
        if (ddfRsp == null || ddfRsp instanceof BIDdfReadResponse) {
            return ddfRsp;
        }
        throw new BajaRuntimeException(DdfRequestLexicon.pleaseFixDriver(ddfReq.getType()), (Throwable)new BajaRuntimeException(DdfRequestLexicon.readReqMustUseReadRsp(ddfReq.getType())));
    }

    public static void processErrorResponse(BIDdfReadRequest ddfReq, DdfResponseException errorRsp) {
        IDdfReadable[] readableSource;
        if (ddfReq.getAutoReadFailOnError() && (readableSource = ddfReq.getReadableSource()) != null) {
            for (int i = 0; i < readableSource.length; ++i) {
                readableSource[i].readFail(DdfDefaultCommLexicon.responseError(errorRsp));
            }
        }
    }
}

