/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.ddf.clock;

import com.tridium.ddf.clock.DdfSchedulerTicket;
import java.util.LinkedList;
import java.util.ListIterator;
import javax.baja.nre.annotations.Generated;
import javax.baja.nre.annotations.NiagaraSingleton;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.sys.Action;
import javax.baja.sys.BComponent;
import javax.baja.sys.BRelTime;
import javax.baja.sys.BSingleton;
import javax.baja.sys.BValue;
import javax.baja.sys.Clock;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;

@NiagaraType
@NiagaraSingleton
public class BDdfScheduler
extends BSingleton {
    @Generated
    public static final BDdfScheduler INSTANCE = new BDdfScheduler();
    @Generated
    public static final Type TYPE = Sys.loadType(BDdfScheduler.class);
    private final DdfSchedulerThread ddfSchedulerThread;
    private final LinkedList<DdfSchedulerTicket> outstandingTickets = new LinkedList();

    @Generated
    public Type getType() {
        return TYPE;
    }

    private BDdfScheduler() {
        this.ddfSchedulerThread = new DdfSchedulerThread();
        this.ddfSchedulerThread.start();
    }

    public synchronized Clock.Ticket schedule(BComponent host, BRelTime relTime, Action action, BValue arg) {
        return this.schedule(host, relTime.getMillis(), action, arg);
    }

    public synchronized Clock.Ticket schedule(BComponent host, long relMillis, Action action, BValue arg) {
        DdfSchedulerTicket newTicket = new DdfSchedulerTicket(host, action, arg, Clock.ticks() + relMillis);
        int insertLocation = -1;
        int numTickets = this.outstandingTickets.size();
        if (numTickets > 0) {
            ListIterator walkTickets = this.outstandingTickets.listIterator();
            while (walkTickets.hasNext() && insertLocation == -1) {
                int nextIndex = walkTickets.nextIndex();
                DdfSchedulerTicket nextTicket = (DdfSchedulerTicket)walkTickets.next();
                if (nextTicket.serviceTicks <= newTicket.serviceTicks) continue;
                insertLocation = nextIndex;
            }
        }
        if (insertLocation == -1) {
            this.outstandingTickets.addLast(newTicket);
        } else {
            this.outstandingTickets.add(insertLocation, newTicket);
        }
        ((Object)((Object)this)).notifyAll();
        return newTicket;
    }

    protected synchronized void cancelTicket(DdfSchedulerTicket ticketToCancel) {
        this.outstandingTickets.remove(ticketToCancel);
    }

    protected synchronized void check() {
        long clockTicks = Clock.ticks();
        ListIterator walkTickets = this.outstandingTickets.listIterator();
        while (walkTickets.hasNext()) {
            DdfSchedulerTicket nextTicket = (DdfSchedulerTicket)walkTickets.next();
            if (nextTicket.serviceTicks > clockTicks) break;
            walkTickets.remove();
            nextTicket.invokeAction();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void outerRun() throws InterruptedException {
        while (true) {
            try {
                while (true) {
                    BDdfScheduler bDdfScheduler = this;
                    synchronized (bDdfScheduler) {
                        if (this.outstandingTickets.size() > 0) {
                            DdfSchedulerTicket earliestTicket = this.outstandingTickets.getFirst();
                            long ticksBeforeWaiting = Clock.ticks();
                            if (earliestTicket.serviceTicks > ticksBeforeWaiting) {
                                long shortestWait = earliestTicket.serviceTicks - ticksBeforeWaiting;
                                if (shortestWait < 100L) {
                                    shortestWait = 100L;
                                }
                                ((Object)((Object)this)).wait(shortestWait);
                            }
                        } else {
                            ((Object)((Object)this)).wait();
                        }
                        this.check();
                    }
                }
            }
            catch (InterruptedException ie) {
                throw ie;
            }
            catch (Exception e) {
                System.err.println("BDdfScheduler Detected Exception: " + e);
                e.printStackTrace();
                continue;
            }
            break;
        }
    }

    public class DdfSchedulerThread
    extends Thread {
        DdfSchedulerThread() {
            super("Ddf:Scheduler");
        }

        @Override
        public void run() {
            try {
                BDdfScheduler.this.outerRun();
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
    }
}

