/*
 * Decompiled with CFR 0.152.
 */
package org.baja.ffmpeg;

import com.tridium.nre.platform.OperatingSystemEnum;
import com.tridium.sys.Nre;
import java.io.File;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.logging.Level;
import java.util.logging.Logger;

public class ClientSideNativeLibraryLoader {
    protected static Logger log = Logger.getLogger("ffmpeg.load");
    protected static String bajaBinDirStr;
    protected static File bajaBinDir;
    static boolean nativesLoaded;
    private static final String AVUTIL_VERSION = "59";
    private static final String SWRESAMPLE_VERSION = "5";
    private static final String AVCODEC_VERSION = "61";
    private static final String AVFORMAT_VERSION = "61";
    private static final String SWSCALE_VERSION = "8";

    protected static void findNreBin() {
        File bajaHome = Nre.getNiagaraHome();
        bajaBinDir = new File(bajaHome, "bin");
        bajaBinDir.mkdir();
        bajaBinDirStr = bajaBinDir.getAbsolutePath();
    }

    protected static Boolean loadLibraryFromThisModule(final String libName) {
        if (!OperatingSystemEnum.isOS((OperatingSystemEnum)OperatingSystemEnum.windows)) {
            log.warning("Unsupported OS, skipping library load");
            return false;
        }
        return AccessController.doPrivileged(new PrivilegedAction<Boolean>(){

            @Override
            public Boolean run() {
                if (log.isLoggable(Level.FINE)) {
                    log.fine("Extracting:> " + libName);
                }
                String absLibPath = ClientSideNativeLibraryLoader.extractLibraryFromThisModule(libName);
                if (log.isLoggable(Level.FINE)) {
                    log.fine("JNI Loading:> " + libName);
                }
                try {
                    System.loadLibrary(libName.substring(0, libName.indexOf(".dll")));
                    nativesLoaded = true;
                }
                catch (Throwable e) {
                    log.log(Level.SEVERE, "Could not load the third party dlls... : " + libName + " to client.", e);
                }
                return nativesLoaded;
            }
        });
    }

    protected static String extractLibraryFromThisModule(String libName) {
        return ClientSideNativeLibraryLoader.extractLibraryFromThisModule(bajaBinDir, libName);
    }

    /*
     * Exception decompiling
     */
    protected static String extractLibraryFromThisModule(File destDir, String libName) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 3 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    static {
        nativesLoaded = false;
        ClientSideNativeLibraryLoader.findNreBin();
        ClientSideNativeLibraryLoader.loadLibraryFromThisModule("avutil-59.dll");
        ClientSideNativeLibraryLoader.loadLibraryFromThisModule("swresample-5.dll");
        ClientSideNativeLibraryLoader.loadLibraryFromThisModule("avcodec-61.dll");
        ClientSideNativeLibraryLoader.loadLibraryFromThisModule("avformat-61.dll");
        ClientSideNativeLibraryLoader.loadLibraryFromThisModule("swscale-8.dll");
        ClientSideNativeLibraryLoader.loadLibraryFromThisModule("ffmpeg-wrapper.dll");
    }
}

