/*
 * Decompiled with CFR 0.152.
 */
package com.lynxspring.cellrouter.whitelist;

import com.lynxspring.cellrouter.BCellRouterService;
import com.lynxspring.cellrouter.whitelist.BAllowedIpAddress;
import com.tridium.util.ArrayUtil;
import javax.baja.sys.BBoolean;
import javax.baja.sys.BComponent;
import javax.baja.sys.BObject;
import javax.baja.sys.BValue;
import javax.baja.sys.Context;
import javax.baja.ui.BDialog;
import javax.baja.ui.BToolBar;
import javax.baja.ui.BWidget;
import javax.baja.ui.CommandArtifact;
import javax.baja.ui.event.BMouseEvent;
import javax.baja.ui.treetable.BTreeTable;
import javax.baja.workbench.fieldeditor.BWbFieldEditor;
import javax.baja.workbench.mgr.BAbstractManager;
import javax.baja.workbench.mgr.BLearnTable;
import javax.baja.workbench.mgr.BMgrTable;
import javax.baja.workbench.mgr.BTemplateTable;
import javax.baja.workbench.mgr.MgrController;
import javax.baja.workbench.mgr.MgrEdit;

public class IpWhitelistController
extends MgrController {
    public final MgrController.MgrCommand enableWhitelist;
    public final MgrController.MgrCommand disableWhitelist;
    public final MgrController.MgrCommand addIpAddress;
    public final MgrController.MgrCommand removeIpAddress;
    public final MgrController.MgrCommand updateIpAddress;
    final String ENABLE_WHITELIST_LABEL = "Enable Whitelist";
    final String DISABLE_WHITELIST_LABEL = "Disable Whitelist";

    public IpWhitelistController(BAbstractManager manager) {
        super(manager);
        this.enableWhitelist = new EnableWhitelist((BWidget)manager, "Enable Whitelist" + (this.getService().getRunningOnHelixx() ? " (Deprecated)" : ""));
        this.disableWhitelist = new DisableWhitelist((BWidget)manager, "Disable Whitelist");
        this.addIpAddress = new AddIpAddress((BWidget)manager);
        this.removeIpAddress = new RemoveIpAddress((BWidget)manager);
        this.updateIpAddress = new UpdateIpAddress((BWidget)manager);
        this.enableWhitelist.setFlags(23);
        this.disableWhitelist.setFlags(23);
        this.addIpAddress.setFlags(23);
        this.removeIpAddress.setFlags(23);
        this.updateIpAddress.setFlags(23);
        this.edit.setEnabled(false);
        this.add.setEnabled(false);
    }

    private void updateCommands(boolean activeWhitelist) {
        boolean licensed = ((BBoolean)this.getService().invoke(BCellRouterService.licenseCheck, null)).getBoolean();
        this.enableWhitelist.setEnabled(licensed && !activeWhitelist);
        this.disableWhitelist.setEnabled(licensed && activeWhitelist);
        this.addIpAddress.setEnabled(licensed);
        int[] sel = this.getSelectedRows();
        this.removeIpAddress.setEnabled(licensed && sel.length > 0);
        this.updateIpAddress.setEnabled(licensed && sel.length > 0);
    }

    public void updateCommands() {
        this.updateCommands(this.getService().getWhitelistActive());
    }

    public void cellDoubleClicked(BMgrTable table, BMouseEvent event, int row, int col) {
    }

    public void cellDoubleClicked(BLearnTable table, BMouseEvent event, int row, int col) {
    }

    public void cellDoubleClicked(BTreeTable table, BMouseEvent event, int row, int col) {
    }

    public void cellDoubleClicked(BTemplateTable table, BMouseEvent event, int row, int col) {
    }

    public BToolBar makeToolBar() {
        BToolBar tb = super.makeToolBar();
        tb.setSize(tb.getWidth(), 5000.0);
        return tb;
    }

    protected MgrController.IMgrCommand[] makeCommands() {
        return new MgrController.IMgrCommand[]{this.enableWhitelist, this.disableWhitelist, this.addIpAddress, this.removeIpAddress, this.updateIpAddress};
    }

    protected MgrController.IMgrCommand[] makeTagCommands() {
        return new MgrController.IMgrCommand[0];
    }

    private BCellRouterService getService() {
        BObject obj = this.getManager().getCurrentValue();
        BCellRouterService serv = null;
        serv = obj.getType().is(BCellRouterService.TYPE) ? (BCellRouterService)obj : (BCellRouterService)((BComponent)obj).getParent();
        return serv;
    }

    public CommandArtifact doEnableWhitelist(Context cx) throws Exception {
        String dialogString = null;
        String titleString = null;
        if (!this.getService().getRunningOnHelixx()) {
            dialogString = "It is recommended that you complete your whitelist configuration before continuing. Do you want to activate the IP Address Whitelist?";
            titleString = "Activate Ip Address Whitelist";
        } else {
            dialogString = "Whitelist functionality has been removed in Helixx OS, and activating the whitelist will not cause any IP addresses to be blocked. Continue?";
            titleString = "Activate Ip Address Whitelist (Deprecated)";
        }
        if (BDialog.confirm((BWidget)this.getManager(), (String)titleString, (Object)dialogString) == 4) {
            this.getService().invoke(BCellRouterService.enableIpWhitelist, null);
            this.updateCommands(true);
        }
        return null;
    }

    public CommandArtifact doDisableWhitelist(Context cx) throws Exception {
        this.getService().invoke(BCellRouterService.disableIpWhitelist, null);
        this.updateCommands(false);
        return null;
    }

    public CommandArtifact doAddIpAddress(Context cx) throws Exception {
        BAllowedIpAddress entryToAdd = new BAllowedIpAddress();
        if (BWbFieldEditor.dialog((BWidget)this.getManager(), (String)"New Ip Address", (BObject)entryToAdd) != null) {
            this.getService().invoke(BCellRouterService.addIpAddressToWhitelist, (BValue)entryToAdd);
        }
        return null;
    }

    public CommandArtifact doRemoveIpAddress(Context cx) throws Exception {
        BComponent[] sel = this.getSelectedComponents();
        if (sel.length < 1) {
            return null;
        }
        for (BComponent component : sel) {
            if (!component.getType().is(BAllowedIpAddress.TYPE)) continue;
            BAllowedIpAddress entryToRemove = (BAllowedIpAddress)component;
            this.getService().invoke(BCellRouterService.removeIpAddressFromWhitelist, (BValue)entryToRemove);
        }
        return null;
    }

    public CommandArtifact doUpdateRoute(Context cx) throws Exception {
        BComponent[] sel = this.getSelectedComponents();
        BCellRouterService crService = this.getService();
        if (sel.length == 0) {
            return null;
        }
        MgrEdit edit = this.makeEdit(this.edit.getLabel());
        Object[] orig = new BAllowedIpAddress[]{};
        for (BComponent s : sel) {
            orig = (BAllowedIpAddress[])ArrayUtil.addOne((Object[])orig, (Object)((BAllowedIpAddress)s.newCopy(true)));
        }
        for (int i = 0; i < sel.length; ++i) {
            edit.addRow(sel[i]);
        }
        edit.invoke(cx);
        for (Object oc : orig) {
            crService.invoke(BCellRouterService.removeIpAddressFromWhitelist, (BValue)oc);
        }
        for (int i = 0; i < sel.length; ++i) {
            crService.invoke(BCellRouterService.addIpAddressToWhitelist, (BValue)((BAllowedIpAddress)sel[i]));
        }
        return null;
    }

    class UpdateIpAddress
    extends MgrController.MgrCommand {
        UpdateIpAddress(BWidget owner) {
            super(owner, "Update Whitelisted Address");
        }

        public CommandArtifact doInvoke() throws Exception {
            return IpWhitelistController.this.doUpdateRoute(null);
        }
    }

    class RemoveIpAddress
    extends MgrController.MgrCommand {
        RemoveIpAddress(BWidget owner) {
            super(owner, "Remove Whitelisted Address");
        }

        public CommandArtifact doInvoke() throws Exception {
            return IpWhitelistController.this.doRemoveIpAddress(null);
        }
    }

    class AddIpAddress
    extends MgrController.MgrCommand {
        AddIpAddress(BWidget owner) {
            super(owner, "Add Whitelisted Address");
        }

        public CommandArtifact doInvoke() throws Exception {
            return IpWhitelistController.this.doAddIpAddress(null);
        }
    }

    class DisableWhitelist
    extends MgrController.MgrCommand {
        DisableWhitelist(BWidget owner, String label) {
            super(owner, label);
        }

        public CommandArtifact doInvoke() throws Exception {
            IpWhitelistController.this.doDisableWhitelist(null);
            return null;
        }
    }

    class EnableWhitelist
    extends MgrController.MgrCommand {
        EnableWhitelist(BWidget owner, String label) {
            super(owner, label);
        }

        public CommandArtifact doInvoke() throws Exception {
            IpWhitelistController.this.doEnableWhitelist(null);
            return null;
        }
    }
}

