/*
 * Decompiled with CFR 0.152.
 */
package com.lynxspring.cellrouter;

import com.lynxspring.cellrouter.BCellRouterService;
import com.lynxspring.cellrouter.BRouteRule;
import com.tridium.util.ArrayUtil;
import javax.baja.sys.BBoolean;
import javax.baja.sys.BComponent;
import javax.baja.sys.BObject;
import javax.baja.sys.BValue;
import javax.baja.sys.Context;
import javax.baja.ui.BToolBar;
import javax.baja.ui.BWidget;
import javax.baja.ui.CommandArtifact;
import javax.baja.ui.event.BMouseEvent;
import javax.baja.ui.treetable.BTreeTable;
import javax.baja.workbench.fieldeditor.BWbFieldEditor;
import javax.baja.workbench.mgr.BAbstractManager;
import javax.baja.workbench.mgr.BLearnTable;
import javax.baja.workbench.mgr.BMgrTable;
import javax.baja.workbench.mgr.BTemplateTable;
import javax.baja.workbench.mgr.MgrController;
import javax.baja.workbench.mgr.MgrEdit;

public class CellRouterController
extends MgrController {
    public final MgrController.MgrCommand addRoute;
    public final MgrController.MgrCommand removeRoute;
    public final MgrController.MgrCommand updateRoute;

    public CellRouterController(BAbstractManager manager) {
        super(manager);
        this.addRoute = new AddRoute((BWidget)manager);
        this.removeRoute = new RemoveRoute((BWidget)manager);
        this.updateRoute = new UpdateRoute((BWidget)manager);
        this.addRoute.setFlags(23);
        this.removeRoute.setFlags(23);
        this.updateRoute.setFlags(23);
        this.edit.setEnabled(false);
        this.add.setEnabled(false);
    }

    public void updateCommands() {
        boolean licensed = ((BBoolean)this.getService().invoke(BCellRouterService.licenseCheck, null)).getBoolean();
        this.addRoute.setEnabled(licensed);
        int[] sel = this.getSelectedRows();
        this.removeRoute.setEnabled(licensed && sel.length > 0);
        this.updateRoute.setEnabled(licensed && sel.length > 0);
    }

    public void cellDoubleClicked(BMgrTable table, BMouseEvent event, int row, int col) {
    }

    public void cellDoubleClicked(BLearnTable table, BMouseEvent event, int row, int col) {
    }

    public void cellDoubleClicked(BTreeTable table, BMouseEvent event, int row, int col) {
    }

    public void cellDoubleClicked(BTemplateTable table, BMouseEvent event, int row, int col) {
    }

    public BToolBar makeToolBar() {
        BToolBar tb = super.makeToolBar();
        tb.setSize(tb.getWidth(), 5000.0);
        return tb;
    }

    protected MgrController.IMgrCommand[] makeCommands() {
        return new MgrController.IMgrCommand[]{this.addRoute, this.removeRoute, this.updateRoute};
    }

    protected MgrController.IMgrCommand[] makeTagCommands() {
        return new MgrController.IMgrCommand[0];
    }

    private BCellRouterService getService() {
        BCellRouterService serv = (BCellRouterService)this.getManager().getCurrentValue();
        return serv;
    }

    public CommandArtifact doAddRoute(Context cx) throws Exception {
        BRouteRule ruleToAdd = new BRouteRule();
        if (BWbFieldEditor.dialog((BWidget)this.getManager(), (String)"New Route", (BObject)ruleToAdd) != null) {
            this.getService().invoke(BCellRouterService.addRoute, (BValue)ruleToAdd);
        }
        return null;
    }

    public CommandArtifact doRemoveRoute(Context cx) throws Exception {
        BComponent[] sel = this.getSelectedComponents();
        if (sel.length < 1) {
            return null;
        }
        for (BComponent component : sel) {
            if (!component.getType().is(BRouteRule.TYPE)) continue;
            BRouteRule ruleToRemove = (BRouteRule)component;
            this.getService().invoke(BCellRouterService.removeRoute, (BValue)ruleToRemove);
        }
        return null;
    }

    public CommandArtifact doUpdateRoute(Context cx) throws Exception {
        BComponent[] sel = this.getSelectedComponents();
        BCellRouterService crService = this.getService();
        if (sel.length == 0) {
            return null;
        }
        MgrEdit edit = this.makeEdit(this.edit.getLabel());
        Object[] orig = new BRouteRule[]{};
        for (BComponent s : sel) {
            orig = (BRouteRule[])ArrayUtil.addOne((Object[])orig, (Object)((BRouteRule)s.newCopy(true)));
        }
        for (int i = 0; i < sel.length; ++i) {
            edit.addRow(sel[i]);
        }
        edit.invoke(cx);
        for (Object oc : orig) {
            crService.invoke(BCellRouterService.removeRoute, (BValue)oc);
        }
        for (int i = 0; i < sel.length; ++i) {
            crService.invoke(BCellRouterService.addRoute, (BValue)((BRouteRule)sel[i]));
        }
        return null;
    }

    class UpdateRoute
    extends MgrController.MgrCommand {
        UpdateRoute(BWidget owner) {
            super(owner, "Update Route");
        }

        public CommandArtifact doInvoke() throws Exception {
            return CellRouterController.this.doUpdateRoute(null);
        }
    }

    class RemoveRoute
    extends MgrController.MgrCommand {
        RemoveRoute(BWidget owner) {
            super(owner, "Remove Route");
        }

        public CommandArtifact doInvoke() throws Exception {
            return CellRouterController.this.doRemoveRoute(null);
        }
    }

    class AddRoute
    extends MgrController.MgrCommand {
        AddRoute(BWidget owner) {
            super(owner, "Add Route");
        }

        public CommandArtifact doInvoke() throws Exception {
            return CellRouterController.this.doAddRoute(null);
        }
    }
}

